/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.type;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.lang.runtime.SwitchBootstraps;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.common.Empty;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.ConstraintMetaDefinition;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.YangStmtMapping;
import org.opendaylight.yangtools.yang.model.api.meta.DeclarationReference;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.stmt.BitEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.EnumEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.FractionDigitsEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.LengthEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.PatternEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.RangeEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.RequireInstanceEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.TypeEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.TypeStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.TypedefEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.type.BinaryTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.BitsTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.BooleanTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.DecimalTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.EmptyTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.EnumTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.IdentityrefTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.InstanceIdentifierTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.Int16TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.Int32TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.Int64TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.Int8TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.LeafrefTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.PatternConstraint;
import org.opendaylight.yangtools.yang.model.api.type.RangeRestrictedTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.StringTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.TypeDefinitions;
import org.opendaylight.yangtools.yang.model.api.type.Uint16TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.Uint32TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.Uint64TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.Uint8TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.UnionTypeDefinition;
import org.opendaylight.yangtools.yang.model.ri.stmt.DeclaredStatementDecorators;
import org.opendaylight.yangtools.yang.model.ri.stmt.DeclaredStatements;
import org.opendaylight.yangtools.yang.model.ri.type.BitsTypeBuilder;
import org.opendaylight.yangtools.yang.model.ri.type.EnumerationTypeBuilder;
import org.opendaylight.yangtools.yang.model.ri.type.InstanceIdentifierTypeBuilder;
import org.opendaylight.yangtools.yang.model.ri.type.InvalidLengthConstraintException;
import org.opendaylight.yangtools.yang.model.ri.type.InvalidRangeConstraintException;
import org.opendaylight.yangtools.yang.model.ri.type.LengthRestrictedTypeBuilder;
import org.opendaylight.yangtools.yang.model.ri.type.RangeRestrictedTypeBuilder;
import org.opendaylight.yangtools.yang.model.ri.type.RequireInstanceRestrictedTypeBuilder;
import org.opendaylight.yangtools.yang.model.ri.type.RestrictedTypes;
import org.opendaylight.yangtools.yang.model.ri.type.StringTypeBuilder;
import org.opendaylight.yangtools.yang.parser.api.YangParserConfiguration;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.type.AbstractTypeSupport;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.type.BaseTypeNamespace;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.type.BitsSpecificationSupport;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.type.BuiltinEffectiveStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.type.BuiltinTypeStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.type.Decimal64SpecificationSupport;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.type.EnumSpecificationSupport;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.type.IdentityRefSpecificationSupport;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.type.InstanceIdentifierSpecificationSupport;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.type.LeafrefSpecificationSupport;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.type.TypeEffectiveStatementImpl;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.type.UnionSpecificationSupport;
import org.opendaylight.yangtools.yang.parser.spi.ParserNamespaces;
import org.opendaylight.yangtools.yang.parser.spi.meta.BoundStmtCtx;
import org.opendaylight.yangtools.yang.parser.spi.meta.CommonStmtCtx;
import org.opendaylight.yangtools.yang.parser.spi.meta.EffectiveStmtCtx;
import org.opendaylight.yangtools.yang.parser.spi.meta.InferenceException;
import org.opendaylight.yangtools.yang.parser.spi.meta.ModelActionBuilder;
import org.opendaylight.yangtools.yang.parser.spi.meta.ModelProcessingPhase;
import org.opendaylight.yangtools.yang.parser.spi.meta.NamespaceStmtCtx;
import org.opendaylight.yangtools.yang.parser.spi.meta.StatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.SubstatementValidator;
import org.opendaylight.yangtools.yang.parser.spi.meta.UndeclaredStatementFactory;
import org.opendaylight.yangtools.yang.parser.spi.source.SourceException;

abstract class AbstractTypeStatementSupport
extends AbstractTypeSupport<TypeStatement>
implements UndeclaredStatementFactory<QName, TypeStatement, TypeEffectiveStatement<TypeStatement>> {
    private static final SubstatementValidator SUBSTATEMENT_VALIDATOR = SubstatementValidator.builder((StatementDefinition)YangStmtMapping.TYPE).addOptional((StatementDefinition)YangStmtMapping.BASE).addAny((StatementDefinition)YangStmtMapping.BIT).addAny((StatementDefinition)YangStmtMapping.ENUM).addOptional((StatementDefinition)YangStmtMapping.FRACTION_DIGITS).addOptional((StatementDefinition)YangStmtMapping.LENGTH).addOptional((StatementDefinition)YangStmtMapping.PATH).addAny((StatementDefinition)YangStmtMapping.PATTERN).addOptional((StatementDefinition)YangStmtMapping.RANGE).addOptional((StatementDefinition)YangStmtMapping.REQUIRE_INSTANCE).addAny((StatementDefinition)YangStmtMapping.TYPE).build();
    private static final ImmutableMap<QName, BuiltinEffectiveStatement> STATIC_BUILT_IN_TYPES = ImmutableMap.builder().put((Object)TypeDefinitions.BINARY, (Object)BuiltinEffectiveStatement.BINARY).put((Object)TypeDefinitions.BOOLEAN, (Object)BuiltinEffectiveStatement.BOOLEAN).put((Object)TypeDefinitions.EMPTY, (Object)BuiltinEffectiveStatement.EMPTY).put((Object)TypeDefinitions.INSTANCE_IDENTIFIER, (Object)BuiltinEffectiveStatement.INSTANCE_IDENTIFIER).put((Object)TypeDefinitions.INT8, (Object)BuiltinEffectiveStatement.INT8).put((Object)TypeDefinitions.INT16, (Object)BuiltinEffectiveStatement.INT16).put((Object)TypeDefinitions.INT32, (Object)BuiltinEffectiveStatement.INT32).put((Object)TypeDefinitions.INT64, (Object)BuiltinEffectiveStatement.INT64).put((Object)TypeDefinitions.STRING, (Object)BuiltinEffectiveStatement.STRING).put((Object)TypeDefinitions.UINT8, (Object)BuiltinEffectiveStatement.UINT8).put((Object)TypeDefinitions.UINT16, (Object)BuiltinEffectiveStatement.UINT16).put((Object)TypeDefinitions.UINT32, (Object)BuiltinEffectiveStatement.UINT32).put((Object)TypeDefinitions.UINT64, (Object)BuiltinEffectiveStatement.UINT64).build();
    private final ImmutableMap<String, StatementSupport<?, ?, ?>> dynamicBuiltInTypes;

    AbstractTypeStatementSupport(YangParserConfiguration config) {
        super(config, SUBSTATEMENT_VALIDATOR);
        this.dynamicBuiltInTypes = ImmutableMap.builder().put((Object)TypeDefinitions.BITS.getLocalName(), (Object)new BitsSpecificationSupport(config)).put((Object)TypeDefinitions.DECIMAL64.getLocalName(), (Object)new Decimal64SpecificationSupport(config)).put((Object)TypeDefinitions.ENUMERATION.getLocalName(), (Object)new EnumSpecificationSupport(config)).put((Object)TypeDefinitions.IDENTITYREF.getLocalName(), (Object)IdentityRefSpecificationSupport.rfc6020Instance(config)).put((Object)TypeDefinitions.INSTANCE_IDENTIFIER.getLocalName(), (Object)new InstanceIdentifierSpecificationSupport(config)).put((Object)TypeDefinitions.LEAFREF.getLocalName(), (Object)LeafrefSpecificationSupport.rfc6020Instance(config)).put((Object)TypeDefinitions.UNION.getLocalName(), (Object)new UnionSpecificationSupport(config)).build();
    }

    public final void onFullDefinitionDeclared(final StmtContext.Mutable<QName, TypeStatement, EffectiveStatement<QName, TypeStatement>> stmt) {
        super.onFullDefinitionDeclared(stmt);
        final QName typeQName = (QName)stmt.getArgument();
        BuiltinEffectiveStatement builtin = (BuiltinEffectiveStatement)((Object)STATIC_BUILT_IN_TYPES.get((Object)typeQName));
        if (builtin != null) {
            stmt.addToNs(BaseTypeNamespace.INSTANCE, (Object)Empty.value(), (Object)builtin);
            return;
        }
        ModelActionBuilder typeAction = stmt.newInferenceAction(ModelProcessingPhase.EFFECTIVE_MODEL);
        final ModelActionBuilder.Prerequisite typePrereq = typeAction.requiresCtx(stmt, ParserNamespaces.TYPE, (Object)typeQName, ModelProcessingPhase.EFFECTIVE_MODEL);
        typeAction.mutatesEffectiveCtx(stmt.getParentContext());
        typeAction.apply(new ModelActionBuilder.InferenceAction(){

            public void apply(ModelActionBuilder.InferenceContext ctx) {
                stmt.addToNs(BaseTypeNamespace.INSTANCE, (Object)Empty.value(), typePrereq.resolve(ctx));
            }

            public void prerequisiteFailed(Collection<? extends ModelActionBuilder.Prerequisite<?>> failed) {
                InferenceException.throwIf((boolean)failed.contains(typePrereq), (CommonStmtCtx)stmt, (String)"Type [%s] was not found.", (Object[])new Object[]{typeQName});
            }
        });
    }

    public boolean hasArgumentSpecificSupports() {
        return !this.dynamicBuiltInTypes.isEmpty();
    }

    public StatementSupport<?, ?, ?> getSupportSpecificForArgument(String argument) {
        return (StatementSupport)this.dynamicBuiltInTypes.get((Object)argument);
    }

    public final TypeEffectiveStatement<TypeStatement> createUndeclaredEffective(EffectiveStmtCtx.UndeclaredCurrent<QName, TypeStatement> stmt, Stream<? extends StmtContext<?, ?, ?>> effectiveSubstatements) {
        ImmutableList substatements = this.buildEffectiveSubstatements((EffectiveStmtCtx.Current)stmt, this.statementsToBuild((EffectiveStmtCtx.Current)stmt, effectiveSubstatements.filter(StmtContext::isSupportedToBuildEffective)));
        TypeEffectiveStatement<TypeStatement> typeStmt = AbstractTypeStatementSupport.resolveType(stmt);
        if (substatements.isEmpty()) {
            return typeStmt;
        }
        throw new UnsupportedOperationException("Non-empty undeclared type statements are not implemented yet");
    }

    protected final TypeStatement createDeclared(BoundStmtCtx<QName> ctx, ImmutableList<DeclaredStatement<?>> substatements) {
        TypeStatement builtin;
        if (substatements.isEmpty() && (builtin = BuiltinTypeStatement.lookup(ctx.getRawArgument())) != null) {
            return builtin;
        }
        return DeclaredStatements.createType((String)ctx.getRawArgument(), (QName)((QName)ctx.getArgument()), substatements);
    }

    protected final TypeStatement attachDeclarationReference(TypeStatement stmt, DeclarationReference reference) {
        return DeclaredStatementDecorators.decorateType((TypeStatement)stmt, (DeclarationReference)reference);
    }

    protected EffectiveStatement<QName, TypeStatement> createEffective(EffectiveStmtCtx.Current<QName, TypeStatement> stmt, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        TypeEffectiveStatement<TypeStatement> typeStmt = AbstractTypeStatementSupport.resolveType(stmt);
        if (substatements.isEmpty()) {
            return typeStmt;
        }
        TypeDefinition baseType = typeStmt.getTypeDefinition();
        TypeStatement declared = (TypeStatement)stmt.declared();
        TypeDefinition typeDefinition = baseType;
        Objects.requireNonNull(typeDefinition);
        TypeDefinition typeDefinition2 = typeDefinition;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{BinaryTypeDefinition.class, BitsTypeDefinition.class, BooleanTypeDefinition.class, DecimalTypeDefinition.class, EmptyTypeDefinition.class, EnumTypeDefinition.class, IdentityrefTypeDefinition.class, InstanceIdentifierTypeDefinition.class, Int8TypeDefinition.class, Int16TypeDefinition.class, Int32TypeDefinition.class, Int64TypeDefinition.class, LeafrefTypeDefinition.class, StringTypeDefinition.class, Uint8TypeDefinition.class, Uint16TypeDefinition.class, Uint32TypeDefinition.class, Uint64TypeDefinition.class, UnionTypeDefinition.class}, (Object)typeDefinition2, n)) {
            case 0 -> {
                BinaryTypeDefinition def = (BinaryTypeDefinition)typeDefinition2;
                yield AbstractTypeStatementSupport.createBinary(stmt, def, declared, substatements);
            }
            case 1 -> {
                BitsTypeDefinition def = (BitsTypeDefinition)typeDefinition2;
                yield this.createBits(stmt, def, declared, substatements);
            }
            case 2 -> {
                BooleanTypeDefinition def = (BooleanTypeDefinition)typeDefinition2;
                yield AbstractTypeStatementSupport.createBoolean(stmt, def, declared, substatements);
            }
            case 3 -> {
                DecimalTypeDefinition def = (DecimalTypeDefinition)typeDefinition2;
                yield AbstractTypeStatementSupport.createDecimal(stmt, def, declared, substatements);
            }
            case 4 -> {
                EmptyTypeDefinition def = (EmptyTypeDefinition)typeDefinition2;
                yield AbstractTypeStatementSupport.createEmpty(stmt, def, declared, substatements);
            }
            case 5 -> {
                EnumTypeDefinition def = (EnumTypeDefinition)typeDefinition2;
                yield this.createEnum(stmt, def, declared, substatements);
            }
            case 6 -> {
                IdentityrefTypeDefinition def = (IdentityrefTypeDefinition)typeDefinition2;
                yield AbstractTypeStatementSupport.createIdentityref(stmt, def, declared, substatements);
            }
            case 7 -> {
                InstanceIdentifierTypeDefinition def = (InstanceIdentifierTypeDefinition)typeDefinition2;
                yield AbstractTypeStatementSupport.createInstanceIdentifier(stmt, def, declared, substatements);
            }
            case 8 -> {
                Int8TypeDefinition def = (Int8TypeDefinition)typeDefinition2;
                yield AbstractTypeStatementSupport.createIntegral(stmt, declared, substatements, RestrictedTypes.newInt8Builder((Int8TypeDefinition)def, (QName)AbstractTypeStatementSupport.typeEffectiveQName(stmt)));
            }
            case 9 -> {
                Int16TypeDefinition def = (Int16TypeDefinition)typeDefinition2;
                yield AbstractTypeStatementSupport.createIntegral(stmt, declared, substatements, RestrictedTypes.newInt16Builder((Int16TypeDefinition)def, (QName)AbstractTypeStatementSupport.typeEffectiveQName(stmt)));
            }
            case 10 -> {
                Int32TypeDefinition def = (Int32TypeDefinition)typeDefinition2;
                yield AbstractTypeStatementSupport.createIntegral(stmt, declared, substatements, RestrictedTypes.newInt32Builder((Int32TypeDefinition)def, (QName)AbstractTypeStatementSupport.typeEffectiveQName(stmt)));
            }
            case 11 -> {
                Int64TypeDefinition def = (Int64TypeDefinition)typeDefinition2;
                yield AbstractTypeStatementSupport.createIntegral(stmt, declared, substatements, RestrictedTypes.newInt64Builder((Int64TypeDefinition)def, (QName)AbstractTypeStatementSupport.typeEffectiveQName(stmt)));
            }
            case 12 -> {
                LeafrefTypeDefinition def = (LeafrefTypeDefinition)typeDefinition2;
                yield AbstractTypeStatementSupport.createLeafref(stmt, def, declared, substatements);
            }
            case 13 -> {
                StringTypeDefinition def = (StringTypeDefinition)typeDefinition2;
                yield AbstractTypeStatementSupport.createString(stmt, def, declared, substatements);
            }
            case 14 -> {
                Uint8TypeDefinition def = (Uint8TypeDefinition)typeDefinition2;
                yield AbstractTypeStatementSupport.createIntegral(stmt, declared, substatements, RestrictedTypes.newUint8Builder((Uint8TypeDefinition)def, (QName)AbstractTypeStatementSupport.typeEffectiveQName(stmt)));
            }
            case 15 -> {
                Uint16TypeDefinition def = (Uint16TypeDefinition)typeDefinition2;
                yield AbstractTypeStatementSupport.createIntegral(stmt, declared, substatements, RestrictedTypes.newUint16Builder((Uint16TypeDefinition)def, (QName)AbstractTypeStatementSupport.typeEffectiveQName(stmt)));
            }
            case 16 -> {
                Uint32TypeDefinition def = (Uint32TypeDefinition)typeDefinition2;
                yield AbstractTypeStatementSupport.createIntegral(stmt, declared, substatements, RestrictedTypes.newUint32Builder((Uint32TypeDefinition)def, (QName)AbstractTypeStatementSupport.typeEffectiveQName(stmt)));
            }
            case 17 -> {
                Uint64TypeDefinition def = (Uint64TypeDefinition)typeDefinition2;
                yield AbstractTypeStatementSupport.createIntegral(stmt, declared, substatements, RestrictedTypes.newUint64Builder((Uint64TypeDefinition)def, (QName)AbstractTypeStatementSupport.typeEffectiveQName(stmt)));
            }
            case 18 -> {
                UnionTypeDefinition def = (UnionTypeDefinition)typeDefinition2;
                yield AbstractTypeStatementSupport.createUnion(stmt, def, declared, substatements);
            }
            default -> throw new IllegalStateException("Unhandled base type " + String.valueOf(baseType));
        };
    }

    static final @NonNull QName typeEffectiveQName(EffectiveStmtCtx.Current<QName, ?> stmt) {
        return ((QName)stmt.getArgument()).bindTo(stmt.getEffectiveParent().effectiveNamespace()).intern();
    }

    private static @NonNull TypeEffectiveStatement<TypeStatement> resolveType(NamespaceStmtCtx ctx) {
        Object obj;
        Object object = obj = Verify.verifyNotNull((Object)ctx.namespaceItem(BaseTypeNamespace.INSTANCE, (Object)Empty.value()));
        Objects.requireNonNull(object);
        Object object2 = object;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{BuiltinEffectiveStatement.class, StmtContext.class}, (Object)object2, n)) {
            case 0 -> {
                BuiltinEffectiveStatement builtin;
                yield builtin = (BuiltinEffectiveStatement)((Object)object2);
            }
            case 1 -> {
                StmtContext stmt = (StmtContext)object2;
                yield ((TypedefEffectiveStatement)stmt.buildEffective()).asTypeEffectiveStatement();
            }
            default -> throw new InferenceException((CommonStmtCtx)ctx, "Unexpected base object %s", new Object[]{obj});
        };
    }

    private static @NonNull TypeEffectiveStatement<TypeStatement> createBinary(EffectiveStmtCtx.Current<QName, ?> ctx, BinaryTypeDefinition baseType, TypeStatement declared, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        LengthRestrictedTypeBuilder builder = RestrictedTypes.newBinaryBuilder((BinaryTypeDefinition)baseType, (QName)AbstractTypeStatementSupport.typeEffectiveQName(ctx));
        for (EffectiveStatement stmt : substatements) {
            if (!(stmt instanceof LengthEffectiveStatement)) continue;
            LengthEffectiveStatement length = (LengthEffectiveStatement)stmt;
            try {
                builder.setLengthConstraint((ConstraintMetaDefinition)length, (List)length.argument());
            }
            catch (IllegalStateException e) {
                throw new SourceException(ctx, (Throwable)e, "Multiple length constraints encountered", new Object[0]);
            }
            catch (InvalidLengthConstraintException e) {
                throw new SourceException(ctx, (Throwable)e, "Invalid length constraint %s", new Object[]{length.argument()});
            }
        }
        return new TypeEffectiveStatementImpl(declared, (ImmutableList<? extends EffectiveStatement<?, ?>>)((ImmutableList<EffectiveStatement<?, ?>>)substatements), builder);
    }

    private @NonNull TypeEffectiveStatement<TypeStatement> createBits(EffectiveStmtCtx.Current<?, ?> ctx, BitsTypeDefinition baseType, TypeStatement declared, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        BitsTypeBuilder builder = RestrictedTypes.newBitsBuilder((BitsTypeDefinition)baseType, (QName)ctx.argumentAsTypeQName());
        for (EffectiveStatement stmt : substatements) {
            if (!(stmt instanceof BitEffectiveStatement)) continue;
            BitEffectiveStatement bit = (BitEffectiveStatement)stmt;
            builder.addBit(this.addRestrictedBit((EffectiveStmtCtx)ctx, baseType, bit));
        }
        return new TypeEffectiveStatementImpl(declared, (ImmutableList<? extends EffectiveStatement<?, ?>>)((ImmutableList<EffectiveStatement<?, ?>>)substatements), builder);
    }

    abstract // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull BitsTypeDefinition.Bit addRestrictedBit(@NonNull EffectiveStmtCtx var1, @NonNull BitsTypeDefinition var2, @NonNull BitEffectiveStatement var3);

    private static @NonNull TypeEffectiveStatement<TypeStatement> createBoolean(EffectiveStmtCtx.Current<QName, ?> ctx, BooleanTypeDefinition baseType, TypeStatement declared, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        return new TypeEffectiveStatementImpl(declared, substatements, RestrictedTypes.newBooleanBuilder((BooleanTypeDefinition)baseType, (QName)AbstractTypeStatementSupport.typeEffectiveQName(ctx)));
    }

    private static @NonNull TypeEffectiveStatement<TypeStatement> createDecimal(EffectiveStmtCtx.Current<QName, ?> ctx, DecimalTypeDefinition baseType, TypeStatement declared, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        RangeRestrictedTypeBuilder builder = RestrictedTypes.newDecima64Builder((DecimalTypeDefinition)baseType, (QName)AbstractTypeStatementSupport.typeEffectiveQName(ctx));
        for (EffectiveStatement stmt : substatements) {
            EffectiveStatement effectiveStatement;
            Objects.requireNonNull(stmt);
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{RangeEffectiveStatement.class, FractionDigitsEffectiveStatement.class}, (Object)effectiveStatement, n)) {
                case 0: {
                    RangeEffectiveStatement range = (RangeEffectiveStatement)effectiveStatement;
                    builder.setRangeConstraint((ConstraintMetaDefinition)range, (List)range.argument());
                    break;
                }
                case 1: {
                    FractionDigitsEffectiveStatement fdes = (FractionDigitsEffectiveStatement)effectiveStatement;
                    Integer digits = (Integer)fdes.argument();
                    SourceException.throwIf((baseType.getFractionDigits() != digits.intValue() ? 1 : 0) != 0, ctx, (String)"Cannot override fraction-digits from base type %s to %s", (Object[])new Object[]{baseType, digits});
                    break;
                }
            }
        }
        return new TypeEffectiveStatementImpl(declared, (ImmutableList<? extends EffectiveStatement<?, ?>>)((ImmutableList<EffectiveStatement<?, ?>>)substatements), builder);
    }

    private static @NonNull TypeEffectiveStatement<TypeStatement> createEmpty(EffectiveStmtCtx.Current<QName, ?> ctx, EmptyTypeDefinition baseType, TypeStatement declared, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        return new TypeEffectiveStatementImpl(declared, substatements, RestrictedTypes.newEmptyBuilder((EmptyTypeDefinition)baseType, (QName)AbstractTypeStatementSupport.typeEffectiveQName(ctx)));
    }

    private @NonNull TypeEffectiveStatement<TypeStatement> createEnum(EffectiveStmtCtx.Current<?, ?> ctx, EnumTypeDefinition baseType, TypeStatement declared, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        EnumerationTypeBuilder builder = RestrictedTypes.newEnumerationBuilder((EnumTypeDefinition)baseType, (QName)ctx.argumentAsTypeQName());
        for (EffectiveStatement stmt : substatements) {
            if (!(stmt instanceof EnumEffectiveStatement)) continue;
            EnumEffectiveStatement ees = (EnumEffectiveStatement)stmt;
            builder.addEnum(this.addRestrictedEnum((EffectiveStmtCtx)ctx, baseType, ees));
        }
        return new TypeEffectiveStatementImpl(declared, (ImmutableList<? extends EffectiveStatement<?, ?>>)((ImmutableList<EffectiveStatement<?, ?>>)substatements), builder);
    }

    abstract // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull EnumTypeDefinition.EnumPair addRestrictedEnum(@NonNull EffectiveStmtCtx var1, @NonNull EnumTypeDefinition var2, @NonNull EnumEffectiveStatement var3);

    private static @NonNull TypeEffectiveStatement<TypeStatement> createIdentityref(EffectiveStmtCtx.Current<QName, ?> ctx, IdentityrefTypeDefinition baseType, TypeStatement declared, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        return new TypeEffectiveStatementImpl(declared, substatements, RestrictedTypes.newIdentityrefBuilder((IdentityrefTypeDefinition)baseType, (QName)AbstractTypeStatementSupport.typeEffectiveQName(ctx)));
    }

    private static @NonNull TypeEffectiveStatement<TypeStatement> createInstanceIdentifier(EffectiveStmtCtx.Current<QName, ?> ctx, InstanceIdentifierTypeDefinition baseType, TypeStatement declared, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        InstanceIdentifierTypeBuilder builder = RestrictedTypes.newInstanceIdentifierBuilder((InstanceIdentifierTypeDefinition)baseType, (QName)AbstractTypeStatementSupport.typeEffectiveQName(ctx));
        for (EffectiveStatement stmt : substatements) {
            if (!(stmt instanceof RequireInstanceEffectiveStatement)) continue;
            RequireInstanceEffectiveStatement ries = (RequireInstanceEffectiveStatement)stmt;
            builder.setRequireInstance(((Boolean)ries.argument()).booleanValue());
        }
        return new TypeEffectiveStatementImpl(declared, (ImmutableList<? extends EffectiveStatement<?, ?>>)((ImmutableList<EffectiveStatement<?, ?>>)substatements), builder);
    }

    private static <T extends RangeRestrictedTypeDefinition<T, N>, N extends Number> @NonNull TypeEffectiveStatement<TypeStatement> createIntegral(EffectiveStmtCtx.Current<?, ?> ctx, TypeStatement declared, ImmutableList<? extends EffectiveStatement<?, ?>> substatements, RangeRestrictedTypeBuilder<T, N> builder) {
        for (EffectiveStatement stmt : substatements) {
            if (!(stmt instanceof RangeEffectiveStatement)) continue;
            RangeEffectiveStatement range = (RangeEffectiveStatement)stmt;
            builder.setRangeConstraint((ConstraintMetaDefinition)range, (List)range.argument());
        }
        try {
            return new TypeEffectiveStatementImpl(declared, (ImmutableList<? extends EffectiveStatement<?, ?>>)((ImmutableList<EffectiveStatement<?, ?>>)substatements), builder);
        }
        catch (InvalidRangeConstraintException e) {
            throw new SourceException(ctx, (Throwable)e, "Invalid range constraint: %s", new Object[]{e.getOffendingRanges()});
        }
    }

    private static @NonNull TypeEffectiveStatement<TypeStatement> createLeafref(EffectiveStmtCtx.Current<QName, ?> ctx, LeafrefTypeDefinition baseType, TypeStatement declared, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        RequireInstanceRestrictedTypeBuilder builder = RestrictedTypes.newLeafrefBuilder((LeafrefTypeDefinition)baseType, (QName)AbstractTypeStatementSupport.typeEffectiveQName(ctx));
        for (EffectiveStatement stmt : substatements) {
            if (!(stmt instanceof RequireInstanceEffectiveStatement)) continue;
            RequireInstanceEffectiveStatement ries = (RequireInstanceEffectiveStatement)stmt;
            builder.setRequireInstance(((Boolean)ries.argument()).booleanValue());
        }
        return new TypeEffectiveStatementImpl(declared, (ImmutableList<? extends EffectiveStatement<?, ?>>)((ImmutableList<EffectiveStatement<?, ?>>)substatements), builder);
    }

    private static @NonNull TypeEffectiveStatement<TypeStatement> createString(EffectiveStmtCtx.Current<QName, ?> ctx, StringTypeDefinition baseType, TypeStatement declared, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        StringTypeBuilder builder = RestrictedTypes.newStringBuilder((StringTypeDefinition)baseType, (QName)AbstractTypeStatementSupport.typeEffectiveQName(ctx));
        for (EffectiveStatement stmt : substatements) {
            EffectiveStatement effectiveStatement;
            Objects.requireNonNull(stmt);
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{LengthEffectiveStatement.class, PatternEffectiveStatement.class}, (Object)effectiveStatement, n)) {
                case 0: {
                    LengthEffectiveStatement length = (LengthEffectiveStatement)effectiveStatement;
                    try {
                        builder.setLengthConstraint((ConstraintMetaDefinition)length, (List)length.argument());
                        break;
                    }
                    catch (IllegalStateException e) {
                        throw new SourceException(ctx, (Throwable)e, "Multiple length constraints encountered", new Object[0]);
                    }
                    catch (InvalidLengthConstraintException e) {
                        throw new SourceException(ctx, (Throwable)e, "Invalid length constraint %s", new Object[]{length.argument()});
                    }
                }
                case 1: {
                    PatternEffectiveStatement pattern = (PatternEffectiveStatement)effectiveStatement;
                    builder.addPatternConstraint((PatternConstraint)pattern);
                    break;
                }
            }
        }
        return new TypeEffectiveStatementImpl(declared, (ImmutableList<? extends EffectiveStatement<?, ?>>)((ImmutableList<EffectiveStatement<?, ?>>)substatements), builder);
    }

    private static @NonNull TypeEffectiveStatement<TypeStatement> createUnion(EffectiveStmtCtx.Current<QName, ?> ctx, UnionTypeDefinition baseType, TypeStatement declared, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        return new TypeEffectiveStatementImpl(declared, substatements, RestrictedTypes.newUnionBuilder((UnionTypeDefinition)baseType, (QName)AbstractTypeStatementSupport.typeEffectiveQName(ctx)));
    }
}

