/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.type;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.UnmodifiableIterator;
import java.lang.runtime.SwitchBootstraps;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.PathExpression;
import org.opendaylight.yangtools.yang.model.api.YangStmtMapping;
import org.opendaylight.yangtools.yang.model.api.meta.DeclarationReference;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.stmt.PathEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.RequireInstanceEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.TypeStatement;
import org.opendaylight.yangtools.yang.model.ri.type.BaseTypes;
import org.opendaylight.yangtools.yang.model.ri.type.LeafrefTypeBuilder;
import org.opendaylight.yangtools.yang.parser.api.YangParserConfiguration;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.type.AbstractTypeSupport;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.type.LeafrefSpecificationImpl;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.type.RefLeafrefSpecification;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.type.TypeEffectiveStatementImpl;
import org.opendaylight.yangtools.yang.parser.spi.meta.BoundStmtCtx;
import org.opendaylight.yangtools.yang.parser.spi.meta.CommonStmtCtx;
import org.opendaylight.yangtools.yang.parser.spi.meta.EffectiveStmtCtx;
import org.opendaylight.yangtools.yang.parser.spi.meta.SubstatementValidator;
import org.opendaylight.yangtools.yang.parser.spi.source.SourceException;

final class LeafrefSpecificationSupport
extends AbstractTypeSupport<TypeStatement.LeafrefSpecification> {
    private static final SubstatementValidator RFC6020_VALIDATOR = SubstatementValidator.builder((StatementDefinition)YangStmtMapping.TYPE).addMandatory((StatementDefinition)YangStmtMapping.PATH).build();
    private static final SubstatementValidator RFC7950_VALIDATOR = SubstatementValidator.builder((StatementDefinition)YangStmtMapping.TYPE).addMandatory((StatementDefinition)YangStmtMapping.PATH).addOptional((StatementDefinition)YangStmtMapping.REQUIRE_INSTANCE).build();

    private LeafrefSpecificationSupport(YangParserConfiguration config, SubstatementValidator validator) {
        super(config, validator);
    }

    static LeafrefSpecificationSupport rfc6020Instance(YangParserConfiguration config) {
        return new LeafrefSpecificationSupport(config, RFC6020_VALIDATOR);
    }

    static LeafrefSpecificationSupport rfc7950Instance(YangParserConfiguration config) {
        return new LeafrefSpecificationSupport(config, RFC7950_VALIDATOR);
    }

    protected TypeStatement.LeafrefSpecification createDeclared(BoundStmtCtx<QName> ctx, ImmutableList<DeclaredStatement<?>> substatements) {
        if (substatements.isEmpty()) {
            throw LeafrefSpecificationSupport.noPath(ctx);
        }
        return new LeafrefSpecificationImpl(ctx.getRawArgument(), (QName)ctx.getArgument(), substatements);
    }

    protected TypeStatement.LeafrefSpecification attachDeclarationReference(TypeStatement.LeafrefSpecification stmt, DeclarationReference reference) {
        return new RefLeafrefSpecification(stmt, reference);
    }

    protected EffectiveStatement<QName, TypeStatement.LeafrefSpecification> createEffective(EffectiveStmtCtx.Current<QName, TypeStatement.LeafrefSpecification> stmt, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        if (substatements.isEmpty()) {
            throw LeafrefSpecificationSupport.noPath(stmt);
        }
        LeafrefTypeBuilder builder = BaseTypes.leafrefTypeBuilder((QName)stmt.argumentAsTypeQName());
        UnmodifiableIterator unmodifiableIterator = substatements.iterator();
        while (unmodifiableIterator.hasNext()) {
            EffectiveStatement subStmt;
            EffectiveStatement effectiveStatement = subStmt = (EffectiveStatement)unmodifiableIterator.next();
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{PathEffectiveStatement.class, RequireInstanceEffectiveStatement.class}, (Object)effectiveStatement, n)) {
                case 0: {
                    PathEffectiveStatement path = (PathEffectiveStatement)effectiveStatement;
                    builder.setPathStatement((PathExpression)path.argument());
                    break;
                }
                case 1: {
                    RequireInstanceEffectiveStatement ries = (RequireInstanceEffectiveStatement)effectiveStatement;
                    builder.setRequireInstance(((Boolean)ries.argument()).booleanValue());
                    break;
                }
            }
        }
        return new TypeEffectiveStatementImpl((TypeStatement.LeafrefSpecification)stmt.declared(), (ImmutableList<? extends EffectiveStatement<?, ?>>)((ImmutableList<EffectiveStatement<?, ?>>)substatements), builder);
    }

    private static SourceException noPath(CommonStmtCtx stmt) {
        return new SourceException("A path statement has to be present", stmt);
    }
}

