/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.ir;

import com.google.common.annotations.Beta;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.ir.AbstractIRObject;

@Beta
public abstract sealed class IRKeyword
extends AbstractIRObject {
    private final @NonNull String identifier;

    IRKeyword(String localName) {
        this.identifier = Objects.requireNonNull(localName);
    }

    public final @NonNull String identifier() {
        return this.identifier;
    }

    public abstract @Nullable String prefix();

    public abstract @NonNull String asStringDeclaration();

    @Override
    public final int hashCode() {
        return Objects.hashCode(this.prefix()) * 31 + this.identifier.hashCode();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public final boolean equals(Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof IRKeyword)) return false;
        IRKeyword other = (IRKeyword)obj;
        if (!this.identifier.equals(other.identifier)) return false;
        if (!Objects.equals(this.prefix(), other.prefix())) return false;
        return true;
    }

    public static final class Unqualified
    extends IRKeyword {
        private Unqualified(String localName) {
            super(localName);
        }

        public static @NonNull Unqualified of(String localName) {
            return new Unqualified(localName);
        }

        @Override
        public String prefix() {
            return null;
        }

        @Override
        public String asStringDeclaration() {
            return this.identifier();
        }

        @Override
        StringBuilder toYangFragment(StringBuilder sb) {
            return sb.append(this.identifier());
        }
    }

    public static final class Qualified
    extends IRKeyword {
        private final @NonNull String prefix;

        private Qualified(String prefix, String localName) {
            super(localName);
            this.prefix = Objects.requireNonNull(prefix);
        }

        public static @NonNull Qualified of(String prefix, String localName) {
            return new Qualified(prefix, localName);
        }

        @Override
        public @NonNull String prefix() {
            return this.prefix;
        }

        @Override
        public String asStringDeclaration() {
            return this.prefix + ":" + this.identifier();
        }

        @Override
        StringBuilder toYangFragment(StringBuilder sb) {
            return sb.append(this.prefix).append(':').append(this.identifier());
        }
    }
}

