/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.access.client;

import akka.actor.AbstractActor;
import akka.actor.ActorRef;
import akka.actor.PoisonPill;
import akka.persistence.AbstractPersistentActor;
import com.google.common.annotations.VisibleForTesting;
import java.nio.file.Path;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.controller.cluster.access.client.AbstractClientActorBehavior;
import org.opendaylight.controller.cluster.access.client.ClientActorBehavior;
import org.opendaylight.controller.cluster.access.client.ClientActorConfig;
import org.opendaylight.controller.cluster.access.client.ClientActorContext;
import org.opendaylight.controller.cluster.access.client.RecoveringClientActorBehavior;
import org.opendaylight.controller.cluster.access.concepts.FrontendIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractClientActor
extends AbstractPersistentActor {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractClientActor.class);
    private static final Path STATE_PATH = Path.of("state", new String[0]);
    private final @NonNull String persistenceId;
    private AbstractClientActorBehavior<?> currentBehavior;

    protected AbstractClientActor(FrontendIdentifier frontendId) {
        this(STATE_PATH, frontendId);
    }

    @VisibleForTesting
    protected AbstractClientActor(Path statePath, FrontendIdentifier frontendId) {
        this.persistenceId = frontendId.toPersistentId();
        this.currentBehavior = new RecoveringClientActorBehavior(statePath, this, this.persistenceId, frontendId);
    }

    public final String persistenceId() {
        return this.persistenceId;
    }

    public void postStop() throws Exception {
        if (this.currentBehavior != null) {
            this.currentBehavior.close();
        }
        super.postStop();
    }

    private void switchBehavior(AbstractClientActorBehavior<?> nextBehavior) {
        if (!this.currentBehavior.equals(nextBehavior)) {
            if (nextBehavior == null) {
                LOG.debug("{}: shutting down", (Object)this.persistenceId);
                this.self().tell((Object)PoisonPill.getInstance(), ActorRef.noSender());
            } else {
                LOG.debug("{}: switched from {} to {}", new Object[]{this.persistenceId, this.currentBehavior, nextBehavior});
            }
            this.currentBehavior.close();
            this.currentBehavior = nextBehavior;
        }
    }

    public AbstractActor.Receive createReceive() {
        return this.receiveBuilder().matchAny(this::onReceiveCommand).build();
    }

    public AbstractActor.Receive createReceiveRecover() {
        return this.receiveBuilder().matchAny(this::onReceiveRecover).build();
    }

    private void onReceiveCommand(Object command) {
        if (command == null) {
            LOG.debug("{}: ignoring null command", (Object)this.persistenceId);
            return;
        }
        if (this.currentBehavior != null) {
            this.switchBehavior(this.currentBehavior.onReceiveCommand(command));
        } else {
            LOG.debug("{}: shutting down, ignoring command {}", (Object)this.persistenceId, command);
        }
    }

    private void onReceiveRecover(Object recover) {
        this.switchBehavior(this.currentBehavior.onReceiveRecover(recover));
    }

    protected abstract ClientActorBehavior<?> initialBehavior(ClientActorContext var1);

    protected abstract ClientActorConfig getClientActorConfig();
}

