/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.access.client;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.Cancellable;
import akka.actor.Scheduler;
import com.google.common.base.Ticker;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.controller.cluster.access.client.AbstractClientActorContext;
import org.opendaylight.controller.cluster.access.client.BackendInfo;
import org.opendaylight.controller.cluster.access.client.ClientActorConfig;
import org.opendaylight.controller.cluster.access.client.InternalCommand;
import org.opendaylight.controller.cluster.access.concepts.ClientIdentifier;
import org.opendaylight.controller.cluster.common.actor.Dispatchers;
import org.opendaylight.controller.cluster.io.FileBackedOutputStreamFactory;
import org.opendaylight.controller.cluster.messaging.MessageSlicer;
import org.opendaylight.yangtools.concepts.Identifiable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.FiniteDuration;

public class ClientActorContext
extends AbstractClientActorContext
implements Identifiable<ClientIdentifier> {
    private final ExecutionContext executionContext;
    private final ClientIdentifier identifier;
    private final Scheduler scheduler;
    private final Dispatchers dispatchers;
    private final ClientActorConfig config;
    private final MessageSlicer messageSlicer;

    ClientActorContext(ActorRef self, String persistenceId, ActorSystem system, ClientIdentifier identifier, ClientActorConfig config) {
        super(self, persistenceId);
        this.identifier = Objects.requireNonNull(identifier);
        this.scheduler = Objects.requireNonNull(system).scheduler();
        this.executionContext = system.dispatcher();
        this.dispatchers = new Dispatchers(system.dispatchers());
        this.config = Objects.requireNonNull(config);
        this.messageSlicer = MessageSlicer.builder().messageSliceSize(config.getMaximumMessageSliceSize()).logContext(persistenceId).expireStateAfterInactivity(config.getRequestTimeout(), TimeUnit.NANOSECONDS).fileBackedStreamFactory(new FileBackedOutputStreamFactory(config.getFileBackedStreamingThreshold(), config.getTempFileDirectory())).build();
    }

    public ClientIdentifier getIdentifier() {
        return this.identifier;
    }

    public @NonNull ClientActorConfig config() {
        return this.config;
    }

    public @NonNull Dispatchers dispatchers() {
        return this.dispatchers;
    }

    public @NonNull MessageSlicer messageSlicer() {
        return this.messageSlicer;
    }

    public @NonNull Ticker ticker() {
        return Ticker.systemTicker();
    }

    public <T extends BackendInfo> void executeInActor(@NonNull InternalCommand<T> command) {
        this.self().tell(Objects.requireNonNull(command), ActorRef.noSender());
    }

    public <T extends BackendInfo> Cancellable executeInActor(@NonNull InternalCommand<T> command, FiniteDuration delay) {
        return this.scheduler.scheduleOnce(Objects.requireNonNull(delay), this.self(), Objects.requireNonNull(command), this.executionContext, ActorRef.noSender());
    }
}

