/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.access.client;

import akka.persistence.SnapshotSelectionCriteria;
import java.util.Objects;
import org.opendaylight.controller.cluster.access.client.AbstractClientActor;
import org.opendaylight.controller.cluster.access.client.AbstractClientActorContext;
import org.opendaylight.controller.cluster.access.client.ClientActorBehavior;
import org.opendaylight.controller.cluster.access.client.ClientActorContext;
import org.opendaylight.controller.cluster.access.client.PersistenceTombstone;
import org.opendaylight.controller.cluster.access.concepts.ClientIdentifier;

final class InitialClientActorContext
extends AbstractClientActorContext {
    private final AbstractClientActor actor;

    InitialClientActorContext(AbstractClientActor actor, String persistenceId) {
        super(actor.self(), persistenceId);
        this.actor = Objects.requireNonNull(actor);
    }

    void saveSnapshot(ClientIdentifier clientId) {
        this.actor.saveSnapshot(new PersistenceTombstone(clientId));
    }

    void deleteSnapshots(SnapshotSelectionCriteria criteria) {
        this.actor.deleteSnapshots(criteria);
    }

    ClientActorBehavior<?> createBehavior(ClientIdentifier clientId) {
        return this.actor.initialBehavior(new ClientActorContext(this.self(), this.persistenceId(), this.actor.getContext().system(), clientId, this.actor.getClientActorConfig()));
    }

    void stash() {
        this.actor.stash();
    }

    void unstash() {
        this.actor.unstashAll();
    }
}

