/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.access.client;

import akka.persistence.RecoveryCompleted;
import akka.persistence.SnapshotOffer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.runtime.SwitchBootstraps;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import java.util.Properties;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.controller.cluster.access.client.AbstractClientActor;
import org.opendaylight.controller.cluster.access.client.AbstractClientActorBehavior;
import org.opendaylight.controller.cluster.access.client.ClientActorBehavior;
import org.opendaylight.controller.cluster.access.client.InitialClientActorContext;
import org.opendaylight.controller.cluster.access.client.PersistenceTombstone;
import org.opendaylight.controller.cluster.access.client.RecoveryException;
import org.opendaylight.controller.cluster.access.client.SavingClientActorBehavior;
import org.opendaylight.controller.cluster.access.concepts.ClientIdentifier;
import org.opendaylight.controller.cluster.access.concepts.FrontendIdentifier;
import org.opendaylight.controller.cluster.access.concepts.FrontendType;
import org.opendaylight.controller.cluster.access.concepts.MemberName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class RecoveringClientActorBehavior
extends AbstractClientActorBehavior<InitialClientActorContext> {
    private static final Logger LOG = LoggerFactory.getLogger(RecoveringClientActorBehavior.class);
    private static final String GENERATION_OVERRIDE_PROP_BASE = "org.opendaylight.controller.cluster.access.client.initial.generation.";
    private static final String PROP_MEMBER_NAME = "member-name";
    private static final String PROP_CLIENT_TYPE = "client-type";
    private static final String PROP_GENERATION = "generation";
    private final FrontendIdentifier currentFrontend;
    private final Path filePath;
    private RecoveredState recoveredState;

    RecoveringClientActorBehavior(Path statePath, AbstractClientActor actor, String persistenceId, FrontendIdentifier frontendId) {
        super(new InitialClientActorContext(actor, persistenceId));
        this.filePath = statePath.resolve("odl.cluster.client").resolve(frontendId.getMemberName().getName()).resolve(frontendId.getClientType().getName() + ".properties");
        this.currentFrontend = Objects.requireNonNull(frontendId);
    }

    @Override
    AbstractClientActorBehavior<?> onReceiveCommand(Object command) {
        throw new IllegalStateException("Frontend is recovering");
    }

    @Override
    AbstractClientActorBehavior<?> onReceiveRecover(Object recover) {
        Object object = recover;
        Objects.requireNonNull(object);
        Object object2 = object;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{SnapshotOffer.class, RecoveryCompleted.class}, (Object)object2, n)) {
            case 0 -> {
                SnapshotOffer msg = (SnapshotOffer)object2;
                yield this.onSnapshotOffer(msg);
            }
            case 1 -> {
                RecoveryCompleted msg = (RecoveryCompleted)object2;
                yield this.onRecoveryCompleted();
            }
            default -> {
                LOG.warn("{}: ignoring recovery message {}", (Object)this.persistenceId(), recover);
                yield this;
            }
        };
    }

    private RecoveringClientActorBehavior onSnapshotOffer(SnapshotOffer msg) {
        Object snapshot;
        Object object = snapshot = msg.snapshot();
        Objects.requireNonNull(object);
        Object object2 = object;
        int n = 0;
        this.recoveredState = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ClientIdentifier.class, PersistenceTombstone.class}, (Object)object2, n)) {
            case 0 -> {
                ClientIdentifier clientId = (ClientIdentifier)object2;
                yield new RecoveredState(clientId, false);
            }
            case 1 -> {
                PersistenceTombstone tombstone = (PersistenceTombstone)object2;
                yield new RecoveredState(tombstone.clientId(), true);
            }
            default -> throw new IllegalStateException("Unsupported snapshot " + String.valueOf(snapshot));
        };
        LOG.debug("{}: recovered {}", (Object)this.persistenceId(), (Object)this.recoveredState);
        return this;
    }

    private AbstractClientActorBehavior<?> onRecoveryCompleted() {
        try {
            RecoveredState local = this.recoveredState;
            if (local == null) {
                return this.startWithoutRecovered();
            }
            ClientIdentifier clientId = local.clientId;
            this.checkFrontendId(clientId.getFrontendId());
            return local.tombstone ? this.startWithTombstone(clientId) : this.startWithoutTombstone(clientId);
        }
        catch (IOException | RecoveryException e) {
            LOG.error("{}: failed to recover client identifier, shutting down", (Object)this.persistenceId(), (Object)e);
            return null;
        }
    }

    private ClientActorBehavior<?> startWithTombstone(ClientIdentifier fromPersistence) throws IOException, RecoveryException {
        long lastGeneration;
        ClientIdentifier fromFile = this.loadStateFile();
        if (fromFile != null) {
            long fileGen = fromFile.getGeneration();
            if (Long.compareUnsigned(fromPersistence.getGeneration(), fileGen) > 0) {
                throw new RecoveryException("tombstone %s is newer than %s from %s", fromPersistence, fromFile, this.filePath);
            }
            lastGeneration = fileGen;
        } else {
            LOG.warn("{}: missing file {}, attempting to recover from tombstone {}", new Object[]{this.persistenceId(), this.filePath, fromPersistence});
            lastGeneration = fromPersistence.getGeneration();
        }
        ClientIdentifier clientId = this.nextClientId(lastGeneration);
        this.createStateFile(clientId);
        return ((InitialClientActorContext)this.context()).createBehavior(clientId);
    }

    private SavingClientActorBehavior startWithoutTombstone(ClientIdentifier fromPersistence) throws IOException, RecoveryException {
        long lastGeneration;
        ClientIdentifier fromFile = this.loadStateFile();
        if (fromFile != null) {
            long fileGen = fromFile.getGeneration();
            if (Long.compareUnsigned(fromPersistence.getGeneration(), fileGen) > 0) {
                throw new RecoveryException("recovered %s is newer than %s from %s", fromPersistence, fromFile, this.filePath);
            }
            LOG.warn("{}: attempting to re-tombstone from {}", (Object)this.persistenceId(), (Object)fromPersistence);
            lastGeneration = fileGen;
        } else {
            lastGeneration = fromPersistence.getGeneration();
        }
        return this.saveTombstone(lastGeneration);
    }

    private SavingClientActorBehavior startWithoutRecovered() throws IOException, RecoveryException {
        ClientIdentifier fromFile = this.loadStateFile();
        if (fromFile != null) {
            return this.saveTombstone(fromFile.getGeneration());
        }
        return this.saveTombstone(ClientIdentifier.create((FrontendIdentifier)this.currentFrontend, (long)this.initialGeneration()));
    }

    private SavingClientActorBehavior saveTombstone(long lastGeneration) throws IOException, RecoveryException {
        return this.saveTombstone(this.nextClientId(lastGeneration));
    }

    private SavingClientActorBehavior saveTombstone(ClientIdentifier clientId) throws IOException {
        this.createStateFile(clientId);
        LOG.info("{}: saving tombstone {}", (Object)this.persistenceId(), (Object)clientId);
        ((InitialClientActorContext)this.context()).saveSnapshot(clientId);
        return new SavingClientActorBehavior((InitialClientActorContext)this.context(), clientId);
    }

    private ClientIdentifier nextClientId(long lastGeneration) throws RecoveryException {
        long nextGeneration = lastGeneration + 1L;
        if (nextGeneration == 0L) {
            throw new RecoveryException("Generation counter exhausted for %s", this.currentFrontend);
        }
        return ClientIdentifier.create((FrontendIdentifier)this.currentFrontend, (long)nextGeneration);
    }

    private void createStateFile(ClientIdentifier clientId) throws IOException {
        LOG.debug("{}: saving new identifier {} to {}", new Object[]{this.persistenceId(), clientId, this.filePath});
        RecoveringClientActorBehavior.createStateFile(this.filePath, clientId);
    }

    private static void createStateFile(Path path, ClientIdentifier clientId) throws IOException {
        Properties props = new Properties();
        FrontendIdentifier frontendId = clientId.getFrontendId();
        props.setProperty(PROP_MEMBER_NAME, frontendId.getMemberName().getName());
        props.setProperty(PROP_CLIENT_TYPE, frontendId.getClientType().getName());
        props.setProperty(PROP_GENERATION, Long.toUnsignedString(clientId.getGeneration()));
        RecoveringClientActorBehavior.createStateFile(path, props);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createStateFile(Path path, Properties props) throws IOException {
        Path parent = path.getParent();
        Files.createDirectories(parent, new FileAttribute[0]);
        Path temp = Files.createTempFile(parent, "cds-id", null, new FileAttribute[0]);
        try {
            try (OutputStream os = Files.newOutputStream(temp, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.SYNC);){
                props.store(os, "Critical persistent state. Do not touch unless you know what you are doing!");
            }
            Files.move(temp, path, StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
        }
        finally {
            try {
                Files.deleteIfExists(temp);
            }
            catch (IOException e) {
                LOG.warn("Failed to delete {}", (Object)temp, (Object)e);
            }
        }
    }

    private long initialGeneration() {
        long ret;
        String propName = GENERATION_OVERRIDE_PROP_BASE + this.currentFrontend.getClientType().getName();
        String propValue = System.getProperty(propName);
        if (propValue == null) {
            LOG.debug("{}: no initial generation override, starting from 0", (Object)this.persistenceId());
            return 0L;
        }
        try {
            ret = Long.parseUnsignedLong(propValue);
        }
        catch (NumberFormatException e) {
            LOG.warn("{}: failed to parse initial generation override '{}', starting from 0", new Object[]{this.persistenceId(), propValue, e});
            return 0L;
        }
        LOG.info("{}: initial generation set to {}", (Object)this.persistenceId(), (Object)ret);
        return ret;
    }

    private @Nullable ClientIdentifier loadStateFile() throws IOException, RecoveryException {
        long generation;
        if (!Files.exists(this.filePath, new LinkOption[0])) {
            return null;
        }
        Properties props = new Properties();
        try (InputStream is = Files.newInputStream(this.filePath, new OpenOption[0]);){
            props.load(is);
        }
        catch (IllegalArgumentException e) {
            throw new RecoveryException(e, "Failed to load %s", this.filePath);
        }
        FrontendIdentifier frontendId = FrontendIdentifier.create((MemberName)MemberName.forName((String)RecoveringClientActorBehavior.requireProp(props, PROP_MEMBER_NAME, this.filePath)), (FrontendType)FrontendType.forName((String)RecoveringClientActorBehavior.requireProp(props, PROP_CLIENT_TYPE, this.filePath)));
        this.checkFrontendId(frontendId);
        String generationStr = RecoveringClientActorBehavior.requireProp(props, PROP_GENERATION, this.filePath);
        try {
            generation = Long.parseUnsignedLong(generationStr);
        }
        catch (NumberFormatException e) {
            throw new RecoveryException(e, "%s contains illegal generation %s", this.filePath, generationStr);
        }
        return ClientIdentifier.create((FrontendIdentifier)frontendId, (long)generation);
    }

    private void checkFrontendId(FrontendIdentifier frontendId) throws RecoveryException {
        if (!this.currentFrontend.equals((Object)frontendId)) {
            throw new RecoveryException("Mismatched frontend identifier: current: %s saved: %s", this.currentFrontend, frontendId);
        }
    }

    private static String requireProp(Properties props, String key, Path path) throws RecoveryException {
        String value = props.getProperty(key);
        if (value == null) {
            throw new RecoveryException("%s is missing property %s", path, key);
        }
        return value;
    }

    private record RecoveredState(ClientIdentifier clientId, boolean tombstone) {
        RecoveredState {
            Objects.requireNonNull(clientId);
        }
    }
}

