/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.access.client;

import akka.persistence.DeleteSnapshotsFailure;
import akka.persistence.DeleteSnapshotsSuccess;
import akka.persistence.SaveSnapshotFailure;
import akka.persistence.SaveSnapshotSuccess;
import akka.persistence.SnapshotSelectionCriteria;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import org.opendaylight.controller.cluster.access.client.AbstractClientActorBehavior;
import org.opendaylight.controller.cluster.access.client.InitialClientActorContext;
import org.opendaylight.controller.cluster.access.client.RecoveredClientActorBehavior;
import org.opendaylight.controller.cluster.access.concepts.ClientIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Long;

final class SavingClientActorBehavior
extends RecoveredClientActorBehavior<InitialClientActorContext> {
    private static final Logger LOG = LoggerFactory.getLogger(SavingClientActorBehavior.class);
    private final ClientIdentifier myId;

    SavingClientActorBehavior(InitialClientActorContext context, ClientIdentifier nextId) {
        super(context);
        this.myId = Objects.requireNonNull(nextId);
    }

    @Override
    AbstractClientActorBehavior<?> onReceiveCommand(Object command) {
        Object object = command;
        Objects.requireNonNull(object);
        Object object2 = object;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{SaveSnapshotFailure.class, SaveSnapshotSuccess.class, DeleteSnapshotsSuccess.class, DeleteSnapshotsFailure.class}, (Object)object2, n)) {
            case 0: {
                SaveSnapshotFailure saveFailure = (SaveSnapshotFailure)object2;
                LOG.error("{}: failed to persist state", (Object)this.persistenceId(), (Object)saveFailure.cause());
                return null;
            }
            case 1: {
                SaveSnapshotSuccess saved = (SaveSnapshotSuccess)object2;
                LOG.debug("{}: got command: {}", (Object)this.persistenceId(), (Object)saved);
                ((InitialClientActorContext)this.context()).deleteSnapshots(new SnapshotSelectionCriteria(Long.MaxValue(), saved.metadata().timestamp() - 1L, 0L, 0L));
                return this;
            }
            case 2: {
                DeleteSnapshotsSuccess deleteSuccess = (DeleteSnapshotsSuccess)object2;
                LOG.debug("{}: got command: {}", (Object)this.persistenceId(), (Object)deleteSuccess);
                break;
            }
            case 3: {
                DeleteSnapshotsFailure deleteFailure = (DeleteSnapshotsFailure)object2;
                LOG.warn("{}: failed to delete prior snapshots", (Object)this.persistenceId(), (Object)deleteFailure.cause());
                break;
            }
            default: {
                LOG.debug("{}: stashing command {}", (Object)this.persistenceId(), command);
                ((InitialClientActorContext)this.context()).stash();
                return this;
            }
        }
        ((InitialClientActorContext)this.context()).unstash();
        return ((InitialClientActorContext)this.context()).createBehavior(this.myId);
    }
}

