/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.api;

import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.mdsal.binding.api.BindingService;
import org.opendaylight.mdsal.binding.api.ClusteredDataTreeChangeListener;
import org.opendaylight.mdsal.binding.api.DataChangeListener;
import org.opendaylight.mdsal.binding.api.DataChangeListenerAdapter;
import org.opendaylight.mdsal.binding.api.DataListener;
import org.opendaylight.mdsal.binding.api.DataListenerAdapter;
import org.opendaylight.mdsal.binding.api.DataTreeChangeListener;
import org.opendaylight.mdsal.binding.api.DataTreeIdentifier;
import org.opendaylight.mdsal.binding.api.LegacyUtils;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.yangtools.binding.DataObject;
import org.opendaylight.yangtools.binding.DataObjectIdentifier;
import org.opendaylight.yangtools.binding.DataObjectReference;
import org.opendaylight.yangtools.concepts.Registration;

public interface DataTreeChangeService
extends BindingService {
    public <T extends DataObject> @NonNull Registration registerTreeChangeListener(@NonNull LogicalDatastoreType var1, @NonNull DataObjectReference<T> var2, @NonNull DataTreeChangeListener<T> var3);

    @Deprecated(since="14.0.0", forRemoval=true)
    default public <T extends DataObject> @NonNull Registration registerTreeChangeListener(@NonNull DataTreeIdentifier<T> treeId, @NonNull DataTreeChangeListener<T> listener) {
        return this.registerTreeChangeListener(treeId.datastore(), treeId.getRootIdentifier().toReference(), listener);
    }

    @Deprecated(since="13.0.0", forRemoval=true)
    public <T extends DataObject> @NonNull Registration registerLegacyTreeChangeListener(@NonNull LogicalDatastoreType var1, @NonNull DataObjectReference<T> var2, @NonNull DataTreeChangeListener<T> var3);

    @Deprecated(since="14.0.0", forRemoval=true)
    default public <T extends DataObject> @NonNull Registration registerLegacyTreeChangeListener(@NonNull DataTreeIdentifier<T> treeId, @NonNull DataTreeChangeListener<T> listener) {
        return this.registerLegacyTreeChangeListener(treeId.datastore(), treeId.path().toReference(), listener);
    }

    @Deprecated(since="13.0.0", forRemoval=true)
    default public <T extends DataObject> @NonNull Registration registerDataTreeChangeListener(@NonNull DataTreeIdentifier<T> treeId, @NonNull DataTreeChangeListener<T> listener) {
        return listener instanceof ClusteredDataTreeChangeListener ? this.registerTreeChangeListener(treeId, listener) : this.registerLegacyTreeChangeListener(treeId, listener);
    }

    @Deprecated(since="13.0.0", forRemoval=true)
    default public <T extends DataObject> @NonNull Registration registerDataTreeChangeListener(@NonNull DataTreeIdentifier<T> treeId, @NonNull ClusteredDataTreeChangeListener<T> listener) {
        return this.registerTreeChangeListener(treeId, listener);
    }

    default public <T extends DataObject> @NonNull Registration registerDataListener(@NonNull LogicalDatastoreType datastore, @NonNull DataObjectIdentifier<T> path, @NonNull DataListener<T> listener) {
        return this.registerTreeChangeListener(datastore, (DataObjectReference<T>)path, new DataListenerAdapter<T>(listener));
    }

    @Deprecated(since="14.0.0", forRemoval=true)
    default public <T extends DataObject> @NonNull Registration registerDataListener(@NonNull DataTreeIdentifier<T> treeId, @NonNull DataListener<T> listener) {
        return this.registerDataListener(treeId.datastore(), LegacyUtils.legacyToIdentifier(treeId.path()), listener);
    }

    default public <T extends DataObject> @NonNull Registration registerDataChangeListener(@NonNull LogicalDatastoreType datastore, @NonNull DataObjectIdentifier<T> path, @NonNull DataChangeListener<T> listener) {
        return this.registerTreeChangeListener(datastore, (DataObjectReference<T>)path, new DataChangeListenerAdapter<T>(listener));
    }

    @Deprecated(since="14.0.0", forRemoval=true)
    default public <T extends DataObject> @NonNull Registration registerDataChangeListener(@NonNull DataTreeIdentifier<T> treeId, @NonNull DataChangeListener<T> listener) {
        return this.registerTreeChangeListener(treeId.datastore(), (DataObjectReference<T>)LegacyUtils.legacyToIdentifier(treeId.path()), new DataChangeListenerAdapter<T>(listener));
    }
}

