/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.api;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.mdsal.binding.api.DTIv1;
import org.opendaylight.mdsal.common.api.LogicalDatastorePath;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.yangtools.binding.DataObject;
import org.opendaylight.yangtools.binding.DataObjectReference;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;

public final class DataTreeIdentifier<T extends DataObject>
implements LogicalDatastorePath<DataTreeIdentifier<?>, InstanceIdentifier<?>> {
    private static final long serialVersionUID = 1L;
    private final @NonNull LogicalDatastoreType datastore;
    private final @NonNull DataObjectReference<T> path;

    private DataTreeIdentifier(@NonNull LogicalDatastoreType datastore, @NonNull DataObjectReference<T> path) {
        this.datastore = Objects.requireNonNull(datastore);
        this.path = Objects.requireNonNull(path);
    }

    public static <T extends DataObject> @NonNull DataTreeIdentifier<T> of(@NonNull LogicalDatastoreType datastore, @NonNull DataObjectReference<T> path) {
        return new DataTreeIdentifier<T>(datastore, path);
    }

    @Deprecated(since="14.0.0", forRemoval=true)
    public static <T extends DataObject> @NonNull DataTreeIdentifier<T> of(@NonNull LogicalDatastoreType datastore, @NonNull InstanceIdentifier<T> path) {
        return DataTreeIdentifier.of(datastore, path.toReference());
    }

    @Deprecated(since="13.0.0", forRemoval=true)
    public static <T extends DataObject> @NonNull DataTreeIdentifier<T> create(@NonNull LogicalDatastoreType datastore, @NonNull InstanceIdentifier<T> path) {
        return DataTreeIdentifier.of(datastore, path);
    }

    public LogicalDatastoreType datastore() {
        return this.datastore;
    }

    @Deprecated(since="13.0.0", forRemoval=true)
    public @NonNull LogicalDatastoreType getDatastoreType() {
        return this.datastore();
    }

    public InstanceIdentifier<T> path() {
        return this.path.toLegacy();
    }

    @Deprecated(since="13.0.0", forRemoval=true)
    public @NonNull InstanceIdentifier<T> getRootIdentifier() {
        return this.path();
    }

    public int hashCode() {
        return this.datastore.hashCode() * 31 + this.path.hashCode();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof DataTreeIdentifier)) return false;
        DataTreeIdentifier other = (DataTreeIdentifier)obj;
        if (!this.datastore.equals((Object)other.datastore)) return false;
        if (!this.path.equals(other.path)) return false;
        return true;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("datastore", (Object)this.datastore).add("root", this.path).toString();
    }

    Object writeReplace() {
        return new DTIv1(this);
    }
}

