/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore.node.utils;

import java.util.Objects;
import org.opendaylight.controller.cluster.datastore.node.utils.NormalizedNodeVisitor;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerChild;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.MixinNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNodeContainer;

public class NormalizedNodeNavigator {
    private final NormalizedNodeVisitor visitor;

    public NormalizedNodeNavigator(NormalizedNodeVisitor visitor) {
        this.visitor = Objects.requireNonNull(visitor, "visitor should not be null");
    }

    public void navigate(String parentPath, NormalizedNode normalizedNode) {
        if (parentPath == null) {
            parentPath = "";
        }
        this.navigateNormalizedNode(0, parentPath, normalizedNode);
    }

    private void navigateDataContainerNode(int level, String parentPath, DataContainerNode dataContainerNode) {
        this.visitor.visitNode(level, parentPath, (NormalizedNode)dataContainerNode);
        String newParentPath = parentPath + "/" + dataContainerNode.name().toString();
        for (DataContainerChild node : dataContainerNode.body()) {
            if (node instanceof MixinNode && node instanceof NormalizedNodeContainer) {
                NormalizedNodeContainer container = (NormalizedNodeContainer)node;
                this.navigateNormalizedNodeContainerMixin(level, newParentPath, container);
                continue;
            }
            this.navigateNormalizedNode(level, newParentPath, (NormalizedNode)node);
        }
    }

    private void navigateNormalizedNodeContainerMixin(int level, String parentPath, NormalizedNodeContainer<?> node) {
        this.visitor.visitNode(level, parentPath, (NormalizedNode)node);
        String newParentPath = parentPath + "/" + node.name().toString();
        for (NormalizedNode normalizedNode : node.body()) {
            if (normalizedNode instanceof MixinNode && normalizedNode instanceof NormalizedNodeContainer) {
                NormalizedNodeContainer container = (NormalizedNodeContainer)normalizedNode;
                this.navigateNormalizedNodeContainerMixin(level + 1, newParentPath, container);
                continue;
            }
            this.navigateNormalizedNode(level, newParentPath, normalizedNode);
        }
    }

    private void navigateNormalizedNode(int level, String parentPath, NormalizedNode normalizedNode) {
        if (normalizedNode instanceof DataContainerNode) {
            DataContainerNode dataContainer = (DataContainerNode)normalizedNode;
            this.navigateDataContainerNode(level + 1, parentPath, dataContainer);
        } else {
            this.visitor.visitNode(level + 1, parentPath, normalizedNode);
        }
    }
}

