/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.messaging;

import akka.actor.ActorRef;
import akka.actor.ExtendedActorSystem;
import akka.serialization.JavaSerializer;
import akka.serialization.Serialization;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Objects;
import org.opendaylight.yangtools.concepts.Identifier;

public class MessageSlice
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Identifier identifier;
    private final byte[] data;
    private final int sliceIndex;
    private final int totalSlices;
    private final int lastSliceHashCode;
    private final ActorRef replyTo;

    MessageSlice(Identifier identifier, byte[] data, int sliceIndex, int totalSlices, int lastSliceHashCode, ActorRef replyTo) {
        this.identifier = Objects.requireNonNull(identifier);
        this.data = Objects.requireNonNull(data);
        this.sliceIndex = sliceIndex;
        this.totalSlices = totalSlices;
        this.lastSliceHashCode = lastSliceHashCode;
        this.replyTo = Objects.requireNonNull(replyTo);
    }

    public Identifier getIdentifier() {
        return this.identifier;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="Exposes a mutable object stored in a field but this is OK since this class is merely a DTO and does not process the byte[] internally.Also it would be inefficient to create a return copy as the byte[] could be large.")
    public byte[] getData() {
        return this.data;
    }

    public int getSliceIndex() {
        return this.sliceIndex;
    }

    public int getTotalSlices() {
        return this.totalSlices;
    }

    public int getLastSliceHashCode() {
        return this.lastSliceHashCode;
    }

    public ActorRef getReplyTo() {
        return this.replyTo;
    }

    public String toString() {
        return "MessageSlice [identifier=" + String.valueOf(this.identifier) + ", data.length=" + this.data.length + ", sliceIndex=" + this.sliceIndex + ", totalSlices=" + this.totalSlices + ", lastSliceHashCode=" + this.lastSliceHashCode + ", replyTo=" + String.valueOf(this.replyTo) + "]";
    }

    private Object writeReplace() {
        return new Proxy(this);
    }

    private static class Proxy
    implements Externalizable {
        private static final long serialVersionUID = 1L;
        private MessageSlice messageSlice;

        public Proxy() {
        }

        Proxy(MessageSlice messageSlice) {
            this.messageSlice = messageSlice;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.messageSlice.identifier);
            out.writeInt(this.messageSlice.sliceIndex);
            out.writeInt(this.messageSlice.totalSlices);
            out.writeInt(this.messageSlice.lastSliceHashCode);
            out.writeObject(this.messageSlice.data);
            out.writeObject(Serialization.serializedActorPath((ActorRef)this.messageSlice.replyTo));
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            Identifier identifier = (Identifier)in.readObject();
            int sliceIndex = in.readInt();
            int totalSlices = in.readInt();
            int lastSliceHashCode = in.readInt();
            byte[] data = (byte[])in.readObject();
            ActorRef replyTo = ((ExtendedActorSystem)JavaSerializer.currentSystem().value()).provider().resolveActorRef((String)in.readObject());
            this.messageSlice = new MessageSlice(identifier, data, sliceIndex, totalSlices, lastSliceHashCode, replyTo);
        }

        private Object readResolve() {
            return this.messageSlice;
        }
    }
}

