/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.messaging;

import akka.actor.ActorRef;
import akka.actor.ActorSelection;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.Objects;
import java.util.function.Consumer;
import org.opendaylight.controller.cluster.io.FileBackedOutputStream;
import org.opendaylight.yangtools.concepts.Identifier;

public final class SliceOptions {
    private final Builder builder;

    private SliceOptions(Builder builder) {
        this.builder = builder;
    }

    public Identifier getIdentifier() {
        return this.builder.identifier;
    }

    public FileBackedOutputStream getFileBackedStream() {
        return this.builder.fileBackedStream;
    }

    public Serializable getMessage() {
        return this.builder.message;
    }

    public ActorRef getSendToRef() {
        return this.builder.sendToRef;
    }

    public ActorSelection getSendToSelection() {
        return this.builder.sendToSelection;
    }

    public ActorRef getReplyTo() {
        return this.builder.replyTo;
    }

    public Consumer<Throwable> getOnFailureCallback() {
        return this.builder.onFailureCallback;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Identifier identifier;
        private FileBackedOutputStream fileBackedStream;
        private Serializable message;
        private ActorRef sendToRef;
        private ActorSelection sendToSelection;
        private ActorRef replyTo;
        private Consumer<Throwable> onFailureCallback;
        private boolean sealed;

        public Builder identifier(Identifier newIdentifier) {
            this.checkSealed();
            this.identifier = newIdentifier;
            return this;
        }

        public Builder fileBackedOutputStream(FileBackedOutputStream newFileBackedStream) {
            this.checkSealed();
            this.fileBackedStream = newFileBackedStream;
            return this;
        }

        public <T extends Serializable> Builder message(T newMessage) {
            this.checkSealed();
            this.message = newMessage;
            return this;
        }

        public Builder sendTo(ActorRef sendTo) {
            this.checkSealed();
            this.sendToRef = sendTo;
            return this;
        }

        public Builder sendTo(ActorSelection sendTo) {
            this.checkSealed();
            this.sendToSelection = sendTo;
            return this;
        }

        public Builder replyTo(ActorRef newReplyTo) {
            this.checkSealed();
            this.replyTo = newReplyTo;
            return this;
        }

        public Builder onFailureCallback(Consumer<Throwable> newOnFailureCallback) {
            this.checkSealed();
            this.onFailureCallback = newOnFailureCallback;
            return this;
        }

        public SliceOptions build() {
            this.sealed = true;
            Objects.requireNonNull(this.identifier, "identifier must be set");
            Objects.requireNonNull(this.replyTo, "replyTo must be set");
            Objects.requireNonNull(this.onFailureCallback, "onFailureCallback must be set");
            Preconditions.checkState((this.fileBackedStream == null || this.message == null ? 1 : 0) != 0, (Object)"Only one of message and fileBackedStream can be set");
            Preconditions.checkState((this.fileBackedStream != null || this.message != null ? 1 : 0) != 0, (Object)"One of message and fileBackedStream must be set");
            Preconditions.checkState((this.sendToRef == null || this.sendToSelection == null ? 1 : 0) != 0, (Object)"Only one of sendToRef and sendToSelection can be set");
            Preconditions.checkState((this.sendToRef != null || this.sendToSelection != null ? 1 : 0) != 0, (Object)"One of sendToRef and sendToSelection must be set");
            return new SliceOptions(this);
        }

        protected void checkSealed() {
            Preconditions.checkState((!this.sealed ? 1 : 0) != 0, (Object)"Builder is already sealed - further modifications are not allowed");
        }
    }
}

