/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.notifications;

import akka.actor.ActorPath;
import akka.actor.ActorRef;
import akka.actor.Props;
import akka.serialization.Serialization;
import java.util.HashMap;
import java.util.Map;
import org.opendaylight.controller.cluster.common.actor.AbstractUntypedActor;
import org.opendaylight.controller.cluster.notifications.LeaderStateChanged;
import org.opendaylight.controller.cluster.notifications.RegisterRoleChangeListener;
import org.opendaylight.controller.cluster.notifications.RegisterRoleChangeListenerReply;
import org.opendaylight.controller.cluster.notifications.RoleChangeNotification;
import org.opendaylight.controller.cluster.notifications.RoleChanged;

public class RoleChangeNotifier
extends AbstractUntypedActor
implements AutoCloseable {
    private final Map<ActorPath, ActorRef> registeredListeners = new HashMap<ActorPath, ActorRef>();
    private final String memberId;
    private RoleChangeNotification latestRoleChangeNotification = null;
    private LeaderStateChanged latestLeaderStateChanged;

    public RoleChangeNotifier(String memberId) {
        this.memberId = memberId;
    }

    public static Props getProps(String memberId) {
        return Props.create(RoleChangeNotifier.class, (Object[])new Object[]{memberId});
    }

    public void preStart() throws Exception {
        super.preStart();
        this.LOG.info("RoleChangeNotifier:{} created and ready for shard:{}", (Object)Serialization.serializedActorPath((ActorRef)this.getSelf()), (Object)this.memberId);
    }

    @Override
    protected void handleReceive(Object message) {
        if (message instanceof RegisterRoleChangeListener) {
            ActorRef curRef = this.registeredListeners.get(this.getSender().path());
            if (curRef != null) {
                this.registeredListeners.remove(this.getSender().path());
            }
            this.registeredListeners.put(this.getSender().path(), this.getSender());
            this.LOG.info("RoleChangeNotifier for {} , registered listener {}", (Object)this.memberId, (Object)this.getSender().path().toString());
            this.getSender().tell((Object)new RegisterRoleChangeListenerReply(), this.getSelf());
            if (this.latestLeaderStateChanged != null) {
                this.getSender().tell((Object)this.latestLeaderStateChanged, this.getSelf());
            }
            if (this.latestRoleChangeNotification != null) {
                this.getSender().tell((Object)this.latestRoleChangeNotification, this.getSelf());
            }
        } else if (message instanceof RoleChanged) {
            RoleChanged roleChanged = (RoleChanged)message;
            this.LOG.info("RoleChangeNotifier for {} , received role change from {} to {}", new Object[]{this.memberId, roleChanged.getOldRole(), roleChanged.getNewRole()});
            this.latestRoleChangeNotification = new RoleChangeNotification(roleChanged.getMemberId(), roleChanged.getOldRole(), roleChanged.getNewRole());
            for (ActorRef listener : this.registeredListeners.values()) {
                listener.tell((Object)this.latestRoleChangeNotification, this.getSelf());
            }
        } else if (message instanceof LeaderStateChanged) {
            LeaderStateChanged leaderStateChanged;
            this.latestLeaderStateChanged = leaderStateChanged = (LeaderStateChanged)message;
            for (ActorRef listener : this.registeredListeners.values()) {
                listener.tell((Object)this.latestLeaderStateChanged, this.getSelf());
            }
        } else {
            this.unknownMessage(message);
        }
    }

    @Override
    public void close() {
        this.registeredListeners.clear();
    }
}

