/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.schema.provider.impl;

import akka.dispatch.OnComplete;
import com.google.common.annotations.Beta;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import org.opendaylight.controller.cluster.schema.provider.RemoteYangTextSourceProvider;
import org.opendaylight.controller.cluster.schema.provider.impl.YangTextSchemaSourceSerializationProxy;
import org.opendaylight.yangtools.yang.model.api.source.SourceIdentifier;
import org.opendaylight.yangtools.yang.model.api.source.YangTextSource;
import org.opendaylight.yangtools.yang.model.repo.spi.SchemaSourceProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.concurrent.ExecutionContext;

@Beta
public class RemoteSchemaProvider
implements SchemaSourceProvider<YangTextSource> {
    private static final Logger LOG = LoggerFactory.getLogger(RemoteSchemaProvider.class);
    private final RemoteYangTextSourceProvider remoteRepo;
    private final ExecutionContext executionContext;

    public RemoteSchemaProvider(RemoteYangTextSourceProvider remoteRepo, ExecutionContext executionContext) {
        this.remoteRepo = remoteRepo;
        this.executionContext = executionContext;
    }

    public ListenableFuture<YangTextSource> getSource(SourceIdentifier sourceIdentifier) {
        LOG.trace("Getting yang schema source for {}", (Object)sourceIdentifier.name().getLocalName());
        final SettableFuture res = SettableFuture.create();
        this.remoteRepo.getYangTextSchemaSource(sourceIdentifier).onComplete((Function1)new OnComplete<YangTextSchemaSourceSerializationProxy>(this){

            public void onComplete(Throwable failure, YangTextSchemaSourceSerializationProxy success) {
                if (success != null) {
                    res.set((Object)success.getRepresentation());
                }
                if (failure != null) {
                    res.setException(failure);
                }
            }
        }, this.executionContext);
        return res;
    }
}

