/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.tree.spi;

import com.google.common.base.MoreObjects;
import com.google.common.collect.Collections2;
import java.util.Collection;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.tree.api.DataTreeCandidate;
import org.opendaylight.yangtools.yang.data.tree.api.DataTreeCandidateNode;
import org.opendaylight.yangtools.yang.data.tree.api.ModificationType;
import org.opendaylight.yangtools.yang.data.tree.spi.AbstractDataTreeCandidateNode;

final class CompatDataTreeCandidateNode<T extends DataTreeCandidate.CandidateNode & DataTreeCandidate.CandidateNode.WithChildren>
extends AbstractDataTreeCandidateNode {
    private final @NonNull T node;
    private final NormalizedNode dataBefore;
    private final NormalizedNode dataAfter;

    CompatDataTreeCandidateNode(ModificationType modificationType, T node, NormalizedNode dataBefore, NormalizedNode dataAfter) {
        super(modificationType);
        this.node = (DataTreeCandidate.CandidateNode)Objects.requireNonNull(node);
        this.dataBefore = dataBefore;
        this.dataAfter = dataAfter;
    }

    public YangInstanceIdentifier.PathArgument name() {
        return this.node.name();
    }

    public Collection<DataTreeCandidateNode> childNodes() {
        return Collections2.transform((Collection)((DataTreeCandidate.CandidateNode.WithChildren)this.node).children(), DataTreeCandidate.CandidateNode::toLegacy);
    }

    public DataTreeCandidateNode modifiedChild(YangInstanceIdentifier.PathArgument childName) {
        DataTreeCandidate.CandidateNode child = ((DataTreeCandidate.CandidateNode.WithChildren)this.node).modifiedChild(childName);
        return child != null ? child.toLegacy() : null;
    }

    public NormalizedNode dataBefore() {
        return this.dataBefore;
    }

    public NormalizedNode dataAfter() {
        return this.dataAfter;
    }

    @Override
    protected MoreObjects.ToStringHelper addToStringAttributes(MoreObjects.ToStringHelper helper) {
        return helper.add("delegate", this.node);
    }
}

