/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.tree.spi;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.tree.api.CursorAwareDataTreeModification;
import org.opendaylight.yangtools.yang.data.tree.api.DataTreeCandidate;
import org.opendaylight.yangtools.yang.data.tree.api.DataTreeCandidateNode;
import org.opendaylight.yangtools.yang.data.tree.api.DataTreeModification;
import org.opendaylight.yangtools.yang.data.tree.api.DataTreeModificationCursor;
import org.opendaylight.yangtools.yang.data.tree.api.ModificationType;
import org.opendaylight.yangtools.yang.data.tree.spi.CreatedDataTreeCandidateNode;
import org.opendaylight.yangtools.yang.data.tree.spi.DataTreeCandidateNodes;
import org.opendaylight.yangtools.yang.data.tree.spi.DefaultDataTreeCandidate;
import org.opendaylight.yangtools.yang.data.tree.spi.TerminalDataTreeCandidateNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public final class DataTreeCandidates {
    private static final Logger LOG = LoggerFactory.getLogger(DataTreeCandidates.class);

    private DataTreeCandidates() {
    }

    public static @NonNull DataTreeCandidate newDataTreeCandidate(YangInstanceIdentifier rootPath, DataTreeCandidateNode rootNode) {
        return new DefaultDataTreeCandidate(rootPath, rootNode);
    }

    public static @NonNull DataTreeCandidate fromNormalizedNode(YangInstanceIdentifier rootPath, NormalizedNode node) {
        return new DefaultDataTreeCandidate(rootPath, CreatedDataTreeCandidateNode.of(node));
    }

    public static void applyToCursor(DataTreeModificationCursor cursor, DataTreeCandidate candidate) {
        DataTreeCandidateNodes.applyToCursor(cursor, candidate.getRootNode());
    }

    public static void applyToModification(DataTreeModification modification, DataTreeCandidate candidate) {
        if (modification instanceof CursorAwareDataTreeModification) {
            CursorAwareDataTreeModification cursorAware = (CursorAwareDataTreeModification)modification;
            DataTreeCandidates.applyToCursorAwareModification(cursorAware, candidate);
            return;
        }
        DataTreeCandidateNode node = candidate.getRootNode();
        YangInstanceIdentifier path = candidate.getRootPath();
        ModificationType type = node.modificationType();
        switch (type) {
            case DELETE: {
                modification.delete(path);
                LOG.debug("Modification {} deleted path {}", (Object)modification, (Object)path);
                break;
            }
            case SUBTREE_MODIFIED: {
                LOG.debug("Modification {} modified path {}", (Object)modification, (Object)path);
                NodeIterator iterator = new NodeIterator(null, path, node.childNodes().iterator());
                while ((iterator = iterator.next(modification)) != null) {
                }
                break;
            }
            case UNMODIFIED: {
                LOG.debug("Modification {} unmodified path {}", (Object)modification, (Object)path);
                break;
            }
            case WRITE: {
                modification.write(path, (NormalizedNode)Verify.verifyNotNull((Object)node.dataAfter()));
                LOG.debug("Modification {} written path {}", (Object)modification, (Object)path);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported modification " + String.valueOf(type));
            }
        }
    }

    public static @NonNull DataTreeCandidate aggregate(@NonNull List<? extends DataTreeCandidate> candidates) {
        Iterator<? extends DataTreeCandidate> it = candidates.iterator();
        Preconditions.checkArgument((boolean)it.hasNext(), (Object)"Input must not be empty");
        DataTreeCandidate first = Objects.requireNonNull(it.next(), "Input must not contain null entries");
        if (!it.hasNext()) {
            return first;
        }
        YangInstanceIdentifier rootPath = first.getRootPath();
        ArrayList<DataTreeCandidateNode> roots = new ArrayList<DataTreeCandidateNode>(candidates.size());
        roots.add(first.getRootNode());
        it.forEachRemaining(candidate -> {
            YangInstanceIdentifier root = candidate.getRootPath();
            Preconditions.checkArgument((boolean)rootPath.equals((Object)root), (String)"Expecting root path %s, encountered %s", (Object)rootPath, (Object)root);
            roots.add(candidate.getRootNode());
        });
        return DataTreeCandidates.newDataTreeCandidate(rootPath, DataTreeCandidates.fastCompressNode((DataTreeCandidateNode)roots.getFirst(), roots));
    }

    private static DataTreeCandidateNode fastCompressNode(DataTreeCandidateNode first, List<DataTreeCandidateNode> input) {
        DataTreeCandidateNode last = input.getLast();
        NormalizedNode dataBefore = first.dataBefore();
        NormalizedNode dataAfter = last.dataAfter();
        ModificationType type = last.modificationType();
        return switch (type) {
            default -> throw new MatchException(null, null);
            case ModificationType.DELETE -> {
                ModificationType previous = first.modificationType();
                if (previous == ModificationType.DELETE || previous == ModificationType.DISAPPEARED || previous == ModificationType.UNMODIFIED && dataBefore == null) {
                    throw DataTreeCandidates.illegalModification(ModificationType.DELETE, ModificationType.DELETE);
                }
                if (dataBefore != null) {
                    yield new TerminalDataTreeCandidateNode(null, type, dataBefore, null);
                }
                yield new TerminalDataTreeCandidateNode(null, ModificationType.UNMODIFIED, null, null);
            }
            case ModificationType.WRITE -> new TerminalDataTreeCandidateNode(null, type, dataBefore, (NormalizedNode)Verify.verifyNotNull((Object)dataAfter));
            case ModificationType.SUBTREE_MODIFIED, ModificationType.UNMODIFIED, ModificationType.APPEARED, ModificationType.DISAPPEARED -> DataTreeCandidates.slowCompressNodes(first, input);
        };
    }

    private static DataTreeCandidateNode slowCompressNodes(DataTreeCandidateNode first, List<DataTreeCandidateNode> input) {
        TerminalDataTreeCandidateNode finalNode = new TerminalDataTreeCandidateNode(null, first.dataBefore());
        input.forEach(node -> DataTreeCandidates.compressNode(finalNode, node, null));
        finalNode.setAfter(input.getLast().dataAfter());
        return DataTreeCandidates.cleanUpTree(finalNode);
    }

    private static void compressNode(TerminalDataTreeCandidateNode finalNode, DataTreeCandidateNode node, YangInstanceIdentifier.PathArgument parent) {
        YangInstanceIdentifier.PathArgument identifier;
        try {
            identifier = node.name();
        }
        catch (IllegalStateException e) {
            identifier = null;
        }
        if (finalNode.getNode(identifier).isEmpty()) {
            TerminalDataTreeCandidateNode parentNode = finalNode.getNode(parent).orElseThrow(() -> new IllegalArgumentException("No node found for " + String.valueOf(parent) + " identifier"));
            parentNode.addChildNode(new TerminalDataTreeCandidateNode(identifier, node.dataBefore(), parentNode));
        }
        ModificationType nodeModification = node.modificationType();
        switch (nodeModification) {
            case UNMODIFIED: {
                break;
            }
            case DELETE: 
            case SUBTREE_MODIFIED: 
            case WRITE: 
            case APPEARED: 
            case DISAPPEARED: {
                finalNode.setModification(identifier, DataTreeCandidates.compressModifications(finalNode.getModification(identifier), nodeModification, finalNode.dataAfter(identifier) == null));
                finalNode.setData(identifier, node.dataAfter());
                for (DataTreeCandidateNode child : node.childNodes()) {
                    DataTreeCandidates.compressNode(finalNode, child, identifier);
                }
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported modification type " + String.valueOf(nodeModification));
            }
        }
    }

    private static DataTreeCandidateNode cleanUpTree(TerminalDataTreeCandidateNode finalNode) {
        return DataTreeCandidates.cleanUpTree(finalNode, finalNode);
    }

    private static DataTreeCandidateNode cleanUpTree(TerminalDataTreeCandidateNode finalNode, TerminalDataTreeCandidateNode node) {
        YangInstanceIdentifier.PathArgument identifier = node.name();
        Collection<DataTreeCandidateNode> childNodes = node.childNodes();
        for (DataTreeCandidateNode childNode : childNodes) {
            DataTreeCandidates.cleanUpTree(finalNode, (TerminalDataTreeCandidateNode)childNode);
        }
        NormalizedNode dataBefore = finalNode.dataBefore(identifier);
        ModificationType modificationType = node.modificationType();
        int n = 0;
        switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"UNMODIFIED", "WRITE", "DELETE", "APPEARED", "DISAPPEARED", "SUBTREE_MODIFIED"}, (ModificationType)modificationType, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case -1: {
                throw new NullPointerException("null modificationType");
            }
            case 0: {
                finalNode.deleteNode(identifier);
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                if (dataBefore != null) break;
                finalNode.deleteNode(identifier);
                break;
            }
            case 3: {
                if (dataBefore != null) {
                    throw DataTreeCandidates.illegalModification(ModificationType.APPEARED, ModificationType.WRITE);
                }
                if (!childNodes.isEmpty()) break;
                finalNode.deleteNode(identifier);
                break;
            }
            case 4: {
                if (dataBefore != null && !childNodes.isEmpty()) break;
                finalNode.deleteNode(identifier);
                break;
            }
            case 5: {
                if (dataBefore == null) {
                    throw DataTreeCandidates.illegalModification(ModificationType.SUBTREE_MODIFIED, ModificationType.DELETE);
                }
                if (!childNodes.isEmpty()) break;
                finalNode.deleteNode(identifier);
            }
        }
        return finalNode;
    }

    private static ModificationType compressModifications(ModificationType first, ModificationType second, boolean hasNoDataBefore) {
        return switch (first) {
            default -> throw new MatchException(null, null);
            case ModificationType.UNMODIFIED -> {
                if (hasNoDataBefore) {
                    switch (second) {
                        default: {
                            throw new MatchException(null, null);
                        }
                        case UNMODIFIED: 
                        case WRITE: 
                        case APPEARED: {
                            yield second;
                        }
                        case DELETE: 
                        case SUBTREE_MODIFIED: 
                        case DISAPPEARED: 
                    }
                    throw DataTreeCandidates.illegalModification(second, ModificationType.DELETE);
                }
                if (second == ModificationType.APPEARED) {
                    throw DataTreeCandidates.illegalModification(ModificationType.APPEARED, ModificationType.WRITE);
                }
                yield second;
            }
            case ModificationType.WRITE -> {
                switch (second) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case SUBTREE_MODIFIED: 
                    case UNMODIFIED: 
                    case WRITE: {
                        yield ModificationType.WRITE;
                    }
                    case DELETE: {
                        yield ModificationType.DELETE;
                    }
                    case DISAPPEARED: {
                        yield ModificationType.DISAPPEARED;
                    }
                    case APPEARED: 
                }
                throw DataTreeCandidates.illegalModification(ModificationType.APPEARED, first);
            }
            case ModificationType.DELETE -> {
                switch (second) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case UNMODIFIED: {
                        yield ModificationType.DELETE;
                    }
                    case WRITE: 
                    case APPEARED: {
                        yield ModificationType.WRITE;
                    }
                    case DELETE: 
                    case SUBTREE_MODIFIED: 
                    case DISAPPEARED: 
                }
                throw DataTreeCandidates.illegalModification(second, first);
            }
            case ModificationType.APPEARED -> {
                switch (second) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case SUBTREE_MODIFIED: 
                    case UNMODIFIED: {
                        yield ModificationType.APPEARED;
                    }
                    case DELETE: 
                    case DISAPPEARED: {
                        yield ModificationType.UNMODIFIED;
                    }
                    case WRITE: {
                        yield ModificationType.WRITE;
                    }
                    case APPEARED: 
                }
                throw DataTreeCandidates.illegalModification(ModificationType.APPEARED, first);
            }
            case ModificationType.DISAPPEARED -> {
                switch (second) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case UNMODIFIED: 
                    case WRITE: {
                        yield second;
                    }
                    case APPEARED: {
                        yield ModificationType.SUBTREE_MODIFIED;
                    }
                    case DELETE: 
                    case SUBTREE_MODIFIED: 
                    case DISAPPEARED: 
                }
                throw DataTreeCandidates.illegalModification(second, first);
            }
            case ModificationType.SUBTREE_MODIFIED -> {
                switch (second) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case SUBTREE_MODIFIED: 
                    case UNMODIFIED: {
                        yield ModificationType.SUBTREE_MODIFIED;
                    }
                    case DELETE: 
                    case WRITE: 
                    case DISAPPEARED: {
                        yield second;
                    }
                    case APPEARED: 
                }
                throw DataTreeCandidates.illegalModification(ModificationType.APPEARED, first);
            }
        };
    }

    private static IllegalArgumentException illegalModification(ModificationType first, ModificationType second) {
        return new IllegalArgumentException(String.valueOf(first) + " modification event on " + String.valueOf(second) + " node");
    }

    private static void applyToCursorAwareModification(CursorAwareDataTreeModification modification, DataTreeCandidate candidate) {
        YangInstanceIdentifier candidatePath = candidate.getRootPath();
        YangInstanceIdentifier parent = candidatePath.getParent();
        if (parent == null) {
            try (DataTreeModificationCursor cursor = modification.openCursor();){
                DataTreeCandidateNodes.applyRootToCursor(cursor, candidate.getRootNode());
            }
        }
        try (DataTreeModificationCursor cursor = (DataTreeModificationCursor)modification.openCursor(parent).orElseThrow();){
            DataTreeCandidateNodes.applyRootedNodeToCursor(cursor, candidatePath, candidate.getRootNode());
        }
    }

    private static final class NodeIterator {
        private final Iterator<DataTreeCandidateNode> iterator;
        private final YangInstanceIdentifier path;
        private final NodeIterator parent;

        NodeIterator(@Nullable NodeIterator parent, YangInstanceIdentifier path, Iterator<DataTreeCandidateNode> iterator) {
            this.iterator = Objects.requireNonNull(iterator);
            this.path = Objects.requireNonNull(path);
            this.parent = parent;
        }

        NodeIterator next(DataTreeModification modification) {
            block7: while (this.iterator.hasNext()) {
                DataTreeCandidateNode node = this.iterator.next();
                YangInstanceIdentifier child = this.path.node(node.name());
                ModificationType modificationType = node.modificationType();
                int n = 0;
                switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"DELETE", "APPEARED", "DISAPPEARED", "SUBTREE_MODIFIED", "UNMODIFIED", "WRITE"}, (ModificationType)modificationType, n)) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case -1: {
                        throw new NullPointerException("null modificationType");
                    }
                    case 0: {
                        modification.delete(child);
                        LOG.debug("Modification {} deleted path {}", (Object)modification, (Object)child);
                        continue block7;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        LOG.debug("Modification {} modified path {}", (Object)modification, (Object)child);
                        return new NodeIterator(this, child, node.childNodes().iterator());
                    }
                    case 4: {
                        LOG.debug("Modification {} unmodified path {}", (Object)modification, (Object)child);
                        continue block7;
                    }
                    case 5: 
                }
                modification.write(child, (NormalizedNode)Verify.verifyNotNull((Object)node.dataAfter()));
                LOG.debug("Modification {} written path {}", (Object)modification, (Object)child);
            }
            return this.parent;
        }
    }
}

