/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.tree.spi;

import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import java.lang.runtime.SwitchBootstraps;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.DistinctNodeContainer;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.tree.api.DataTreeCandidateNode;
import org.opendaylight.yangtools.yang.data.tree.api.ModificationType;
import org.opendaylight.yangtools.yang.data.tree.spi.AbstractDataTreeCandidateNode;

abstract sealed class DeletedDataTreeCandidateNode<T extends NormalizedNode>
extends AbstractDataTreeCandidateNode {
    private final @NonNull T dataBefore;

    private DeletedDataTreeCandidateNode(T dataBefore) {
        super(ModificationType.DELETE);
        this.dataBefore = (NormalizedNode)Objects.requireNonNull(dataBefore);
    }

    static @NonNull DeletedDataTreeCandidateNode<?> of(NormalizedNode dataBefore) {
        NormalizedNode normalizedNode = dataBefore;
        Objects.requireNonNull(normalizedNode);
        NormalizedNode normalizedNode2 = normalizedNode;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{DistinctNodeContainer.class}, (Object)normalizedNode2, n)) {
            case 0 -> {
                DistinctNodeContainer container = (DistinctNodeContainer)normalizedNode2;
                yield new Container(container);
            }
            default -> new Leaf(dataBefore);
        };
    }

    public final YangInstanceIdentifier.PathArgument name() {
        return this.dataBefore.name();
    }

    public final @NonNull T dataBefore() {
        return this.dataBefore;
    }

    public final T dataAfter() {
        return null;
    }

    @Override
    protected final MoreObjects.ToStringHelper addToStringAttributes(MoreObjects.ToStringHelper helper) {
        return helper.add("dataBefore", (Object)this.dataBefore.prettyTree());
    }

    private static final class Container
    extends DeletedDataTreeCandidateNode<DistinctNodeContainer<?, ?>> {
        Container(DistinctNodeContainer<?, ?> dataBefore) {
            super(dataBefore);
        }

        public Collection<DataTreeCandidateNode> childNodes() {
            return Container.childNodes((DistinctNodeContainer)this.dataBefore(), (Function<NormalizedNode, DataTreeCandidateNode>)((Function)DeletedDataTreeCandidateNode::of));
        }

        public DataTreeCandidateNode modifiedChild(YangInstanceIdentifier.PathArgument childName) {
            return Container.modifiedChild((DistinctNodeContainer)this.dataBefore(), (Function<NormalizedNode, DataTreeCandidateNode>)((Function)DeletedDataTreeCandidateNode::of), childName);
        }
    }

    private static final class Leaf
    extends DeletedDataTreeCandidateNode<NormalizedNode> {
        Leaf(NormalizedNode dataBefore) {
            super(dataBefore);
        }

        public List<DataTreeCandidateNode> childNodes() {
            return List.of();
        }

        public DataTreeCandidateNode modifiedChild(YangInstanceIdentifier.PathArgument childName) {
            return null;
        }
    }
}

