/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.access.commands;

import akka.actor.ActorRef;
import com.google.common.base.Preconditions;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.opendaylight.controller.cluster.access.ABIVersion;
import org.opendaylight.controller.cluster.access.commands.AbstractReadTransactionRequest;
import org.opendaylight.controller.cluster.access.commands.ITSR;
import org.opendaylight.controller.cluster.access.concepts.TransactionIdentifier;
import org.opendaylight.yangtools.concepts.WritableObjects;

public final class IncrementTransactionSequenceRequest
extends AbstractReadTransactionRequest<IncrementTransactionSequenceRequest> {
    private static final long serialVersionUID = 1L;
    private final long increment;

    public IncrementTransactionSequenceRequest(IncrementTransactionSequenceRequest request, ABIVersion version) {
        super(request, version);
        this.increment = request.increment;
    }

    public IncrementTransactionSequenceRequest(TransactionIdentifier identifier, long sequence, ActorRef replyTo, boolean snapshotOnly, long increment) {
        super(identifier, sequence, replyTo, snapshotOnly);
        Preconditions.checkArgument((increment >= 0L ? 1 : 0) != 0, (String)"Unexpected increment %s", (long)increment);
        this.increment = increment;
    }

    public long getIncrement() {
        return this.increment;
    }

    @Override
    protected SerialForm externalizableProxy(ABIVersion version) {
        return new ITSR(this);
    }

    @Override
    protected IncrementTransactionSequenceRequest cloneAsVersion(ABIVersion targetVersion) {
        return new IncrementTransactionSequenceRequest(this, targetVersion);
    }

    static interface SerialForm
    extends AbstractReadTransactionRequest.SerialForm<IncrementTransactionSequenceRequest> {
        @Override
        default public void writeExternal(ObjectOutput out, IncrementTransactionSequenceRequest msg) throws IOException {
            AbstractReadTransactionRequest.SerialForm.super.writeExternal(out, msg);
            WritableObjects.writeLong((DataOutput)out, (long)msg.getIncrement());
        }

        @Override
        default public IncrementTransactionSequenceRequest readExternal(ObjectInput in, TransactionIdentifier target, long sequence, ActorRef replyTo, boolean snapshotOnly) throws IOException {
            return new IncrementTransactionSequenceRequest(target, sequence, replyTo, snapshotOnly, WritableObjects.readLong((DataInput)in));
        }
    }
}

