/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.access.commands;

import akka.actor.ActorRef;
import com.google.common.base.Preconditions;
import java.io.DataInput;
import java.io.IOException;
import org.opendaylight.controller.cluster.access.ABIVersion;
import org.opendaylight.controller.cluster.access.commands.LocalHistoryFailure;
import org.opendaylight.controller.cluster.access.concepts.LocalHistoryIdentifier;
import org.opendaylight.controller.cluster.access.concepts.Request;
import org.opendaylight.controller.cluster.access.concepts.RequestException;

public abstract class LocalHistoryRequest<T extends LocalHistoryRequest<T>>
extends Request<LocalHistoryIdentifier, T> {
    private static final long serialVersionUID = 1L;

    LocalHistoryRequest(LocalHistoryIdentifier target, long sequence, ActorRef replyTo) {
        super(target, sequence, replyTo);
        Preconditions.checkArgument((target.getHistoryId() != 0L ? 1 : 0) != 0, (Object)"History identifier must be non-zero");
    }

    LocalHistoryRequest(T request, ABIVersion version) {
        super(request, version);
    }

    public final LocalHistoryFailure toRequestFailure(RequestException cause) {
        return new LocalHistoryFailure((LocalHistoryIdentifier)this.getTarget(), this.getSequence(), cause);
    }

    @Override
    protected abstract SerialForm<T> externalizableProxy(ABIVersion var1);

    static interface SerialForm<T extends LocalHistoryRequest<T>>
    extends Request.SerialForm<LocalHistoryIdentifier, T> {
        @Override
        default public LocalHistoryIdentifier readTarget(DataInput in) throws IOException {
            return LocalHistoryIdentifier.readFrom(in);
        }
    }
}

