/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.access.commands;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.concepts.WritableObject;

public enum PersistenceProtocol implements WritableObject
{
    ABORT{

        @Override
        byte byteValue() {
            return 1;
        }
    }
    ,
    SIMPLE{

        @Override
        byte byteValue() {
            return 2;
        }
    }
    ,
    THREE_PHASE{

        @Override
        byte byteValue() {
            return 3;
        }
    }
    ,
    READY{

        @Override
        byte byteValue() {
            return 4;
        }
    };


    public final void writeTo(DataOutput out) throws IOException {
        out.writeByte(this.byteValue());
    }

    public static PersistenceProtocol readFrom(DataInput in) throws IOException {
        return PersistenceProtocol.valueOf(in.readByte());
    }

    abstract byte byteValue();

    static int byteValue(PersistenceProtocol finish) {
        return finish == null ? (byte)0 : finish.byteValue();
    }

    static @Nullable PersistenceProtocol valueOf(byte value) {
        return switch (value) {
            case 0 -> null;
            case 1 -> ABORT;
            case 2 -> SIMPLE;
            case 3 -> THREE_PHASE;
            case 4 -> READY;
            default -> throw new IllegalArgumentException("Unhandled byte value " + value);
        };
    }
}

