/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.access.commands;

import akka.actor.ActorRef;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.UnsignedLong;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.controller.cluster.access.ABIVersion;
import org.opendaylight.controller.cluster.access.commands.STR;
import org.opendaylight.controller.cluster.access.commands.TransactionRequest;
import org.opendaylight.controller.cluster.access.concepts.TransactionIdentifier;
import org.opendaylight.yangtools.concepts.WritableObjects;

public final class SkipTransactionsRequest
extends TransactionRequest<SkipTransactionsRequest> {
    private static final long serialVersionUID = 1L;
    private final @NonNull ImmutableList<UnsignedLong> others;

    public SkipTransactionsRequest(TransactionIdentifier target, long sequence, ActorRef replyTo, Collection<UnsignedLong> others) {
        super(target, sequence, replyTo);
        this.others = ImmutableList.copyOf(others);
    }

    private SkipTransactionsRequest(SkipTransactionsRequest request, ABIVersion version) {
        super(request, version);
        this.others = request.others;
    }

    public List<UnsignedLong> getOthers() {
        return this.others;
    }

    @Override
    protected SerialForm externalizableProxy(ABIVersion version) {
        return new STR(this);
    }

    @Override
    protected SkipTransactionsRequest cloneAsVersion(ABIVersion version) {
        return new SkipTransactionsRequest(this, version);
    }

    @Override
    protected MoreObjects.ToStringHelper addToStringAttributes(MoreObjects.ToStringHelper toStringHelper) {
        MoreObjects.ToStringHelper helper = super.addToStringAttributes(toStringHelper);
        if (!this.others.isEmpty()) {
            helper.add("others", this.others);
        }
        return helper;
    }

    static interface SerialForm
    extends TransactionRequest.SerialForm<SkipTransactionsRequest> {
        @Override
        default public SkipTransactionsRequest readExternal(ObjectInput in, TransactionIdentifier target, long sequence, ActorRef replyTo) throws IOException {
            int idx;
            int size = in.readInt();
            ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize((int)size);
            if (size % 2 != 0) {
                builder.add((Object)UnsignedLong.fromLongBits((long)WritableObjects.readLong((DataInput)in)));
                idx = 1;
            } else {
                idx = 0;
            }
            while (idx < size) {
                byte hdr = WritableObjects.readLongHeader((DataInput)in);
                builder.add((Object)UnsignedLong.fromLongBits((long)WritableObjects.readFirstLong((DataInput)in, (byte)hdr)));
                builder.add((Object)UnsignedLong.fromLongBits((long)WritableObjects.readSecondLong((DataInput)in, (byte)hdr)));
                idx += 2;
            }
            return new SkipTransactionsRequest(target, sequence, replyTo, (Collection<UnsignedLong>)builder.build());
        }

        @Override
        default public void writeExternal(ObjectOutput out, SkipTransactionsRequest msg) throws IOException {
            int idx;
            TransactionRequest.SerialForm.super.writeExternal(out, msg);
            ImmutableList<UnsignedLong> others = msg.others;
            int size = others.size();
            out.writeInt(size);
            if (size % 2 != 0) {
                WritableObjects.writeLong((DataOutput)out, (long)((UnsignedLong)others.get(0)).longValue());
                idx = 1;
            } else {
                idx = 0;
            }
            while (idx < size) {
                WritableObjects.writeLongs((DataOutput)out, (long)((UnsignedLong)others.get(idx)).longValue(), (long)((UnsignedLong)others.get(idx + 1)).longValue());
                idx += 2;
            }
        }
    }
}

