/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.access.commands;

import com.google.common.base.MoreObjects;
import java.io.IOException;
import java.util.Objects;
import org.opendaylight.controller.cluster.access.commands.TransactionDataModification;
import org.opendaylight.controller.cluster.access.commands.TransactionDelete;
import org.opendaylight.controller.cluster.access.commands.TransactionMerge;
import org.opendaylight.controller.cluster.access.commands.TransactionWrite;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.stream.ReusableStreamReceiver;
import org.opendaylight.yangtools.yang.data.codec.binfmt.NormalizedNodeDataInput;
import org.opendaylight.yangtools.yang.data.codec.binfmt.NormalizedNodeDataOutput;

public abstract sealed class TransactionModification
permits TransactionDelete, TransactionDataModification {
    static final byte TYPE_DELETE = 1;
    static final byte TYPE_MERGE = 2;
    static final byte TYPE_WRITE = 3;
    private final YangInstanceIdentifier path;

    TransactionModification(YangInstanceIdentifier path) {
        this.path = Objects.requireNonNull(path);
    }

    public final YangInstanceIdentifier getPath() {
        return this.path;
    }

    public final String toString() {
        return MoreObjects.toStringHelper((Object)this).add("path", (Object)this.path).toString();
    }

    abstract byte getType();

    void writeTo(NormalizedNodeDataOutput out) throws IOException {
        out.writeByte((int)this.getType());
        out.writeYangInstanceIdentifier(this.path);
    }

    static TransactionModification readFrom(NormalizedNodeDataInput in, ReusableStreamReceiver writer) throws IOException {
        byte type = in.readByte();
        return switch (type) {
            case 1 -> new TransactionDelete(in.readYangInstanceIdentifier());
            case 2 -> new TransactionMerge(in.readYangInstanceIdentifier(), in.readNormalizedNode(writer));
            case 3 -> new TransactionWrite(in.readYangInstanceIdentifier(), in.readNormalizedNode(writer));
            default -> throw new IllegalArgumentException("Unhandled type " + type);
        };
    }
}

