/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.access.concepts;

import com.google.common.base.Verify;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Objects;
import org.opendaylight.controller.cluster.access.concepts.LocalHistoryIdentifier;
import org.opendaylight.controller.cluster.access.concepts.TransactionIdentifier;
import org.opendaylight.yangtools.concepts.WritableObjects;

final class TI
implements Externalizable {
    private static final long serialVersionUID = 1L;
    private TransactionIdentifier identifier;

    public TI() {
    }

    TI(TransactionIdentifier identifier) {
        this.identifier = Objects.requireNonNull(identifier);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        this.identifier = new TransactionIdentifier(LocalHistoryIdentifier.readFrom(in), WritableObjects.readLong((DataInput)in));
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        this.identifier.getHistoryId().writeTo(out);
        WritableObjects.writeLong((DataOutput)out, (long)this.identifier.getTransactionId());
    }

    private Object readResolve() {
        return Verify.verifyNotNull((Object)this.identifier);
    }
}

