/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.stmt.reactor;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.base.VerifyException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.meta.StatementSourceReference;
import org.opendaylight.yangtools.yang.parser.spi.meta.BoundStmtCtx;
import org.opendaylight.yangtools.yang.parser.spi.meta.ModelProcessingPhase;
import org.opendaylight.yangtools.yang.parser.spi.meta.NamespaceStmtCtx;
import org.opendaylight.yangtools.yang.parser.spi.meta.StatementFactory;
import org.opendaylight.yangtools.yang.parser.spi.meta.StatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.source.StatementWriter;
import org.opendaylight.yangtools.yang.parser.stmt.reactor.ImplicitStmtCtx;
import org.opendaylight.yangtools.yang.parser.stmt.reactor.InferredStatementContext;
import org.opendaylight.yangtools.yang.parser.stmt.reactor.OriginalStmtCtx;
import org.opendaylight.yangtools.yang.parser.stmt.reactor.ReactorStmtCtx;
import org.opendaylight.yangtools.yang.parser.stmt.reactor.StatementContextBase;
import org.opendaylight.yangtools.yang.parser.stmt.reactor.StatementDefinitionContext;
import org.opendaylight.yangtools.yang.parser.stmt.reactor.StatementMap;
import org.opendaylight.yangtools.yang.parser.stmt.reactor.SubstatementContext;
import org.opendaylight.yangtools.yang.parser.stmt.reactor.UndeclaredStmtCtx;

abstract class AbstractResumedStatement<A, D extends DeclaredStatement<A>, E extends EffectiveStatement<A, D>>
extends OriginalStmtCtx<A, D, E>
implements StatementWriter.ResumedStatement {
    private final String rawArgument;
    private StatementMap substatements = StatementMap.empty();
    private @Nullable D declaredInstance;
    private boolean implicitDeclared;
    private boolean fullyDefined;

    AbstractResumedStatement(AbstractResumedStatement<A, D, E> original) {
        super(original);
        this.rawArgument = original.rawArgument;
        this.substatements = original.substatements;
        this.declaredInstance = original.declaredInstance;
        this.fullyDefined = original.fullyDefined;
    }

    AbstractResumedStatement(StatementDefinitionContext<A, D, E> def, StatementSourceReference ref, String rawArgument) {
        super(def, ref);
        this.rawArgument = def.support().internArgument(rawArgument);
    }

    public final String rawArgument() {
        return this.rawArgument;
    }

    @Override
    public Collection<? extends StatementContextBase<?, ?, ?>> mutableDeclaredSubstatements() {
        return (Collection)Verify.verifyNotNull((Object)this.substatements, (String)"Substatements no longer available in %s", (Object[])new Object[]{this});
    }

    public final D declared() {
        D existing = this.declaredInstance;
        return existing != null ? existing : this.loadDeclared();
    }

    private @NonNull D loadDeclared() {
        ModelProcessingPhase phase = this.getCompletedPhase();
        switch (phase) {
            case FULL_DECLARATION: 
            case EFFECTIVE_MODEL: {
                this.declaredInstance = this.definition().getFactory().createDeclared((BoundStmtCtx)this, this.substatementsAsDeclared());
                break;
            }
            default: {
                throw new IllegalStateException("Cannot build declared instance after phase " + String.valueOf(phase));
            }
        }
        return this.declaredInstance;
    }

    private @NonNull Stream<DeclaredStatement<?>> substatementsAsDeclared() {
        Stream<Object> stream = this.implicitDeclared ? this.substatements.stream().map(AbstractResumedStatement::unmaskUndeclared) : this.substatements.stream();
        return stream.map(AbstractResumedStatement::declared);
    }

    public final StatementDefinition getDefinition() {
        return this.publicDefinition();
    }

    public final StatementSourceReference getSourceReference() {
        return this.sourceReference();
    }

    public final boolean isFullyDefined() {
        return this.fullyDefined;
    }

    final void setFullyDefined() {
        this.fullyDefined = true;
    }

    @Override
    final E createEffective(StatementFactory<A, D, E> factory) {
        return this.createEffective(factory, this, this.streamDeclared(), this.streamEffective());
    }

    private @NonNull E createEffective(StatementFactory<A, D, E> factory, StatementContextBase<A, D, E> ctx, Stream<? extends StmtContext<?, ?, ?>> declared, Stream<? extends ReactorStmtCtx<?, ?, ?>> effective) {
        ctx.declared();
        return (E)factory.createEffective(ctx, AbstractResumedStatement.orderSubstatements(declared, effective));
    }

    private static @NonNull Stream<StmtContext<?, ?, ?>> orderSubstatements(Stream<? extends StmtContext<?, ?, ?>> declaredSubstatements, Stream<? extends StmtContext<?, ?, ?>> effectiveSubstatements) {
        Stream<StmtContext<?, ?, ?>> effective;
        List declaredInit = declaredSubstatements.filter(StmtContext::isSupportedByFeatures).collect(Collectors.toList());
        ArrayList<StmtContext> substatementsInit = new ArrayList<StmtContext>();
        HashSet filteredStatements = null;
        for (StmtContext declaredSubstatement : declaredInit) {
            substatementsInit.add(declaredSubstatement);
            Collection effect = declaredSubstatement.getEffectOfStatement();
            if (effect.isEmpty()) continue;
            if (filteredStatements == null) {
                filteredStatements = new HashSet();
            }
            filteredStatements.addAll(effect);
            effect.stream().filter(StmtContext::isSupportedToBuildEffective).forEach(substatementsInit::add);
        }
        if (filteredStatements != null) {
            HashSet filtered = filteredStatements;
            effective = effectiveSubstatements.filter(stmt -> !filtered.contains(stmt));
        } else {
            effective = effectiveSubstatements;
        }
        substatementsInit.addAll(effective.collect(Collectors.toList()));
        return substatementsInit.stream();
    }

    @Override
    final E createInferredEffective(StatementFactory<A, D, E> factory, InferredStatementContext<A, D, E> ctx, Stream<? extends ReactorStmtCtx<?, ?, ?>> declared, Stream<? extends ReactorStmtCtx<?, ?, ?>> effective) {
        return this.createEffective(factory, ctx, declared, effective);
    }

    final <X, Y extends DeclaredStatement<X>, Z extends EffectiveStatement<X, Y>> AbstractResumedStatement<X, Y, Z> createSubstatement(int offset, StatementDefinitionContext<X, Y, Z> def, StatementSourceReference ref, String argument) {
        SubstatementContext<X, Y, Z> ret;
        ModelProcessingPhase inProgressPhase = this.getRoot().getSourceContext().getInProgressPhase();
        Preconditions.checkState((inProgressPhase != ModelProcessingPhase.EFFECTIVE_MODEL ? 1 : 0) != 0, (String)"Declared statement cannot be added in effective phase at: %s", (Object)this.sourceReference());
        Optional<StatementSupport<?, ?, ?>> implicitParent = this.definition().getImplicitParentFor((NamespaceStmtCtx)this, def.getPublicView());
        if (implicitParent.isPresent()) {
            this.implicitDeclared = true;
            UndeclaredStmtCtx<X, X, X> parent = this.createUndeclared(offset, implicitParent.orElseThrow(), ref, argument);
            ret = new SubstatementContext<X, Y, Z>(parent, def, ref, argument);
            parent.addEffectiveSubstatement(ret);
        } else {
            ret = new SubstatementContext<X, Y, Z>(this, def, ref, argument);
            this.substatements = this.substatements.put(offset, ret);
        }
        def.onStatementAdded(ret);
        return ret;
    }

    private <X, Y extends DeclaredStatement<X>, Z extends EffectiveStatement<X, Y>> UndeclaredStmtCtx<X, Y, Z> createUndeclared(int offset, StatementSupport<X, Y, Z> support, StatementSourceReference ref, String argument) {
        ImplicitStmtCtx<X, Y, Z> ret;
        Optional<StatementSupport<?, ?, ?>> implicitParent = this.definition().getImplicitParentFor((NamespaceStmtCtx)this, support.getPublicView());
        if (implicitParent.isPresent()) {
            UndeclaredStmtCtx<X, X, X> parent = this.createUndeclared(offset, implicitParent.orElseThrow(), ref, argument);
            ret = new ImplicitStmtCtx<X, Y, Z>((StatementContextBase<?, ?, ?>)parent, support, argument);
            parent.addEffectiveSubstatement(ret);
        } else {
            ret = new ImplicitStmtCtx<X, Y, Z>((StatementContextBase<?, ?, ?>)this, support, argument);
            this.substatements = this.substatements.put(offset, ret);
        }
        support.onStatementAdded(ret);
        return ret;
    }

    @Override
    final Stream<? extends @NonNull ReactorStmtCtx<?, ?, ?>> streamDeclared() {
        return this.substatements.stream().filter(StmtContext::isSupportedToBuildEffective);
    }

    @Override
    final void dropDeclaredSubstatements() {
        this.substatements = null;
    }

    final @Nullable AbstractResumedStatement<?, ?, ?> enterSubstatement(int offset) {
        OriginalStmtCtx<?, ?, ?> stmt = this.substatements.get(offset);
        return stmt == null ? null : AbstractResumedStatement.unmaskUndeclared(stmt);
    }

    private static @NonNull AbstractResumedStatement<?, ?, ?> unmaskUndeclared(ReactorStmtCtx<?, ?, ?> stmt) {
        ReactorStmtCtx<?, ?, ?> ret;
        block1: {
            ret = stmt;
            while (true) {
                if (ret instanceof AbstractResumedStatement) break block1;
                if (!(ret instanceof UndeclaredStmtCtx)) break;
                UndeclaredStmtCtx undeclared = (UndeclaredStmtCtx)ret;
                ret = undeclared.getResumedSubstatement();
            }
            throw new VerifyException("Unexpected statement " + String.valueOf(ret));
        }
        AbstractResumedStatement resumed = (AbstractResumedStatement)ret;
        return resumed;
    }

    final @Nullable AbstractResumedStatement<?, ?, ?> exitStatement(ModelProcessingPhase phase) {
        this.finishDeclaration(phase);
        StmtContext.Mutable parent = this.getParentContext();
        if (parent == null) {
            return null;
        }
        OriginalStmtCtx<?, ?, ?> ret = AbstractResumedStatement.verifyParent(parent);
        while (true) {
            if (ret instanceof AbstractResumedStatement) break;
            ret.finishDeclaration(phase);
            ret = AbstractResumedStatement.verifyParent(ret.getParentContext());
        }
        AbstractResumedStatement resumed = (AbstractResumedStatement)ret;
        return resumed;
    }

    private static OriginalStmtCtx<?, ?, ?> verifyParent(StatementContextBase<?, ?, ?> parent) {
        if (parent instanceof OriginalStmtCtx) {
            OriginalStmtCtx original = (OriginalStmtCtx)parent;
            return original;
        }
        throw new VerifyException("Unexpected parent context " + String.valueOf(parent));
    }

    final void resizeSubstatements(int expectedSize) {
        this.substatements = this.substatements.ensureCapacity(expectedSize);
    }

    @Override
    final void declarationFinished(ModelProcessingPhase phase) {
        this.finishChildrenDeclaration(phase);
        this.finishDeclaration(phase);
    }

    private void finishChildrenDeclaration(ModelProcessingPhase phase) {
        Preconditions.checkState((boolean)this.isFullyDefined());
        this.substatements.forEach(stmt -> stmt.declarationFinished(phase));
    }
}

