/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.databroker.actors.dds;

import akka.actor.ActorRef;
import akka.pattern.Patterns;
import com.google.common.base.Throwables;
import com.google.common.base.Verify;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.opendaylight.controller.cluster.access.client.AbstractClientActor;
import org.opendaylight.controller.cluster.access.client.ClientActorConfig;
import org.opendaylight.controller.cluster.access.client.ClientActorContext;
import org.opendaylight.controller.cluster.access.concepts.FrontendIdentifier;
import org.opendaylight.controller.cluster.databroker.actors.dds.AbstractDataStoreClientBehavior;
import org.opendaylight.controller.cluster.databroker.actors.dds.DataStoreClient;
import org.opendaylight.controller.cluster.databroker.actors.dds.GetClientRequest;
import org.opendaylight.controller.cluster.datastore.utils.ActorUtils;

public abstract class AbstractDataStoreClientActor
extends AbstractClientActor {
    private final ActorUtils actorUtils;

    AbstractDataStoreClientActor(FrontendIdentifier frontendId, ActorUtils actorUtils) {
        super(frontendId);
        this.actorUtils = Objects.requireNonNull(actorUtils);
    }

    protected ClientActorConfig getClientActorConfig() {
        return this.actorUtils.getDatastoreContext();
    }

    protected final AbstractDataStoreClientBehavior initialBehavior(ClientActorContext context) {
        return (AbstractDataStoreClientBehavior)Verify.verifyNotNull((Object)this.initialBehavior(context, this.actorUtils));
    }

    abstract AbstractDataStoreClientBehavior initialBehavior(ClientActorContext var1, ActorUtils var2);

    public static DataStoreClient getDistributedDataStoreClient(@NonNull ActorRef actor, long timeout, TimeUnit unit) {
        CompletionStage<DataStoreClient> future = AbstractDataStoreClientActor.requestDistributedDataStoreClient(actor, Duration.of(timeout, unit.toChronoUnit()));
        try {
            return future.toCompletableFuture().get();
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new IllegalStateException(e);
        }
    }

    @NonNullByDefault
    public static CompletionStage<DataStoreClient> requestDistributedDataStoreClient(ActorRef actor, Duration timeout) {
        return Patterns.askWithReplyTo((ActorRef)actor, GetClientRequest::new, (Duration)timeout).thenApply(DataStoreClient.class::cast);
    }
}

