/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.databroker.actors.dds;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.Objects;
import org.opendaylight.controller.cluster.access.concepts.TransactionIdentifier;
import org.opendaylight.controller.cluster.databroker.actors.dds.AbstractClientHistory;
import org.opendaylight.controller.cluster.databroker.actors.dds.AbstractProxyTransaction;
import org.opendaylight.controller.cluster.databroker.actors.dds.AbstractTransactionCommitCohort;
import org.opendaylight.mdsal.common.api.CommitInfo;
import org.opendaylight.yangtools.yang.common.Empty;

final class DirectTransactionCommitCohort
extends AbstractTransactionCommitCohort {
    private final AbstractProxyTransaction proxy;

    DirectTransactionCommitCohort(AbstractClientHistory parent, TransactionIdentifier txId, AbstractProxyTransaction proxy) {
        super(parent, txId);
        this.proxy = Objects.requireNonNull(proxy);
    }

    public ListenableFuture<Boolean> canCommit() {
        return this.proxy.directCommit();
    }

    public ListenableFuture<Empty> preCommit() {
        return Empty.immediateFuture();
    }

    public ListenableFuture<Empty> abort() {
        this.complete();
        return Empty.immediateFuture();
    }

    public ListenableFuture<CommitInfo> commit() {
        this.complete();
        return CommitInfo.emptyFluentFuture();
    }
}

