/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore;

import akka.actor.ActorRef;
import akka.actor.Status;
import akka.dispatch.ExecutionContexts;
import akka.dispatch.Futures;
import akka.dispatch.OnComplete;
import akka.dispatch.Recover;
import akka.pattern.Patterns;
import akka.util.Timeout;
import com.google.common.base.Preconditions;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.controller.cluster.access.concepts.TransactionIdentifier;
import org.opendaylight.controller.cluster.datastore.DataTreeCohortActor;
import org.opendaylight.controller.cluster.datastore.DataTreeCohortActorRegistry;
import org.opendaylight.yangtools.yang.common.Empty;
import org.opendaylight.yangtools.yang.data.tree.api.DataTreeCandidate;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.jdk.javaapi.FutureConverters;

class CompositeDataTreeCohort {
    private static final Logger LOG = LoggerFactory.getLogger(CompositeDataTreeCohort.class);
    static final Recover<Object> EXCEPTION_TO_MESSAGE = new Recover<Object>(){

        public Status.Failure recover(Throwable error) {
            return new Status.Failure(error);
        }
    };
    private final DataTreeCohortActorRegistry registry;
    private final TransactionIdentifier txId;
    private final EffectiveModelContext schema;
    private final Executor callbackExecutor;
    private final Timeout timeout;
    private @NonNull List<DataTreeCohortActor.Success> successfulFromPrevious = List.of();
    private State state = State.IDLE;

    CompositeDataTreeCohort(DataTreeCohortActorRegistry registry, TransactionIdentifier transactionID, EffectiveModelContext schema, Executor callbackExecutor, Timeout timeout) {
        this.registry = Objects.requireNonNull(registry);
        this.txId = Objects.requireNonNull(transactionID);
        this.schema = Objects.requireNonNull(schema);
        this.callbackExecutor = Objects.requireNonNull(callbackExecutor);
        this.timeout = Objects.requireNonNull(timeout);
    }

    void reset() {
        switch (this.state.ordinal()) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                this.abort();
                break;
            }
            case 0: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            default: {
                throw new IllegalStateException("Unhandled state " + String.valueOf((Object)this.state));
            }
        }
        this.successfulFromPrevious = List.of();
        this.state = State.IDLE;
    }

    @Nullable CompletionStage<Empty> canCommit(DataTreeCandidate tip) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("{}: canCommit - candidate: {}", (Object)this.txId, (Object)tip);
        } else {
            LOG.debug("{}: canCommit - candidate rootPath: {}", (Object)this.txId, (Object)tip.getRootPath());
        }
        List<DataTreeCohortActor.CanCommit> messages = this.registry.createCanCommitMessages(this.txId, tip, this.schema);
        LOG.debug("{}: canCommit - messages: {}", (Object)this.txId, messages);
        if (messages.isEmpty()) {
            this.successfulFromPrevious = List.of();
            this.changeStateFrom(State.IDLE, State.CAN_COMMIT_SUCCESSFUL);
            return null;
        }
        List<Future<Object>> futures = messages.stream().map(message -> {
            ActorRef actor = message.getCohort();
            LOG.trace("{}: requesting canCommit from {}", (Object)this.txId, (Object)actor);
            return Patterns.ask((ActorRef)actor, (Object)message, (Timeout)this.timeout).recover(EXCEPTION_TO_MESSAGE, (ExecutionContext)ExecutionContexts.global());
        }).collect(Collectors.toList());
        this.changeStateFrom(State.IDLE, State.CAN_COMMIT_SENT);
        return this.processResponses(futures, State.CAN_COMMIT_SENT, State.CAN_COMMIT_SUCCESSFUL);
    }

    @Nullable CompletionStage<Empty> preCommit() {
        LOG.debug("{}: preCommit - successfulFromPrevious: {}", (Object)this.txId, this.successfulFromPrevious);
        if (this.successfulFromPrevious.isEmpty()) {
            this.changeStateFrom(State.CAN_COMMIT_SUCCESSFUL, State.PRE_COMMIT_SUCCESSFUL);
            return null;
        }
        List<Future<Object>> futures = this.sendMessageToSuccessful(new DataTreeCohortActor.PreCommit(this.txId));
        this.changeStateFrom(State.CAN_COMMIT_SUCCESSFUL, State.PRE_COMMIT_SENT);
        return this.processResponses(futures, State.PRE_COMMIT_SENT, State.PRE_COMMIT_SUCCESSFUL);
    }

    @Nullable CompletionStage<Empty> commit() {
        LOG.debug("{}: commit - successfulFromPrevious: {}", (Object)this.txId, this.successfulFromPrevious);
        if (this.successfulFromPrevious.isEmpty()) {
            this.changeStateFrom(State.PRE_COMMIT_SUCCESSFUL, State.COMMITED);
            return null;
        }
        List<Future<Object>> futures = this.sendMessageToSuccessful(new DataTreeCohortActor.Commit(this.txId));
        this.changeStateFrom(State.PRE_COMMIT_SUCCESSFUL, State.COMMIT_SENT);
        return this.processResponses(futures, State.COMMIT_SENT, State.COMMITED);
    }

    @Nullable CompletionStage<Empty> abort() {
        LOG.debug("{}: abort - successfulFromPrevious: {}", (Object)this.txId, this.successfulFromPrevious);
        this.state = State.ABORTED;
        if (this.successfulFromPrevious.isEmpty()) {
            return null;
        }
        DataTreeCohortActor.Abort message = new DataTreeCohortActor.Abort(this.txId);
        return FutureConverters.asJava((Future)Futures.sequence((Iterable)this.successfulFromPrevious.stream().map(success -> Patterns.ask((ActorRef)success.getCohort(), (Object)message, (Timeout)this.timeout)).collect(Collectors.toList()), (ExecutionContext)ExecutionContexts.global())).thenApplyAsync(ignored -> Empty.value(), this.callbackExecutor);
    }

    private List<Future<Object>> sendMessageToSuccessful(Object message) {
        LOG.debug("{}: sendMesageToSuccessful: {}", (Object)this.txId, message);
        return this.successfulFromPrevious.stream().map(success -> Patterns.ask((ActorRef)success.getCohort(), (Object)message, (Timeout)this.timeout)).collect(Collectors.toList());
    }

    private @NonNull CompletionStage<Empty> processResponses(List<Future<Object>> futures, final State currentState, final State afterState) {
        LOG.debug("{}: processResponses - currentState: {}, afterState: {}", new Object[]{this.txId, currentState, afterState});
        final CompletableFuture<Empty> returnFuture = new CompletableFuture<Empty>();
        Futures.sequence(futures, (ExecutionContext)ExecutionContexts.global()).onComplete((Function1)new OnComplete<Iterable<Object>>(){

            public void onComplete(Throwable failure, Iterable<Object> results) {
                CompositeDataTreeCohort.this.callbackExecutor.execute(() -> CompositeDataTreeCohort.this.processResponses(failure, results, currentState, afterState, returnFuture));
            }
        }, (ExecutionContext)ExecutionContexts.global());
        return returnFuture;
    }

    private void processResponses(Throwable failure, Iterable<Object> results, State currentState, State afterState, CompletableFuture<Empty> resultFuture) {
        if (failure != null) {
            this.successfulFromPrevious = List.of();
            resultFuture.completeExceptionally(failure);
            return;
        }
        ArrayList<Status.Failure> failed = new ArrayList<Status.Failure>(1);
        ArrayList<DataTreeCohortActor.Success> successful = new ArrayList<DataTreeCohortActor.Success>();
        block4: for (Object result : results) {
            Object object;
            Objects.requireNonNull(result);
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{DataTreeCohortActor.Success.class, Status.Failure.class}, (Object)object, n)) {
                case 0: {
                    DataTreeCohortActor.Success success = (DataTreeCohortActor.Success)object;
                    successful.add(success);
                    continue block4;
                }
                case 1: {
                    Status.Failure fail = (Status.Failure)object;
                    failed.add(fail);
                    continue block4;
                }
            }
            LOG.warn("{}: unrecognized response {}, ignoring it", (Object)this.txId, result);
        }
        LOG.debug("{}: processResponses - successful: {}, failed: {}", new Object[]{this.txId, successful, failed});
        if (!failed.isEmpty()) {
            this.changeStateFrom(currentState, State.FAILED);
            Iterator it = failed.iterator();
            Throwable firstEx = ((Status.Failure)it.next()).cause();
            while (it.hasNext()) {
                firstEx.addSuppressed(((Status.Failure)it.next()).cause());
            }
            this.successfulFromPrevious = List.of();
            resultFuture.completeExceptionally(firstEx);
        } else {
            this.successfulFromPrevious = successful;
            this.changeStateFrom(currentState, afterState);
            resultFuture.complete(Empty.value());
        }
    }

    void changeStateFrom(State expected, State followup) {
        Preconditions.checkState((this.state == expected ? 1 : 0) != 0);
        this.state = followup;
    }

    private static enum State {
        IDLE,
        CAN_COMMIT_SENT,
        CAN_COMMIT_SUCCESSFUL,
        PRE_COMMIT_SENT,
        PRE_COMMIT_SUCCESSFUL,
        COMMIT_SENT,
        COMMITED,
        FAILED,
        ABORTED;

    }
}

