/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore;

import akka.actor.ActorRef;
import akka.actor.ActorSelection;
import akka.actor.PoisonPill;
import akka.dispatch.OnComplete;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.Objects;
import java.util.concurrent.Executor;
import org.checkerframework.checker.lock.qual.GuardedBy;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.controller.cluster.datastore.DataTreeChangeListenerActor;
import org.opendaylight.controller.cluster.datastore.exceptions.LocalShardNotFoundException;
import org.opendaylight.controller.cluster.datastore.messages.CloseDataTreeNotificationListenerRegistration;
import org.opendaylight.controller.cluster.datastore.messages.RegisterDataTreeChangeListener;
import org.opendaylight.controller.cluster.datastore.messages.RegisterDataTreeNotificationListenerReply;
import org.opendaylight.controller.cluster.datastore.utils.ActorUtils;
import org.opendaylight.mdsal.dom.api.DOMDataTreeChangeListener;
import org.opendaylight.yangtools.concepts.AbstractObjectRegistration;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;

final class DataTreeChangeListenerProxy
extends AbstractObjectRegistration<DOMDataTreeChangeListener> {
    private static final Logger LOG = LoggerFactory.getLogger(DataTreeChangeListenerProxy.class);
    private final ActorRef dataChangeListenerActor;
    private final ActorUtils actorUtils;
    private final YangInstanceIdentifier registeredPath;
    private final boolean clustered;
    private @GuardedBy(value={"this"}) ActorSelection listenerRegistrationActor;

    @VisibleForTesting
    private DataTreeChangeListenerProxy(ActorUtils actorUtils, DOMDataTreeChangeListener listener, YangInstanceIdentifier registeredPath, boolean clustered, String shardName) {
        super((Object)listener);
        this.actorUtils = Objects.requireNonNull(actorUtils);
        this.registeredPath = Objects.requireNonNull(registeredPath);
        this.clustered = clustered;
        this.dataChangeListenerActor = actorUtils.getActorSystem().actorOf(DataTreeChangeListenerActor.props((DOMDataTreeChangeListener)this.getInstance(), registeredPath).withDispatcher(actorUtils.getNotificationDispatcherPath()));
        LOG.debug("{}: Created actor {} for DTCL {}", new Object[]{actorUtils.getDatastoreContext().getLogicalStoreType(), this.dataChangeListenerActor, listener});
    }

    static @NonNull DataTreeChangeListenerProxy of(ActorUtils actorUtils, DOMDataTreeChangeListener listener, YangInstanceIdentifier registeredPath, boolean clustered, String shardName) {
        return DataTreeChangeListenerProxy.ofTesting(actorUtils, listener, registeredPath, clustered, shardName, MoreExecutors.directExecutor());
    }

    @VisibleForTesting
    static @NonNull DataTreeChangeListenerProxy ofTesting(ActorUtils actorUtils, final DOMDataTreeChangeListener listener, final YangInstanceIdentifier registeredPath, boolean clustered, final String shardName, Executor executor) {
        final DataTreeChangeListenerProxy ret = new DataTreeChangeListenerProxy(actorUtils, listener, registeredPath, clustered, shardName);
        executor.execute(() -> {
            LOG.debug("{}: Starting discovery of shard {}", (Object)ret.logContext(), (Object)shardName);
            actorUtils.findLocalShardAsync(shardName).onComplete((Function1)new OnComplete<ActorRef>(){

                public void onComplete(Throwable failure, ActorRef shard) {
                    if (failure instanceof LocalShardNotFoundException) {
                        LOG.debug("{}: No local shard found for {} - DataTreeChangeListener {} at path {} cannot be registered", new Object[]{ret.logContext(), shardName, listener, registeredPath});
                    } else if (failure != null) {
                        LOG.error("{}: Failed to find local shard {} - DataTreeChangeListener {} at path {} cannot be registered", new Object[]{ret.logContext(), shardName, listener, registeredPath, failure});
                    } else {
                        ret.doRegistration(shard);
                    }
                }
            }, actorUtils.getClientDispatcher());
        });
        return ret;
    }

    protected synchronized void removeRegistration() {
        if (this.listenerRegistrationActor != null) {
            this.listenerRegistrationActor.tell((Object)CloseDataTreeNotificationListenerRegistration.getInstance(), ActorRef.noSender());
            this.listenerRegistrationActor = null;
        }
        this.dataChangeListenerActor.tell((Object)PoisonPill.getInstance(), ActorRef.noSender());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setListenerRegistrationActor(ActorSelection actor) {
        if (actor == null) {
            LOG.debug("{}: Ignoring null actor on {}", (Object)this.logContext(), (Object)this);
            return;
        }
        DataTreeChangeListenerProxy dataTreeChangeListenerProxy = this;
        synchronized (dataTreeChangeListenerProxy) {
            if (!this.isClosed()) {
                this.listenerRegistrationActor = actor;
                return;
            }
        }
        actor.tell((Object)CloseDataTreeNotificationListenerRegistration.getInstance(), null);
    }

    private void doRegistration(ActorRef shard) {
        this.actorUtils.executeOperationAsync(shard, (Object)new RegisterDataTreeChangeListener(this.registeredPath, this.dataChangeListenerActor, this.clustered), this.actorUtils.getDatastoreContext().getShardInitializationTimeout()).onComplete((Function1)new OnComplete<Object>(){

            public void onComplete(Throwable failure, Object result) {
                if (failure != null) {
                    LOG.error("{}: Failed to register DataTreeChangeListener {} at path {}", new Object[]{DataTreeChangeListenerProxy.this.logContext(), DataTreeChangeListenerProxy.this.getInstance(), DataTreeChangeListenerProxy.this.registeredPath, failure});
                } else {
                    DataTreeChangeListenerProxy.this.setListenerRegistrationActor(DataTreeChangeListenerProxy.this.actorUtils.actorSelection(((RegisterDataTreeNotificationListenerReply)result).getListenerRegistrationPath()));
                }
            }
        }, this.actorUtils.getClientDispatcher());
    }

    @VisibleForTesting
    synchronized ActorSelection getListenerRegistrationActor() {
        return this.listenerRegistrationActor;
    }

    @VisibleForTesting
    ActorRef getDataChangeListenerActor() {
        return this.dataChangeListenerActor;
    }

    private String logContext() {
        return this.actorUtils.getDatastoreContext().getLogicalStoreType().toString();
    }
}

