/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore;

import java.util.concurrent.TimeUnit;
import org.opendaylight.controller.cluster.datastore.DatastoreContext;
import org.opendaylight.controller.cluster.datastore.jmx.mbeans.DatastoreConfigurationMXBean;
import org.opendaylight.controller.md.sal.common.util.jmx.AbstractMXBean;

final class DatastoreConfigurationMXBeanImpl
extends AbstractMXBean
implements DatastoreConfigurationMXBean {
    public static final String JMX_CATEGORY_CONFIGURATION = "Configuration";
    private DatastoreContext context;

    DatastoreConfigurationMXBeanImpl(String mxBeanType) {
        super("Datastore", mxBeanType, JMX_CATEGORY_CONFIGURATION);
    }

    public void setContext(DatastoreContext context) {
        this.context = context;
    }

    public long getShardTransactionIdleTimeoutInSeconds() {
        return this.context.getShardTransactionIdleTimeout().toSeconds();
    }

    public long getOperationTimeoutInSeconds() {
        return TimeUnit.MILLISECONDS.toSeconds(this.context.getOperationTimeoutInMillis());
    }

    public long getShardHeartbeatIntervalInMillis() {
        return this.context.getShardRaftConfig().getHeartBeatInterval().toMillis();
    }

    public int getShardJournalRecoveryLogBatchSize() {
        return this.context.getShardRaftConfig().getJournalRecoveryLogBatchSize();
    }

    public long getShardIsolatedLeaderCheckIntervalInMillis() {
        return this.context.getShardRaftConfig().getIsolatedCheckIntervalInMillis();
    }

    public long getShardElectionTimeoutFactor() {
        return this.context.getShardRaftConfig().getElectionTimeoutFactor();
    }

    public int getShardSnapshotDataThresholdPercentage() {
        return this.context.getShardRaftConfig().getSnapshotDataThresholdPercentage();
    }

    public int getShardSnapshotDataThreshold() {
        return this.context.getShardRaftConfig().getSnapshotDataThreshold();
    }

    public long getShardSnapshotBatchCount() {
        return this.context.getShardRaftConfig().getSnapshotBatchCount();
    }

    public long getShardTransactionCommitTimeoutInSeconds() {
        return this.context.getShardTransactionCommitTimeoutInSeconds();
    }

    public long getShardCommitQueueExpiryTimeoutInSeconds() {
        return TimeUnit.SECONDS.convert(this.context.getShardCommitQueueExpiryTimeoutInMillis(), TimeUnit.MILLISECONDS);
    }

    public int getShardTransactionCommitQueueCapacity() {
        return this.context.getShardTransactionCommitQueueCapacity();
    }

    public long getShardInitializationTimeoutInSeconds() {
        return this.context.getShardInitializationTimeout().duration().toSeconds();
    }

    public long getShardLeaderElectionTimeoutInSeconds() {
        return this.context.getShardLeaderElectionTimeout().duration().toSeconds();
    }

    public boolean isPersistent() {
        return this.context.isPersistent();
    }

    public long getTransactionCreationInitialRateLimit() {
        return this.context.getTransactionCreationInitialRateLimit();
    }

    public boolean getTransactionContextDebugEnabled() {
        return this.context.isTransactionDebugContextEnabled();
    }

    public int getMaximumMessageSliceSize() {
        return this.context.getMaximumMessageSliceSize();
    }
}

