/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore;

import com.google.common.primitives.UnsignedLong;
import com.google.common.util.concurrent.FutureCallback;
import java.lang.runtime.SwitchBootstraps;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.controller.cluster.access.commands.AbortLocalTransactionRequest;
import org.opendaylight.controller.cluster.access.commands.CommitLocalTransactionRequest;
import org.opendaylight.controller.cluster.access.commands.ExistsTransactionRequest;
import org.opendaylight.controller.cluster.access.commands.ExistsTransactionSuccess;
import org.opendaylight.controller.cluster.access.commands.ModifyTransactionRequest;
import org.opendaylight.controller.cluster.access.commands.ModifyTransactionSuccess;
import org.opendaylight.controller.cluster.access.commands.PersistenceProtocol;
import org.opendaylight.controller.cluster.access.commands.ReadTransactionRequest;
import org.opendaylight.controller.cluster.access.commands.ReadTransactionSuccess;
import org.opendaylight.controller.cluster.access.commands.TransactionAbortRequest;
import org.opendaylight.controller.cluster.access.commands.TransactionAbortSuccess;
import org.opendaylight.controller.cluster.access.commands.TransactionCanCommitSuccess;
import org.opendaylight.controller.cluster.access.commands.TransactionCommitSuccess;
import org.opendaylight.controller.cluster.access.commands.TransactionDelete;
import org.opendaylight.controller.cluster.access.commands.TransactionDoCommitRequest;
import org.opendaylight.controller.cluster.access.commands.TransactionMerge;
import org.opendaylight.controller.cluster.access.commands.TransactionModification;
import org.opendaylight.controller.cluster.access.commands.TransactionPreCommitRequest;
import org.opendaylight.controller.cluster.access.commands.TransactionPreCommitSuccess;
import org.opendaylight.controller.cluster.access.commands.TransactionRequest;
import org.opendaylight.controller.cluster.access.commands.TransactionSuccess;
import org.opendaylight.controller.cluster.access.commands.TransactionWrite;
import org.opendaylight.controller.cluster.access.concepts.Request;
import org.opendaylight.controller.cluster.access.concepts.RequestEnvelope;
import org.opendaylight.controller.cluster.access.concepts.RequestException;
import org.opendaylight.controller.cluster.access.concepts.RuntimeRequestException;
import org.opendaylight.controller.cluster.access.concepts.TransactionIdentifier;
import org.opendaylight.controller.cluster.access.concepts.UnsupportedRequestException;
import org.opendaylight.controller.cluster.datastore.AbstractFrontendHistory;
import org.opendaylight.controller.cluster.datastore.FrontendTransaction;
import org.opendaylight.controller.cluster.datastore.ReadWriteShardDataTreeTransaction;
import org.opendaylight.controller.cluster.datastore.ShardDataTreeCohort;
import org.opendaylight.yangtools.yang.common.Empty;
import org.opendaylight.yangtools.yang.data.tree.api.DataTreeCandidate;
import org.opendaylight.yangtools.yang.data.tree.api.DataTreeModification;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class FrontendReadWriteTransaction
extends FrontendTransaction {
    private static final Logger LOG = LoggerFactory.getLogger(FrontendReadWriteTransaction.class);
    private static final State ABORTED = new State(){

        @Override
        public String toString() {
            return "ABORTED";
        }
    };
    private static final State ABORTING = new State(){

        @Override
        public String toString() {
            return "ABORTING";
        }
    };
    private static final State COMMITTED = new State(){

        @Override
        public String toString() {
            return "COMMITTED";
        }
    };
    private State state;

    private FrontendReadWriteTransaction(AbstractFrontendHistory history, TransactionIdentifier id, ReadWriteShardDataTreeTransaction transaction) {
        super(history, id);
        this.state = new Open(transaction);
    }

    private FrontendReadWriteTransaction(AbstractFrontendHistory history, TransactionIdentifier id, DataTreeModification mod) {
        super(history, id);
        this.state = new Sealed(mod);
    }

    static FrontendReadWriteTransaction createOpen(AbstractFrontendHistory history, ReadWriteShardDataTreeTransaction transaction) {
        return new FrontendReadWriteTransaction(history, transaction.getIdentifier(), transaction);
    }

    static FrontendReadWriteTransaction createReady(AbstractFrontendHistory history, TransactionIdentifier id, DataTreeModification mod) {
        return new FrontendReadWriteTransaction(history, id, mod);
    }

    @Override
    TransactionSuccess<?> doHandleRequest(TransactionRequest<?> request, RequestEnvelope envelope, long now) throws RequestException {
        TransactionRequest<?> transactionRequest = request;
        Objects.requireNonNull(transactionRequest);
        TransactionRequest<?> transactionRequest2 = transactionRequest;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ModifyTransactionRequest.class, CommitLocalTransactionRequest.class, ExistsTransactionRequest.class, ReadTransactionRequest.class, TransactionPreCommitRequest.class, TransactionDoCommitRequest.class, TransactionAbortRequest.class, AbortLocalTransactionRequest.class}, transactionRequest2, n)) {
            case 0 -> {
                ModifyTransactionRequest req = (ModifyTransactionRequest)transactionRequest2;
                yield this.handleModifyTransaction(req, envelope, now);
            }
            case 1 -> {
                CommitLocalTransactionRequest req = (CommitLocalTransactionRequest)transactionRequest2;
                yield this.handleCommitLocalTransaction(req, envelope, now);
            }
            case 2 -> {
                ExistsTransactionRequest req = (ExistsTransactionRequest)transactionRequest2;
                yield this.handleExistsTransaction(req);
            }
            case 3 -> {
                ReadTransactionRequest req = (ReadTransactionRequest)transactionRequest2;
                yield this.handleReadTransaction(req);
            }
            case 4 -> {
                TransactionPreCommitRequest req = (TransactionPreCommitRequest)transactionRequest2;
                yield this.handleTransactionPreCommit(req, envelope, now);
            }
            case 5 -> {
                TransactionDoCommitRequest req = (TransactionDoCommitRequest)transactionRequest2;
                yield this.handleTransactionDoCommit(req, envelope, now);
            }
            case 6 -> {
                TransactionAbortRequest req = (TransactionAbortRequest)transactionRequest2;
                yield this.handleTransactionAbort(req.getSequence(), envelope, now);
            }
            case 7 -> {
                AbortLocalTransactionRequest req = (AbortLocalTransactionRequest)transactionRequest2;
                yield this.handleLocalTransactionAbort(req.getSequence(), envelope, now);
            }
            default -> {
                LOG.warn("Rejecting unsupported request {}", request);
                throw new UnsupportedRequestException(request);
            }
        };
    }

    @Override
    void retire() {
        this.state = new Retired(this.state);
    }

    private TransactionSuccess<?> handleTransactionPreCommit(TransactionPreCommitRequest request, final RequestEnvelope envelope, final long now) throws RequestException {
        this.throwIfFailed();
        Ready ready = this.checkReady();
        CommitStage commitStage = ready.stage;
        int n = 0;
        switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"PRE_COMMIT_PENDING", "CAN_COMMIT_COMPLETE", "CAN_COMMIT_PENDING", "COMMIT_PENDING", "PRE_COMMIT_COMPLETE", "READY"}, (CommitStage)commitStage, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case -1: {
                throw new NullPointerException();
            }
            case 0: {
                LOG.debug("{}: Transaction {} is already preCommitting", (Object)this.persistenceId(), (Object)this.getIdentifier());
                break;
            }
            case 1: {
                ready.stage = CommitStage.PRE_COMMIT_PENDING;
                LOG.debug("{}: Transaction {} initiating preCommit", (Object)this.persistenceId(), (Object)this.getIdentifier());
                ready.readyCohort.preCommit(new FutureCallback<DataTreeCandidate>(){

                    public void onSuccess(DataTreeCandidate result) {
                        FrontendReadWriteTransaction.this.successfulPreCommit(envelope, now);
                    }

                    public void onFailure(Throwable failure) {
                        FrontendReadWriteTransaction.this.failTransaction(envelope, now, new RuntimeRequestException("Precommit failed", failure));
                    }
                });
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                throw new IllegalStateException("Attempted to preCommit in stage " + String.valueOf((Object)ready.stage));
            }
        }
        return null;
    }

    void successfulPreCommit(RequestEnvelope envelope, long startTime) {
        if (this.state instanceof Retired) {
            LOG.debug("{}: Suppressing successful preCommit of retired transaction {}", (Object)this.persistenceId(), (Object)this.getIdentifier());
            return;
        }
        Ready ready = this.checkReady();
        LOG.debug("{}: Transaction {} completed preCommit", (Object)this.persistenceId(), (Object)this.getIdentifier());
        this.recordAndSendSuccess(envelope, startTime, (TransactionSuccess<?>)new TransactionPreCommitSuccess(this.getIdentifier(), ((Request)envelope.getMessage()).getSequence()));
        ready.stage = CommitStage.PRE_COMMIT_COMPLETE;
    }

    void failTransaction(RequestEnvelope envelope, long now, RuntimeRequestException cause) {
        if (this.state instanceof Retired) {
            LOG.debug("{}: Suppressing failure of retired transaction {}", new Object[]{this.persistenceId(), this.getIdentifier(), cause});
            return;
        }
        this.recordAndSendFailure(envelope, now, cause);
        this.state = new Failed((RequestException)cause);
        LOG.debug("{}: Transaction {} failed", new Object[]{this.persistenceId(), this.getIdentifier(), cause});
    }

    private TransactionSuccess<?> handleTransactionDoCommit(TransactionDoCommitRequest request, final RequestEnvelope envelope, final long now) throws RequestException {
        this.throwIfFailed();
        Ready ready = this.checkReady();
        CommitStage commitStage = ready.stage;
        int n = 0;
        switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"COMMIT_PENDING", "PRE_COMMIT_COMPLETE", "CAN_COMMIT_COMPLETE", "CAN_COMMIT_PENDING", "PRE_COMMIT_PENDING", "READY"}, (CommitStage)commitStage, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case -1: {
                throw new NullPointerException();
            }
            case 0: {
                LOG.debug("{}: Transaction {} is already committing", (Object)this.persistenceId(), (Object)this.getIdentifier());
                break;
            }
            case 1: {
                ready.stage = CommitStage.COMMIT_PENDING;
                LOG.debug("{}: Transaction {} initiating commit", (Object)this.persistenceId(), (Object)this.getIdentifier());
                ready.readyCohort.commit(new FutureCallback<UnsignedLong>(){

                    public void onSuccess(UnsignedLong result) {
                        FrontendReadWriteTransaction.this.successfulCommit(envelope, now);
                    }

                    public void onFailure(Throwable failure) {
                        FrontendReadWriteTransaction.this.failTransaction(envelope, now, new RuntimeRequestException("Commit failed", failure));
                    }
                });
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                throw new IllegalStateException("Attempted to doCommit in stage " + String.valueOf((Object)ready.stage));
            }
        }
        return null;
    }

    private TransactionSuccess<?> handleLocalTransactionAbort(long sequence, RequestEnvelope envelope, long now) {
        this.checkOpen().abort(() -> this.recordAndSendSuccess(envelope, now, (TransactionSuccess<?>)new TransactionAbortSuccess(this.getIdentifier(), sequence)));
        return null;
    }

    private void startAbort() {
        this.state = ABORTING;
        LOG.debug("{}: Transaction {} aborting", (Object)this.persistenceId(), (Object)this.getIdentifier());
    }

    private void finishAbort() {
        this.state = ABORTED;
        LOG.debug("{}: Transaction {} aborted", (Object)this.persistenceId(), (Object)this.getIdentifier());
    }

    private TransactionAbortSuccess handleTransactionAbort(final long sequence, final RequestEnvelope envelope, final long now) {
        if (this.state instanceof Open) {
            ReadWriteShardDataTreeTransaction openTransaction = this.checkOpen();
            this.startAbort();
            openTransaction.abort(() -> {
                this.recordAndSendSuccess(envelope, now, (TransactionSuccess<?>)new TransactionAbortSuccess(this.getIdentifier(), sequence));
                this.finishAbort();
            });
            return null;
        }
        if (ABORTING.equals(this.state)) {
            LOG.debug("{}: Transaction {} already aborting", (Object)this.persistenceId(), (Object)this.getIdentifier());
            return null;
        }
        if (ABORTED.equals(this.state)) {
            LOG.warn("{}: Transaction {} already aborted", (Object)this.persistenceId(), (Object)this.getIdentifier());
            return new TransactionAbortSuccess(this.getIdentifier(), sequence);
        }
        Ready ready = this.checkReady();
        this.startAbort();
        ready.readyCohort.abort(new FutureCallback<Empty>(){

            public void onSuccess(Empty result) {
                FrontendReadWriteTransaction.this.recordAndSendSuccess(envelope, now, (TransactionSuccess<?>)new TransactionAbortSuccess(FrontendReadWriteTransaction.this.getIdentifier(), sequence));
                FrontendReadWriteTransaction.this.finishAbort();
            }

            public void onFailure(Throwable failure) {
                FrontendReadWriteTransaction.this.recordAndSendFailure(envelope, now, new RuntimeRequestException("Abort failed", failure));
                LOG.warn("{}: Transaction {} abort failed", new Object[]{FrontendReadWriteTransaction.this.persistenceId(), FrontendReadWriteTransaction.this.getIdentifier(), failure});
                FrontendReadWriteTransaction.this.finishAbort();
            }
        });
        return null;
    }

    private void coordinatedCommit(final RequestEnvelope envelope, final long now) throws RequestException {
        this.throwIfFailed();
        Ready ready = this.checkReady();
        CommitStage commitStage = ready.stage;
        int n = 0;
        switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"CAN_COMMIT_PENDING", "READY", "CAN_COMMIT_COMPLETE", "COMMIT_PENDING", "PRE_COMMIT_COMPLETE", "PRE_COMMIT_PENDING"}, (CommitStage)commitStage, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case -1: {
                throw new NullPointerException();
            }
            case 0: {
                LOG.debug("{}: Transaction {} is already canCommitting", (Object)this.persistenceId(), (Object)this.getIdentifier());
                break;
            }
            case 1: {
                ready.stage = CommitStage.CAN_COMMIT_PENDING;
                LOG.debug("{}: Transaction {} initiating canCommit", (Object)this.persistenceId(), (Object)this.getIdentifier());
                this.checkReady().readyCohort.canCommit(new FutureCallback<Empty>(){

                    public void onSuccess(Empty result) {
                        FrontendReadWriteTransaction.this.successfulCanCommit(envelope, now);
                    }

                    public void onFailure(Throwable failure) {
                        FrontendReadWriteTransaction.this.failTransaction(envelope, now, new RuntimeRequestException("CanCommit failed", failure));
                    }
                });
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                throw new IllegalStateException("Attempted to canCommit in stage " + String.valueOf((Object)ready.stage));
            }
        }
    }

    void successfulCanCommit(RequestEnvelope envelope, long startTime) {
        if (this.state instanceof Retired) {
            LOG.debug("{}: Suppressing successful canCommit of retired transaction {}", (Object)this.persistenceId(), (Object)this.getIdentifier());
            return;
        }
        Ready ready = this.checkReady();
        this.recordAndSendSuccess(envelope, startTime, (TransactionSuccess<?>)new TransactionCanCommitSuccess(this.getIdentifier(), ((Request)envelope.getMessage()).getSequence()));
        ready.stage = CommitStage.CAN_COMMIT_COMPLETE;
        LOG.debug("{}: Transaction {} completed canCommit", (Object)this.persistenceId(), (Object)this.getIdentifier());
    }

    private void directCommit(final RequestEnvelope envelope, final long now) throws RequestException {
        this.throwIfFailed();
        Ready ready = this.checkReady();
        CommitStage commitStage = ready.stage;
        int n = 0;
        switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"CAN_COMMIT_COMPLETE", "CAN_COMMIT_PENDING", "COMMIT_PENDING", "PRE_COMMIT_COMPLETE", "PRE_COMMIT_PENDING", "READY"}, (CommitStage)commitStage, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case -1: {
                throw new NullPointerException();
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                LOG.debug("{}: Transaction {} in state {}, not initiating direct commit for {}", new Object[]{this.persistenceId(), this.getIdentifier(), this.state, envelope});
                break;
            }
            case 5: {
                ready.stage = CommitStage.CAN_COMMIT_PENDING;
                LOG.debug("{}: Transaction {} initiating direct canCommit", (Object)this.persistenceId(), (Object)this.getIdentifier());
                ready.readyCohort.canCommit(new FutureCallback<Empty>(){

                    public void onSuccess(Empty result) {
                        FrontendReadWriteTransaction.this.successfulDirectCanCommit(envelope, now);
                    }

                    public void onFailure(Throwable failure) {
                        FrontendReadWriteTransaction.this.failTransaction(envelope, now, new RuntimeRequestException("CanCommit failed", failure));
                    }
                });
            }
        }
    }

    void successfulDirectCanCommit(final RequestEnvelope envelope, final long startTime) {
        if (this.state instanceof Retired) {
            LOG.debug("{}: Suppressing direct canCommit of retired transaction {}", (Object)this.persistenceId(), (Object)this.getIdentifier());
            return;
        }
        Ready ready = this.checkReady();
        ready.stage = CommitStage.PRE_COMMIT_PENDING;
        LOG.debug("{}: Transaction {} initiating direct preCommit", (Object)this.persistenceId(), (Object)this.getIdentifier());
        ready.readyCohort.preCommit(new FutureCallback<DataTreeCandidate>(){

            public void onSuccess(DataTreeCandidate result) {
                FrontendReadWriteTransaction.this.successfulDirectPreCommit(envelope, startTime);
            }

            public void onFailure(Throwable failure) {
                FrontendReadWriteTransaction.this.failTransaction(envelope, startTime, new RuntimeRequestException("PreCommit failed", failure));
            }
        });
    }

    void successfulDirectPreCommit(final RequestEnvelope envelope, final long startTime) {
        if (this.state instanceof Retired) {
            LOG.debug("{}: Suppressing direct commit of retired transaction {}", (Object)this.persistenceId(), (Object)this.getIdentifier());
            return;
        }
        Ready ready = this.checkReady();
        ready.stage = CommitStage.COMMIT_PENDING;
        LOG.debug("{}: Transaction {} initiating direct commit", (Object)this.persistenceId(), (Object)this.getIdentifier());
        ready.readyCohort.commit(new FutureCallback<UnsignedLong>(){

            public void onSuccess(UnsignedLong result) {
                FrontendReadWriteTransaction.this.successfulCommit(envelope, startTime);
            }

            public void onFailure(Throwable failure) {
                FrontendReadWriteTransaction.this.failTransaction(envelope, startTime, new RuntimeRequestException("DoCommit failed", failure));
            }
        });
    }

    void successfulCommit(RequestEnvelope envelope, long startTime) {
        if (this.state instanceof Retired) {
            LOG.debug("{}: Suppressing commit response on retired transaction {}", (Object)this.persistenceId(), (Object)this.getIdentifier());
            return;
        }
        this.recordAndSendSuccess(envelope, startTime, (TransactionSuccess<?>)new TransactionCommitSuccess(this.getIdentifier(), ((Request)envelope.getMessage()).getSequence()));
        this.state = COMMITTED;
    }

    private TransactionSuccess<?> handleCommitLocalTransaction(CommitLocalTransactionRequest request, RequestEnvelope envelope, long now) throws RequestException {
        DataTreeModification sealedModification = this.checkSealed();
        if (!sealedModification.equals((Object)request.getModification())) {
            LOG.warn("Expecting modification {}, commit request has {}", (Object)sealedModification, (Object)request.getModification());
            throw new UnsupportedRequestException((Request)request);
        }
        Optional optFailure = request.getDelayedFailure();
        this.state = optFailure.isPresent() ? new Ready(this.history().createFailedCohort(this.getIdentifier(), sealedModification, (Exception)optFailure.orElseThrow())) : new Ready(this.history().createReadyCohort(this.getIdentifier(), sealedModification, Optional.empty()));
        if (request.isCoordinated()) {
            this.coordinatedCommit(envelope, now);
        } else {
            this.directCommit(envelope, now);
        }
        return null;
    }

    private ExistsTransactionSuccess handleExistsTransaction(ExistsTransactionRequest request) {
        Optional data = ((DataTreeModification)this.checkOpen().getSnapshot()).readNode(request.getPath());
        return this.recordSuccess(request.getSequence(), new ExistsTransactionSuccess(this.getIdentifier(), request.getSequence(), data.isPresent()));
    }

    private ReadTransactionSuccess handleReadTransaction(ReadTransactionRequest request) {
        Optional data = ((DataTreeModification)this.checkOpen().getSnapshot()).readNode(request.getPath());
        return this.recordSuccess(request.getSequence(), new ReadTransactionSuccess(this.getIdentifier(), request.getSequence(), data));
    }

    private ModifyTransactionSuccess replyModifySuccess(long sequence) {
        return this.recordSuccess(sequence, new ModifyTransactionSuccess(this.getIdentifier(), sequence));
    }

    private void applyModifications(Collection<TransactionModification> modifications) {
        if (!modifications.isEmpty()) {
            DataTreeModification modification = (DataTreeModification)this.checkOpen().getSnapshot();
            block5: for (TransactionModification mod : modifications) {
                TransactionModification transactionModification;
                Objects.requireNonNull(mod);
                int n = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{TransactionDelete.class, TransactionMerge.class, TransactionWrite.class}, (Object)transactionModification, n)) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case 0: {
                        TransactionDelete delete = (TransactionDelete)transactionModification;
                        modification.delete(delete.getPath());
                        continue block5;
                    }
                    case 1: {
                        TransactionMerge merge = (TransactionMerge)transactionModification;
                        modification.merge(merge.getPath(), merge.getData());
                        continue block5;
                    }
                    case 2: 
                }
                TransactionWrite write = (TransactionWrite)transactionModification;
                modification.write(write.getPath(), write.getData());
            }
        }
    }

    private @Nullable TransactionSuccess<?> handleModifyTransaction(ModifyTransactionRequest request, RequestEnvelope envelope, long now) throws RequestException {
        Optional maybeProto = request.getPersistenceProtocol();
        if (maybeProto.isEmpty()) {
            this.applyModifications(request.getModifications());
            return this.replyModifySuccess(request.getSequence());
        }
        return switch ((PersistenceProtocol)maybeProto.orElseThrow()) {
            default -> throw new MatchException(null, null);
            case PersistenceProtocol.ABORT -> {
                if (ABORTING.equals(this.state)) {
                    LOG.debug("{}: Transaction {} already aborting", (Object)this.persistenceId(), (Object)this.getIdentifier());
                    yield null;
                }
                ReadWriteShardDataTreeTransaction openTransaction = this.checkOpen();
                this.startAbort();
                openTransaction.abort(() -> {
                    this.recordAndSendSuccess(envelope, now, (TransactionSuccess<?>)new ModifyTransactionSuccess(this.getIdentifier(), request.getSequence()));
                    this.finishAbort();
                });
                yield null;
            }
            case PersistenceProtocol.READY -> {
                this.ensureReady(request.getModifications());
                yield this.replyModifySuccess(request.getSequence());
            }
            case PersistenceProtocol.SIMPLE -> {
                this.ensureReady(request.getModifications());
                this.directCommit(envelope, now);
                yield null;
            }
            case PersistenceProtocol.THREE_PHASE -> {
                this.ensureReady(request.getModifications());
                this.coordinatedCommit(envelope, now);
                yield null;
            }
        };
    }

    private void ensureReady(Collection<TransactionModification> modifications) {
        if (this.state instanceof Ready) {
            LOG.debug("{}: {} is already in state {}", new Object[]{this.persistenceId(), this.getIdentifier(), this.state});
            return;
        }
        this.applyModifications(modifications);
        this.state = new Ready(this.checkOpen().ready(Optional.empty()));
        LOG.debug("{}: transitioned {} to ready", (Object)this.persistenceId(), (Object)this.getIdentifier());
    }

    private void throwIfFailed() throws RequestException {
        State state = this.state;
        if (state instanceof Failed) {
            Failed failed = (Failed)state;
            LOG.debug("{}: {} has failed, rejecting request", (Object)this.persistenceId(), (Object)this.getIdentifier());
            throw failed.cause;
        }
    }

    private ReadWriteShardDataTreeTransaction checkOpen() {
        State state = this.state;
        if (state instanceof Open) {
            Open open = (Open)state;
            return open.openTransaction;
        }
        throw new IllegalStateException(String.valueOf(this.getIdentifier()) + " expect to be open, is in state " + String.valueOf(this.state));
    }

    private Ready checkReady() {
        State state = this.state;
        if (state instanceof Ready) {
            Ready ready = (Ready)state;
            return ready;
        }
        throw new IllegalStateException(String.valueOf(this.getIdentifier()) + " expect to be ready, is in state " + String.valueOf(this.state));
    }

    private DataTreeModification checkSealed() {
        State state = this.state;
        if (state instanceof Sealed) {
            Sealed sealed = (Sealed)state;
            return sealed.sealedModification;
        }
        throw new IllegalStateException(String.valueOf(this.getIdentifier()) + " expect to be sealed, is in state " + String.valueOf(this.state));
    }

    private static final class Open
    extends State {
        final ReadWriteShardDataTreeTransaction openTransaction;

        Open(ReadWriteShardDataTreeTransaction openTransaction) {
            this.openTransaction = Objects.requireNonNull(openTransaction);
        }

        @Override
        public String toString() {
            return "OPEN";
        }
    }

    private static abstract class State {
        private State() {
        }

        public abstract String toString();
    }

    private static final class Sealed
    extends State {
        final DataTreeModification sealedModification;

        Sealed(DataTreeModification sealedModification) {
            this.sealedModification = Objects.requireNonNull(sealedModification);
        }

        @Override
        public String toString() {
            return "SEALED";
        }
    }

    private static final class Retired
    extends State {
        private final String prevStateString;

        Retired(State prevState) {
            this.prevStateString = prevState.toString();
        }

        @Override
        public String toString() {
            return "RETIRED (in " + this.prevStateString + ")";
        }
    }

    private static final class Ready
    extends State {
        final ShardDataTreeCohort readyCohort;
        CommitStage stage;

        Ready(ShardDataTreeCohort readyCohort) {
            this.readyCohort = Objects.requireNonNull(readyCohort);
            this.stage = CommitStage.READY;
        }

        @Override
        public String toString() {
            return "READY (" + String.valueOf((Object)this.stage) + ")";
        }
    }

    private static enum CommitStage {
        READY,
        CAN_COMMIT_PENDING,
        CAN_COMMIT_COMPLETE,
        PRE_COMMIT_PENDING,
        PRE_COMMIT_COMPLETE,
        COMMIT_PENDING;

    }

    private static final class Failed
    extends State {
        final RequestException cause;

        Failed(RequestException cause) {
            this.cause = Objects.requireNonNull(cause);
        }

        @Override
        public String toString() {
            return "FAILED (" + this.cause.getMessage() + ")";
        }
    }
}

