/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore.messages;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.FluentFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.util.Optional;
import org.opendaylight.controller.cluster.datastore.messages.AbstractRead;
import org.opendaylight.controller.cluster.datastore.messages.ReadDataReply;
import org.opendaylight.mdsal.common.api.ReadFailedException;
import org.opendaylight.mdsal.dom.spi.store.DOMStoreReadTransaction;
import org.opendaylight.yangtools.yang.common.RpcError;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;

@Deprecated(since="9.0.0", forRemoval=true)
public class ReadData
extends AbstractRead<Optional<NormalizedNode>> {
    private static final long serialVersionUID = 1L;

    public ReadData() {
    }

    public ReadData(YangInstanceIdentifier path, short version) {
        super(path, version);
    }

    @Override
    public FluentFuture<Optional<NormalizedNode>> apply(DOMStoreReadTransaction readDelegate) {
        return readDelegate.read(this.getPath());
    }

    @Override
    public void processResponse(Object readResponse, SettableFuture<Optional<NormalizedNode>> returnFuture) {
        if (ReadDataReply.isSerializedType(readResponse)) {
            ReadDataReply reply = ReadDataReply.fromSerializable(readResponse);
            returnFuture.set(Optional.ofNullable(reply.getNormalizedNode()));
        } else {
            returnFuture.setException((Throwable)new ReadFailedException("Invalid response reading data for path " + String.valueOf(this.getPath()), new RpcError[0]));
        }
    }

    @Override
    protected AbstractRead<Optional<NormalizedNode>> newInstance(short withVersion) {
        return new ReadData(this.getPath(), withVersion);
    }

    public static ReadData fromSerializable(Object serializable) {
        Preconditions.checkArgument((boolean)(serializable instanceof ReadData));
        return (ReadData)serializable;
    }

    public static boolean isSerializedType(Object message) {
        return message instanceof ReadData;
    }
}

