/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore.persisted;

import com.google.common.base.Verify;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.opendaylight.controller.cluster.datastore.persisted.DatastoreSnapshot;
import org.opendaylight.controller.cluster.datastore.persisted.ShardManagerSnapshot;

final class DS
implements Externalizable {
    private static final long serialVersionUID = 1L;
    private DatastoreSnapshot datastoreSnapshot;

    public DS() {
    }

    DS(DatastoreSnapshot datastoreSnapshot) {
        this.datastoreSnapshot = Objects.requireNonNull(datastoreSnapshot);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        String type = (String)in.readObject();
        ShardManagerSnapshot snapshot = (ShardManagerSnapshot)in.readObject();
        int size = in.readInt();
        ArrayList<DatastoreSnapshot.ShardSnapshot> localShardSnapshots = new ArrayList<DatastoreSnapshot.ShardSnapshot>(size);
        for (int i = 0; i < size; ++i) {
            localShardSnapshots.add((DatastoreSnapshot.ShardSnapshot)in.readObject());
        }
        this.datastoreSnapshot = new DatastoreSnapshot(type, snapshot, localShardSnapshots);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.datastoreSnapshot.getType());
        out.writeObject(this.datastoreSnapshot.getShardManagerSnapshot());
        List<DatastoreSnapshot.ShardSnapshot> shardSnapshots = this.datastoreSnapshot.getShardSnapshots();
        out.writeInt(shardSnapshots.size());
        for (DatastoreSnapshot.ShardSnapshot shardSnapshot : shardSnapshots) {
            out.writeObject(shardSnapshot);
        }
    }

    private Object readResolve() {
        return Verify.verifyNotNull((Object)this.datastoreSnapshot);
    }
}

