/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore.utils;

import com.google.common.annotations.Beta;
import com.google.common.collect.ImmutableSortedSet;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.NavigableSet;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.controller.cluster.datastore.utils.MutableUnsignedLongSet;
import org.opendaylight.controller.cluster.datastore.utils.UnsignedLongSet;
import org.opendaylight.yangtools.concepts.Immutable;
import org.opendaylight.yangtools.concepts.WritableObject;

@Beta
public final class ImmutableUnsignedLongSet
extends UnsignedLongSet
implements Immutable,
WritableObject {
    private static final int ARRAY_MAX_ELEMENTS = 4096;
    private static final @NonNull ImmutableUnsignedLongSet EMPTY = new ImmutableUnsignedLongSet((NavigableSet<UnsignedLongSet.Entry>)ImmutableSortedSet.of());

    private ImmutableUnsignedLongSet(NavigableSet<UnsignedLongSet.Entry> ranges) {
        super(ranges);
    }

    static @NonNull ImmutableUnsignedLongSet copyOf(MutableUnsignedLongSet mutable) {
        if (mutable.isEmpty()) {
            return ImmutableUnsignedLongSet.of();
        }
        if (mutable.rangeSize() <= 4096) {
            return new ImmutableUnsignedLongSet((NavigableSet<UnsignedLongSet.Entry>)ImmutableSortedSet.copyOfSorted(mutable.trustedRanges()));
        }
        return new ImmutableUnsignedLongSet(new TreeSet<UnsignedLongSet.Entry>((SortedSet<UnsignedLongSet.Entry>)mutable.trustedRanges()));
    }

    public static @NonNull ImmutableUnsignedLongSet of() {
        return EMPTY;
    }

    @Override
    public ImmutableUnsignedLongSet immutableCopy() {
        return this;
    }

    public static @NonNull ImmutableUnsignedLongSet readFrom(DataInput in) throws IOException {
        return ImmutableUnsignedLongSet.readFrom(in, in.readInt());
    }

    public static @NonNull ImmutableUnsignedLongSet readFrom(DataInput in, int size) throws IOException {
        ImmutableSortedSet ranges;
        if (size == 0) {
            return EMPTY;
        }
        if (size <= 4096) {
            ArrayList<UnsignedLongSet.Entry> entries = new ArrayList<UnsignedLongSet.Entry>(size);
            for (int i = 0; i < size; ++i) {
                entries.add(UnsignedLongSet.Entry.readUnsigned(in));
            }
            ranges = ImmutableSortedSet.copyOf(entries);
        } else {
            ranges = new TreeSet();
            for (int i = 0; i < size; ++i) {
                ranges.add(UnsignedLongSet.Entry.readUnsigned(in));
            }
        }
        return new ImmutableUnsignedLongSet((NavigableSet<UnsignedLongSet.Entry>)ranges);
    }

    public void writeTo(DataOutput out) throws IOException {
        out.writeInt(this.rangeSize());
        this.writeRanges(out);
    }

    public void writeRangesTo(@NonNull DataOutput out, int size) throws IOException {
        int rangeSize = this.rangeSize();
        if (size != rangeSize) {
            throw new IOException("Mismatched size: expected " + rangeSize + ", got " + size);
        }
        this.writeRanges(out);
    }

    private void writeRanges(@NonNull DataOutput out) throws IOException {
        for (UnsignedLongSet.Entry range : this.trustedRanges()) {
            range.writeUnsigned(out);
        }
    }
}

