/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore.utils;

import com.google.common.annotations.Beta;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collections;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.controller.cluster.datastore.utils.ImmutableUnsignedLongSet;
import org.opendaylight.controller.cluster.datastore.utils.MutableUnsignedLongSet;
import org.opendaylight.yangtools.concepts.Immutable;
import org.opendaylight.yangtools.concepts.WritableObjects;

abstract class UnsignedLongSet {
    private final @NonNull NavigableSet<Entry> ranges;

    UnsignedLongSet(NavigableSet<Entry> ranges) {
        this.ranges = Objects.requireNonNull(ranges);
    }

    public final boolean contains(long longBits) {
        Entry head = this.ranges.floor(Entry.of(longBits));
        return head != null && Long.compareUnsigned(head.lowerBits, longBits) <= 0 && Long.compareUnsigned(head.upperBits, longBits) >= 0;
    }

    public final boolean isEmpty() {
        return this.ranges.isEmpty();
    }

    public final int rangeSize() {
        return this.ranges.size();
    }

    public abstract @NonNull ImmutableUnsignedLongSet immutableCopy();

    public final @NonNull MutableUnsignedLongSet mutableCopy() {
        return new MutableUnsignedLongSet(new TreeSet<Entry>((SortedSet<Entry>)this.ranges));
    }

    public final @NonNull NavigableSet<Entry> ranges() {
        return Collections.unmodifiableNavigableSet(this.ranges);
    }

    final @NonNull NavigableSet<Entry> trustedRanges() {
        return this.ranges;
    }

    public final int hashCode() {
        return this.ranges.hashCode();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean equals(Object obj) {
        if (obj == this) return true;
        if (!(obj instanceof UnsignedLongSet)) return false;
        UnsignedLongSet other = (UnsignedLongSet)obj;
        if (!this.ranges.equals(other.ranges)) return false;
        return true;
    }

    public final String toString() {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((Object)this);
        int size = this.ranges.size();
        switch (size) {
            case 0: {
                break;
            }
            case 1: {
                helper.add("span", this.ranges.first());
                break;
            }
            default: {
                helper.add("span", (Object)Entry.of(((Entry)this.ranges.first()).lowerBits, ((Entry)this.ranges.last()).upperBits));
            }
        }
        return helper.add("size", size).toString();
    }

    @Beta
    @VisibleForTesting
    public static final class Entry
    implements Comparable<Entry>,
    Immutable {
        public final long lowerBits;
        public final long upperBits;

        private Entry(long lowerBits, long upperBits) {
            this.lowerBits = lowerBits;
            this.upperBits = upperBits;
        }

        static @NonNull Entry of(long longBits) {
            return Entry.of(longBits, longBits);
        }

        static @NonNull Entry of(long lowerBits, long upperBits) {
            return new Entry(lowerBits, upperBits);
        }

        @NonNull Entry withLower(long newLowerBits) {
            return Entry.of(newLowerBits, this.upperBits);
        }

        @NonNull Entry withUpper(long newUpperBits) {
            return Entry.of(this.lowerBits, newUpperBits);
        }

        static @NonNull Entry readUnsigned(DataInput in) throws IOException {
            long second;
            byte hdr = WritableObjects.readLongHeader((DataInput)in);
            long first = WritableObjects.readFirstLong((DataInput)in, (byte)hdr);
            if (Long.compareUnsigned(first, second = WritableObjects.readSecondLong((DataInput)in, (byte)hdr) - 1L) > 0) {
                throw new IOException("Lower endpoint " + Long.toUnsignedString(first) + " is greater than upper endpoint " + Long.toUnsignedString(second));
            }
            return new Entry(first, second);
        }

        void writeUnsigned(@NonNull DataOutput out) throws IOException {
            WritableObjects.writeLongs((DataOutput)out, (long)this.lowerBits, (long)(this.upperBits + 1L));
        }

        @Override
        public int compareTo(Entry o) {
            return Long.compareUnsigned(this.lowerBits, o.lowerBits);
        }

        public int hashCode() {
            return Long.hashCode(this.lowerBits) * 31 + Long.hashCode(this.upperBits);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object obj) {
            if (obj == this) return true;
            if (!(obj instanceof Entry)) return false;
            Entry other = (Entry)obj;
            if (this.lowerBits != other.lowerBits) return false;
            if (this.upperBits != other.upperBits) return false;
            return true;
        }

        public String toString() {
            return "[" + Long.toUnsignedString(this.lowerBits) + ".." + Long.toUnsignedString(this.upperBits) + "]";
        }
    }
}

