/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.eos.dom.simple;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Multimap;
import com.google.common.collect.Table;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import org.checkerframework.checker.lock.qual.GuardedBy;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.mdsal.eos.common.api.CandidateAlreadyRegisteredException;
import org.opendaylight.mdsal.eos.common.api.EntityOwnershipState;
import org.opendaylight.mdsal.eos.common.api.EntityOwnershipStateChange;
import org.opendaylight.mdsal.eos.common.api.GenericEntity;
import org.opendaylight.mdsal.eos.dom.api.DOMEntity;
import org.opendaylight.mdsal.eos.dom.api.DOMEntityOwnershipListener;
import org.opendaylight.mdsal.eos.dom.api.DOMEntityOwnershipService;
import org.opendaylight.yangtools.concepts.AbstractRegistration;
import org.opendaylight.yangtools.concepts.Registration;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
public final class SimpleDOMEntityOwnershipService
implements DOMEntityOwnershipService {
    private static final Logger LOG = LoggerFactory.getLogger(SimpleDOMEntityOwnershipService.class);
    private final @GuardedBy(value={"entities"}) Table<String, YangInstanceIdentifier, DOMEntity> entities = HashBasedTable.create();
    private final @GuardedBy(value={"listeners"}) Multimap<String, DOMEntityOwnershipListener> listeners = ArrayListMultimap.create((int)0, (int)1);
    private final UUID uuid;

    @Activate
    public SimpleDOMEntityOwnershipService() {
        this(UUID.randomUUID());
    }

    @VisibleForTesting
    SimpleDOMEntityOwnershipService(UUID uuid) {
        this.uuid = Objects.requireNonNull(uuid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Registration registerCandidate(final DOMEntity entity) throws CandidateAlreadyRegisteredException {
        Table<String, YangInstanceIdentifier, DOMEntity> table = this.entities;
        synchronized (table) {
            DOMEntity prev = (DOMEntity)this.entities.get((Object)entity.getType(), (Object)entity.getIdentifier());
            if (prev != null) {
                throw new CandidateAlreadyRegisteredException((GenericEntity)prev);
            }
            this.entities.put((Object)entity.getType(), (Object)((YangInstanceIdentifier)entity.getIdentifier()), (Object)entity);
            LOG.debug("{}: registered candidate {}", (Object)this.uuid, (Object)entity);
        }
        this.notifyListeners(entity, EntityOwnershipStateChange.LOCAL_OWNERSHIP_GRANTED);
        return new AbstractRegistration(){

            protected void removeRegistration() {
                SimpleDOMEntityOwnershipService.this.removeEntity(entity);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Registration registerListener(final String entityType, final DOMEntityOwnershipListener listener) {
        List<DOMEntity> owned;
        Object object = this.entities;
        synchronized (object) {
            owned = List.copyOf(this.entities.row((Object)entityType).values());
            LOG.trace("{}: acquired candidates {} for new listener {}", new Object[]{this.uuid, owned, listener});
        }
        object = this.listeners;
        synchronized (object) {
            this.listeners.put((Object)entityType, (Object)listener);
        }
        for (DOMEntity entity : owned) {
            this.notifyListener(listener, entity, EntityOwnershipStateChange.LOCAL_OWNERSHIP_GRANTED);
        }
        LOG.debug("{}: registered listener {}", (Object)this.uuid, (Object)listener);
        return new AbstractRegistration(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void removeRegistration() {
                Multimap<String, DOMEntityOwnershipListener> multimap = SimpleDOMEntityOwnershipService.this.listeners;
                synchronized (multimap) {
                    SimpleDOMEntityOwnershipService.this.listeners.remove((Object)entityType, (Object)listener);
                    LOG.debug("{}: unregistered listener {}", (Object)SimpleDOMEntityOwnershipService.this.uuid, (Object)listener);
                }
            }
        };
    }

    public Optional<EntityOwnershipState> getOwnershipState(DOMEntity forEntity) {
        return this.isCandidateRegistered(forEntity) ? Optional.of(EntityOwnershipState.IS_OWNER) : Optional.empty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCandidateRegistered(DOMEntity forEntity) {
        Table<String, YangInstanceIdentifier, DOMEntity> table = this.entities;
        synchronized (table) {
            return this.entities.contains((Object)forEntity.getType(), (Object)forEntity.getIdentifier());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeEntity(DOMEntity entity) {
        Table<String, YangInstanceIdentifier, DOMEntity> table = this.entities;
        synchronized (table) {
            this.entities.remove((Object)entity.getType(), (Object)entity.getIdentifier());
            LOG.debug("{}: unregistered candidate {}", (Object)this.uuid, (Object)entity);
        }
        this.notifyListeners(entity, EntityOwnershipStateChange.LOCAL_OWNERSHIP_LOST_NO_OWNER);
    }

    private void notifyListener(DOMEntityOwnershipListener listener, @NonNull DOMEntity entity, @NonNull EntityOwnershipStateChange change) {
        try {
            LOG.trace("{} notifying listener {} change {}", new Object[]{this.uuid, listener, change});
            listener.ownershipChanged(entity, change, false);
        }
        catch (RuntimeException e) {
            LOG.warn("{}: Listener {} failed on {} change {}", new Object[]{this.uuid, listener, entity, change, e});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListeners(DOMEntity entity, EntityOwnershipStateChange state) {
        List<DOMEntityOwnershipListener> snap;
        Multimap<String, DOMEntityOwnershipListener> multimap = this.listeners;
        synchronized (multimap) {
            snap = List.copyOf(this.listeners.get((Object)entity.getType()));
        }
        for (DOMEntityOwnershipListener listener : snap) {
            this.notifyListener(listener, entity, state);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper(SimpleDOMEntityOwnershipService.class).add("uuid", (Object)this.uuid);
        Table<String, YangInstanceIdentifier, DOMEntity> table = this.entities;
        synchronized (table) {
            helper.add("entities", this.entities);
        }
        table = this.listeners;
        synchronized (table) {
            helper.add("listeners", this.listeners);
        }
        return helper.toString();
    }
}

