/*
 * Decompiled with CFR 0.152.
 */
package rpcbenchmark.impl;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicLong;
import org.opendaylight.mdsal.binding.api.RpcService;
import org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702.RoutedRpcBench;
import org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702.RoutedRpcBenchInput;
import org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702.RoutedRpcBenchInputBuilder;
import org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702.RoutedRpcBenchOutput;
import org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702.payload.PayloadBuilder;
import org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702.payload.PayloadKey;
import org.opendaylight.yangtools.binding.DataObjectIdentifier;
import org.opendaylight.yangtools.binding.EntryObject;
import org.opendaylight.yangtools.binding.util.BindingMap;
import org.opendaylight.yangtools.yang.common.RpcResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rpcbenchmark.impl.RTCClient;

public class RoutedBindingRTClient
implements RTCClient {
    private static final Logger LOG = LoggerFactory.getLogger(RoutedBindingRTClient.class);
    private final RoutedRpcBench routedRpcBench;
    private final AtomicLong rpcOk = new AtomicLong(0L);
    private final AtomicLong rpcError = new AtomicLong(0L);
    private final List<RoutedRpcBenchInput> inVal = new ArrayList<RoutedRpcBenchInput>();
    private final int inSize;

    public RoutedBindingRTClient(RpcService rpcService, int inSize, List<DataObjectIdentifier<?>> routeIid) {
        this.routedRpcBench = (RoutedRpcBench)rpcService.getRpc(RoutedRpcBench.class);
        this.inSize = inSize;
        BindingMap.Builder listVals = BindingMap.orderedBuilder((int)inSize);
        for (int i = 0; i < inSize; ++i) {
            listVals.add((EntryObject)new PayloadBuilder().withKey(new PayloadKey(Integer.valueOf(i))).build());
        }
        for (DataObjectIdentifier<?> iid : routeIid) {
            this.inVal.add(new RoutedRpcBenchInputBuilder().setNode(iid).setPayload(listVals.build()).build());
        }
    }

    @Override
    public long getRpcOk() {
        return this.rpcOk.get();
    }

    @Override
    public long getRpcError() {
        return this.rpcError.get();
    }

    @Override
    public void runTest(int iterations) {
        int ok = 0;
        int error = 0;
        int rpcServerCnt = this.inVal.size();
        for (int i = 0; i < iterations; ++i) {
            RpcResult rpcResult;
            RoutedRpcBenchInput input = this.inVal.get(ThreadLocalRandom.current().nextInt(rpcServerCnt));
            ListenableFuture future = this.routedRpcBench.invoke(input);
            try {
                rpcResult = (RpcResult)future.get();
            }
            catch (InterruptedException | ExecutionException e) {
                ++error;
                LOG.error("Execution failed: ", (Throwable)e);
                continue;
            }
            if (!rpcResult.isSuccessful()) continue;
            Map retVal = ((RoutedRpcBenchOutput)rpcResult.getResult()).getPayload();
            if (retVal.size() == this.inSize) {
                ++ok;
                continue;
            }
            ++error;
        }
        this.rpcOk.addAndGet(ok);
        this.rpcError.addAndGet(error);
    }

    @Override
    public void close() {
    }
}

