/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.logbuffer;

import io.aeron.DirectBufferVector;
import io.aeron.ReservedValueSupplier;
import io.aeron.logbuffer.BufferClaim;
import io.aeron.logbuffer.FrameDescriptor;
import io.aeron.logbuffer.HeaderWriter;
import io.aeron.logbuffer.LogBufferDescriptor;
import java.nio.ByteOrder;
import org.agrona.BitUtil;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.UnsafeAccess;
import org.agrona.concurrent.AtomicBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public final class ExclusiveTermAppender {
    public static final int FAILED = -1;
    private final long tailAddressOffset;
    private final UnsafeBuffer termBuffer;

    public ExclusiveTermAppender(UnsafeBuffer termBuffer, UnsafeBuffer metaDataBuffer, int partitionIndex) {
        int tailCounterOffset = LogBufferDescriptor.TERM_TAIL_COUNTERS_OFFSET + partitionIndex * 8;
        metaDataBuffer.boundsCheck(tailCounterOffset, 8);
        this.termBuffer = termBuffer;
        this.tailAddressOffset = metaDataBuffer.addressOffset() + (long)tailCounterOffset;
    }

    public int claim(int termId, int termOffset, HeaderWriter header, int length, BufferClaim bufferClaim) {
        int frameLength = length + 32;
        int alignedLength = BitUtil.align((int)frameLength, (int)32);
        UnsafeBuffer termBuffer = this.termBuffer;
        int termLength = termBuffer.capacity();
        int resultingOffset = termOffset + alignedLength;
        this.putRawTailOrdered(termId, resultingOffset);
        if (resultingOffset > termLength) {
            resultingOffset = ExclusiveTermAppender.handleEndOfLogCondition(termBuffer, termOffset, header, termLength, termId);
        } else {
            header.write(termBuffer, termOffset, frameLength, termId);
            bufferClaim.wrap((AtomicBuffer)termBuffer, termOffset, frameLength);
        }
        return resultingOffset;
    }

    public int appendPadding(int termId, int termOffset, HeaderWriter header, int length) {
        int frameLength = length + 32;
        int alignedLength = BitUtil.align((int)frameLength, (int)32);
        UnsafeBuffer termBuffer = this.termBuffer;
        int termLength = termBuffer.capacity();
        int resultingOffset = termOffset + alignedLength;
        this.putRawTailOrdered(termId, resultingOffset);
        if (resultingOffset > termLength) {
            resultingOffset = ExclusiveTermAppender.handleEndOfLogCondition(termBuffer, termOffset, header, termLength, termId);
        } else {
            header.write(termBuffer, termOffset, frameLength, termId);
            FrameDescriptor.frameType(termBuffer, termOffset, 0);
            FrameDescriptor.frameLengthOrdered(termBuffer, termOffset, frameLength);
        }
        return resultingOffset;
    }

    public int appendUnfragmentedMessage(int termId, int termOffset, HeaderWriter header, DirectBuffer srcBuffer, int srcOffset, int length, ReservedValueSupplier reservedValueSupplier) {
        int frameLength = length + 32;
        int alignedLength = BitUtil.align((int)frameLength, (int)32);
        UnsafeBuffer termBuffer = this.termBuffer;
        int termLength = termBuffer.capacity();
        int resultingOffset = termOffset + alignedLength;
        this.putRawTailOrdered(termId, resultingOffset);
        if (resultingOffset > termLength) {
            resultingOffset = ExclusiveTermAppender.handleEndOfLogCondition(termBuffer, termOffset, header, termLength, termId);
        } else {
            header.write(termBuffer, termOffset, frameLength, termId);
            termBuffer.putBytes(termOffset + 32, srcBuffer, srcOffset, length);
            if (null != reservedValueSupplier) {
                long reservedValue = reservedValueSupplier.get((DirectBuffer)termBuffer, termOffset, frameLength);
                termBuffer.putLong(termOffset + 24, reservedValue, ByteOrder.LITTLE_ENDIAN);
            }
            FrameDescriptor.frameLengthOrdered(termBuffer, termOffset, frameLength);
        }
        return resultingOffset;
    }

    public int appendUnfragmentedMessage(int termId, int termOffset, HeaderWriter header, DirectBuffer bufferOne, int offsetOne, int lengthOne, DirectBuffer bufferTwo, int offsetTwo, int lengthTwo, ReservedValueSupplier reservedValueSupplier) {
        int frameLength = lengthOne + lengthTwo + 32;
        int alignedLength = BitUtil.align((int)frameLength, (int)32);
        UnsafeBuffer termBuffer = this.termBuffer;
        int termLength = termBuffer.capacity();
        int resultingOffset = termOffset + alignedLength;
        this.putRawTailOrdered(termId, resultingOffset);
        if (resultingOffset > termLength) {
            resultingOffset = ExclusiveTermAppender.handleEndOfLogCondition(termBuffer, termOffset, header, termLength, termId);
        } else {
            header.write(termBuffer, termOffset, frameLength, termId);
            termBuffer.putBytes(termOffset + 32, bufferOne, offsetOne, lengthOne);
            termBuffer.putBytes(termOffset + 32 + lengthOne, bufferTwo, offsetTwo, lengthTwo);
            if (null != reservedValueSupplier) {
                long reservedValue = reservedValueSupplier.get((DirectBuffer)termBuffer, termOffset, frameLength);
                termBuffer.putLong(termOffset + 24, reservedValue, ByteOrder.LITTLE_ENDIAN);
            }
            FrameDescriptor.frameLengthOrdered(termBuffer, termOffset, frameLength);
        }
        return resultingOffset;
    }

    public int appendUnfragmentedMessage(int termId, int termOffset, HeaderWriter header, DirectBufferVector[] vectors, int length, ReservedValueSupplier reservedValueSupplier) {
        int frameLength = length + 32;
        int alignedLength = BitUtil.align((int)frameLength, (int)32);
        UnsafeBuffer termBuffer = this.termBuffer;
        int termLength = termBuffer.capacity();
        int resultingOffset = termOffset + alignedLength;
        this.putRawTailOrdered(termId, resultingOffset);
        if (resultingOffset > termLength) {
            resultingOffset = ExclusiveTermAppender.handleEndOfLogCondition(termBuffer, termOffset, header, termLength, termId);
        } else {
            header.write(termBuffer, termOffset, frameLength, termId);
            int offset = termOffset + 32;
            for (DirectBufferVector vector : vectors) {
                termBuffer.putBytes(offset, vector.buffer(), vector.offset(), vector.length());
                offset += vector.length();
            }
            if (null != reservedValueSupplier) {
                long reservedValue = reservedValueSupplier.get((DirectBuffer)termBuffer, termOffset, frameLength);
                termBuffer.putLong(termOffset + 24, reservedValue, ByteOrder.LITTLE_ENDIAN);
            }
            FrameDescriptor.frameLengthOrdered(termBuffer, termOffset, frameLength);
        }
        return resultingOffset;
    }

    public int appendFragmentedMessage(int termId, int termOffset, HeaderWriter header, DirectBuffer srcBuffer, int srcOffset, int length, int maxPayloadLength, ReservedValueSupplier reservedValueSupplier) {
        int numMaxPayloads = length / maxPayloadLength;
        int remainingPayload = length % maxPayloadLength;
        int lastFrameLength = remainingPayload > 0 ? BitUtil.align((int)(remainingPayload + 32), (int)32) : 0;
        int requiredLength = numMaxPayloads * (maxPayloadLength + 32) + lastFrameLength;
        UnsafeBuffer termBuffer = this.termBuffer;
        int termLength = termBuffer.capacity();
        int resultingOffset = termOffset + requiredLength;
        this.putRawTailOrdered(termId, resultingOffset);
        if (resultingOffset > termLength) {
            resultingOffset = ExclusiveTermAppender.handleEndOfLogCondition(termBuffer, termOffset, header, termLength, termId);
        } else {
            int bytesToWrite;
            int frameOffset = termOffset;
            byte flags = -128;
            int remaining = length;
            do {
                bytesToWrite = Math.min(remaining, maxPayloadLength);
                int frameLength = bytesToWrite + 32;
                int alignedLength = BitUtil.align((int)frameLength, (int)32);
                header.write(termBuffer, frameOffset, frameLength, termId);
                termBuffer.putBytes(frameOffset + 32, srcBuffer, srcOffset + (length - remaining), bytesToWrite);
                if (remaining <= maxPayloadLength) {
                    flags = (byte)(flags | 0x40);
                }
                FrameDescriptor.frameFlags(termBuffer, frameOffset, flags);
                if (null != reservedValueSupplier) {
                    long reservedValue = reservedValueSupplier.get((DirectBuffer)termBuffer, frameOffset, frameLength);
                    termBuffer.putLong(frameOffset + 24, reservedValue, ByteOrder.LITTLE_ENDIAN);
                }
                FrameDescriptor.frameLengthOrdered(termBuffer, frameOffset, frameLength);
                flags = 0;
                frameOffset += alignedLength;
            } while ((remaining -= bytesToWrite) > 0);
        }
        return resultingOffset;
    }

    public int appendFragmentedMessage(int termId, int termOffset, HeaderWriter header, DirectBuffer bufferOne, int offsetOne, int lengthOne, DirectBuffer bufferTwo, int offsetTwo, int lengthTwo, int maxPayloadLength, ReservedValueSupplier reservedValueSupplier) {
        int length = lengthOne + lengthTwo;
        int numMaxPayloads = length / maxPayloadLength;
        int remainingPayload = length % maxPayloadLength;
        int lastFrameLength = remainingPayload > 0 ? BitUtil.align((int)(remainingPayload + 32), (int)32) : 0;
        int requiredLength = numMaxPayloads * (maxPayloadLength + 32) + lastFrameLength;
        UnsafeBuffer termBuffer = this.termBuffer;
        int termLength = termBuffer.capacity();
        int resultingOffset = termOffset + requiredLength;
        this.putRawTailOrdered(termId, resultingOffset);
        if (resultingOffset > termLength) {
            resultingOffset = ExclusiveTermAppender.handleEndOfLogCondition(termBuffer, termOffset, header, termLength, termId);
        } else {
            int bytesToWrite;
            int frameOffset = termOffset;
            byte flags = -128;
            int remaining = length;
            int positionOne = 0;
            int positionTwo = 0;
            do {
                bytesToWrite = Math.min(remaining, maxPayloadLength);
                int frameLength = bytesToWrite + 32;
                int alignedLength = BitUtil.align((int)frameLength, (int)32);
                header.write(termBuffer, frameOffset, frameLength, termId);
                int bytesWritten = 0;
                int payloadOffset = frameOffset + 32;
                do {
                    int numBytes;
                    int remainingOne;
                    if ((remainingOne = lengthOne - positionOne) > 0) {
                        numBytes = Math.min(bytesToWrite - bytesWritten, remainingOne);
                        termBuffer.putBytes(payloadOffset, bufferOne, offsetOne + positionOne, numBytes);
                        bytesWritten += numBytes;
                        payloadOffset += numBytes;
                        positionOne += numBytes;
                        continue;
                    }
                    numBytes = Math.min(bytesToWrite - bytesWritten, lengthTwo - positionTwo);
                    termBuffer.putBytes(payloadOffset, bufferTwo, offsetTwo + positionTwo, numBytes);
                    bytesWritten += numBytes;
                    payloadOffset += numBytes;
                    positionTwo += numBytes;
                } while (bytesWritten < bytesToWrite);
                if (remaining <= maxPayloadLength) {
                    flags = (byte)(flags | 0x40);
                }
                FrameDescriptor.frameFlags(termBuffer, frameOffset, flags);
                if (null != reservedValueSupplier) {
                    long reservedValue = reservedValueSupplier.get((DirectBuffer)termBuffer, frameOffset, frameLength);
                    termBuffer.putLong(frameOffset + 24, reservedValue, ByteOrder.LITTLE_ENDIAN);
                }
                FrameDescriptor.frameLengthOrdered(termBuffer, frameOffset, frameLength);
                flags = 0;
                frameOffset += alignedLength;
            } while ((remaining -= bytesToWrite) > 0);
        }
        return resultingOffset;
    }

    public int appendFragmentedMessage(int termId, int termOffset, HeaderWriter header, DirectBufferVector[] vectors, int length, int maxPayloadLength, ReservedValueSupplier reservedValueSupplier) {
        int numMaxPayloads = length / maxPayloadLength;
        int remainingPayload = length % maxPayloadLength;
        int lastFrameLength = remainingPayload > 0 ? BitUtil.align((int)(remainingPayload + 32), (int)32) : 0;
        int requiredLength = numMaxPayloads * (maxPayloadLength + 32) + lastFrameLength;
        UnsafeBuffer termBuffer = this.termBuffer;
        int termLength = termBuffer.capacity();
        int resultingOffset = termOffset + requiredLength;
        this.putRawTailOrdered(termId, resultingOffset);
        if (resultingOffset > termLength) {
            resultingOffset = ExclusiveTermAppender.handleEndOfLogCondition(termBuffer, termOffset, header, termLength, termId);
        } else {
            int bytesToWrite;
            int frameOffset = termOffset;
            byte flags = -128;
            int remaining = length;
            int vectorIndex = 0;
            int vectorOffset = 0;
            do {
                bytesToWrite = Math.min(remaining, maxPayloadLength);
                int frameLength = bytesToWrite + 32;
                int alignedLength = BitUtil.align((int)frameLength, (int)32);
                header.write(termBuffer, frameOffset, frameLength, termId);
                int bytesWritten = 0;
                int payloadOffset = frameOffset + 32;
                do {
                    DirectBufferVector vector = vectors[vectorIndex];
                    int vectorRemaining = vector.length() - vectorOffset;
                    int numBytes = Math.min(bytesToWrite - bytesWritten, vectorRemaining);
                    termBuffer.putBytes(payloadOffset, vector.buffer(), vector.offset() + vectorOffset, numBytes);
                    bytesWritten += numBytes;
                    payloadOffset += numBytes;
                    vectorOffset += numBytes;
                    if (vectorRemaining > numBytes) continue;
                    ++vectorIndex;
                    vectorOffset = 0;
                } while (bytesWritten < bytesToWrite);
                if (remaining <= maxPayloadLength) {
                    flags = (byte)(flags | 0x40);
                }
                FrameDescriptor.frameFlags(termBuffer, frameOffset, flags);
                if (null != reservedValueSupplier) {
                    long reservedValue = reservedValueSupplier.get((DirectBuffer)termBuffer, frameOffset, frameLength);
                    termBuffer.putLong(frameOffset + 24, reservedValue, ByteOrder.LITTLE_ENDIAN);
                }
                FrameDescriptor.frameLengthOrdered(termBuffer, frameOffset, frameLength);
                flags = 0;
                frameOffset += alignedLength;
            } while ((remaining -= bytesToWrite) > 0);
        }
        return resultingOffset;
    }

    public int appendBlock(int termId, int termOffset, MutableDirectBuffer buffer, int offset, int length) {
        int resultingOffset = termOffset + length;
        int lengthOfFirstFrame = buffer.getInt(offset, ByteOrder.LITTLE_ENDIAN);
        buffer.putInt(offset, 0, ByteOrder.LITTLE_ENDIAN);
        this.termBuffer.putBytes(termOffset, (DirectBuffer)buffer, offset, length);
        FrameDescriptor.frameLengthOrdered(this.termBuffer, termOffset, lengthOfFirstFrame);
        this.putRawTailOrdered(termId, resultingOffset);
        return resultingOffset;
    }

    private static int handleEndOfLogCondition(UnsafeBuffer termBuffer, long termOffset, HeaderWriter header, int termLength, int termId) {
        if (termOffset < (long)termLength) {
            int offset = (int)termOffset;
            int paddingLength = termLength - offset;
            header.write(termBuffer, offset, paddingLength, termId);
            FrameDescriptor.frameType(termBuffer, offset, 0);
            FrameDescriptor.frameLengthOrdered(termBuffer, offset, paddingLength);
        }
        return -1;
    }

    private void putRawTailOrdered(int termId, int termOffset) {
        UnsafeAccess.UNSAFE.putOrderedLong(null, this.tailAddressOffset, LogBufferDescriptor.packTail(termId, termOffset));
    }
}

