/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.singleton.impl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReference;
import org.checkerframework.checker.lock.qual.GuardedBy;
import org.checkerframework.checker.lock.qual.Holding;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.mdsal.eos.common.api.CandidateAlreadyRegisteredException;
import org.opendaylight.mdsal.eos.common.api.EntityOwnershipStateChange;
import org.opendaylight.mdsal.eos.dom.api.DOMEntity;
import org.opendaylight.mdsal.eos.dom.api.DOMEntityOwnershipService;
import org.opendaylight.mdsal.singleton.api.ClusterSingletonService;
import org.opendaylight.mdsal.singleton.api.ServiceGroupIdentifier;
import org.opendaylight.mdsal.singleton.impl.ServiceGroup;
import org.opendaylight.mdsal.singleton.impl.ServiceInfo;
import org.opendaylight.mdsal.singleton.impl.ServiceRegistration;
import org.opendaylight.yangtools.concepts.Registration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ActiveServiceGroup
extends ServiceGroup {
    private static final Logger LOG = LoggerFactory.getLogger(ActiveServiceGroup.class);
    private final @NonNull DOMEntityOwnershipService entityOwnershipService;
    private final @NonNull ServiceGroupIdentifier identifier;
    private final @NonNull DOMEntity serviceEntity;
    private final @NonNull DOMEntity cleanupEntity;
    private final Set<ServiceRegistration> members = ConcurrentHashMap.newKeySet();
    private final Map<ServiceRegistration, ServiceInfo> services = new HashMap<ServiceRegistration, ServiceInfo>();
    private static final AtomicIntegerFieldUpdater<ActiveServiceGroup> DIRTY_UPDATER = AtomicIntegerFieldUpdater.newUpdater(ActiveServiceGroup.class, "dirty");
    private volatile int dirty;
    private static final AtomicIntegerFieldUpdater<ActiveServiceGroup> LOCK_UPDATER = AtomicIntegerFieldUpdater.newUpdater(ActiveServiceGroup.class, "lock");
    private volatile int lock;
    private final AtomicReference<SettableFuture<Void>> closeFuture = new AtomicReference();
    private @GuardedBy(value={"this"}) Registration serviceEntityReg = null;
    private @GuardedBy(value={"this"}) EntityState serviceEntityState = EntityState.UNREGISTERED;
    private @GuardedBy(value={"this"}) Registration cleanupEntityReg;
    private @GuardedBy(value={"this"}) EntityState cleanupEntityState = EntityState.UNREGISTERED;
    private volatile boolean initialized;

    ActiveServiceGroup(ServiceGroupIdentifier identifier, DOMEntityOwnershipService entityOwnershipService, DOMEntity serviceEntity, DOMEntity cleanupEntity, List<ServiceRegistration> services) {
        this.identifier = Objects.requireNonNull(identifier);
        this.entityOwnershipService = Objects.requireNonNull(entityOwnershipService);
        this.serviceEntity = Objects.requireNonNull(serviceEntity);
        this.cleanupEntity = Objects.requireNonNull(cleanupEntity);
        this.members.addAll(services);
        LOG.debug("Instantiated new service group for {}", (Object)identifier);
    }

    @VisibleForTesting
    ActiveServiceGroup(ServiceGroupIdentifier identifier, DOMEntity serviceEntity, DOMEntity cleanupEntity, DOMEntityOwnershipService entityOwnershipService) {
        this(identifier, entityOwnershipService, serviceEntity, cleanupEntity, (List<ServiceRegistration>)ImmutableList.of());
    }

    public ServiceGroupIdentifier getIdentifier() {
        return this.identifier;
    }

    @Override
    ListenableFuture<?> closeClusterSingletonGroup() {
        ListenableFuture<?> ret = this.destroyGroup();
        this.members.clear();
        this.markDirty();
        if (this.tryLock()) {
            this.reconcileState();
        } else {
            LOG.debug("Service group {} postponing sync on close", (Object)this.identifier);
        }
        return ret;
    }

    private boolean isClosed() {
        return this.closeFuture.get() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void initialize() throws CandidateAlreadyRegisteredException {
        Verify.verify((boolean)this.tryLock());
        try {
            Preconditions.checkState((!this.initialized ? 1 : 0) != 0, (String)"Singleton group %s was already initilized", (Object)this.identifier);
            LOG.debug("Initializing service group {} with services {}", (Object)this.identifier, this.members);
            ActiveServiceGroup activeServiceGroup = this;
            synchronized (activeServiceGroup) {
                this.serviceEntityState = EntityState.REGISTERED;
                this.serviceEntityReg = this.entityOwnershipService.registerCandidate(this.serviceEntity);
                this.initialized = true;
            }
        }
        finally {
            this.unlock();
        }
    }

    private void checkNotClosed() {
        Preconditions.checkState((!this.isClosed() ? 1 : 0) != 0, (String)"Service group %s has already been closed", (Object)this.identifier);
    }

    @Override
    void registerService(ServiceRegistration reg) {
        ClusterSingletonService service = this.verifyRegistration(reg);
        this.checkNotClosed();
        Preconditions.checkState((boolean)this.initialized, (String)"Service group %s is not initialized yet", (Object)this.identifier);
        LOG.debug("Adding service {} to service group {}", (Object)service, (Object)this.identifier);
        Verify.verify((boolean)this.members.add(reg));
        this.markDirty();
        if (!this.tryLock()) {
            LOG.debug("Service group {} delayed register of {}", (Object)this.identifier, (Object)reg);
            return;
        }
        this.reconcileState();
    }

    @Override
    ListenableFuture<?> unregisterService(ServiceRegistration reg) {
        this.verifyRegistration(reg);
        this.checkNotClosed();
        Verify.verify((boolean)this.members.remove((Object)reg));
        this.markDirty();
        if (this.members.isEmpty()) {
            return this.destroyGroup();
        }
        if (this.tryLock()) {
            this.reconcileState();
        } else {
            LOG.debug("Service group {} delayed unregister of {}", (Object)this.identifier, (Object)reg);
        }
        return null;
    }

    private ClusterSingletonService verifyRegistration(ServiceRegistration reg) {
        ClusterSingletonService service = (ClusterSingletonService)reg.getInstance();
        Verify.verify((boolean)this.identifier.equals(service.getIdentifier()));
        return service;
    }

    private synchronized @NonNull ListenableFuture<?> destroyGroup() {
        SettableFuture future = SettableFuture.create();
        SettableFuture<Void> witness = this.closeFuture.compareAndExchange(null, (SettableFuture<Void>)future);
        if (witness != null) {
            return witness;
        }
        if (this.serviceEntityReg != null) {
            LOG.debug("Service group {} unregistering service entity {}", (Object)this.identifier, (Object)this.serviceEntity);
            this.serviceEntityReg.close();
            this.serviceEntityReg = null;
        }
        this.markDirty();
        return future;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void ownershipChanged(DOMEntity entity, EntityOwnershipStateChange change, boolean inJeopardy) {
        ActiveServiceGroup activeServiceGroup = this;
        synchronized (activeServiceGroup) {
            this.lockedOwnershipChanged(entity, change, inJeopardy);
        }
        if (this.isDirty()) {
            if (!this.tryLock()) {
                LOG.debug("Service group {} postponing ownership change sync", (Object)this.identifier);
                return;
            }
            this.reconcileState();
        }
    }

    @Holding(value={"this"})
    private void lockedOwnershipChanged(DOMEntity entity, EntityOwnershipStateChange change, boolean inJeopardy) {
        if (this.serviceEntity.equals((Object)entity)) {
            this.serviceOwnershipChanged(change, inJeopardy);
            this.markDirty();
        } else if (this.cleanupEntity.equals((Object)entity)) {
            this.cleanupCandidateOwnershipChanged(change, inJeopardy);
            this.markDirty();
        } else {
            LOG.warn("Group {} received unrecognized entity {}", (Object)this.identifier, (Object)entity);
        }
    }

    @Holding(value={"this"})
    private void cleanupCandidateOwnershipChanged(EntityOwnershipStateChange state, boolean jeopardy) {
        if (jeopardy) {
            this.cleanupEntityState = switch (state) {
                default -> throw new MatchException(null, null);
                case EntityOwnershipStateChange.LOCAL_OWNERSHIP_GRANTED, EntityOwnershipStateChange.LOCAL_OWNERSHIP_RETAINED_WITH_NO_CHANGE -> {
                    LOG.warn("Service group {} cleanup entity owned without certainty", (Object)this.identifier);
                    yield EntityState.OWNED_JEOPARDY;
                }
                case EntityOwnershipStateChange.LOCAL_OWNERSHIP_LOST_NEW_OWNER, EntityOwnershipStateChange.LOCAL_OWNERSHIP_LOST_NO_OWNER, EntityOwnershipStateChange.REMOTE_OWNERSHIP_CHANGED, EntityOwnershipStateChange.REMOTE_OWNERSHIP_LOST_NO_OWNER -> {
                    LOG.info("Service group {} cleanup entity ownership uncertain", (Object)this.identifier);
                    yield EntityState.UNOWNED;
                }
            };
            return;
        }
        if (this.cleanupEntityState == EntityState.OWNED_JEOPARDY) {
            LOG.info("Service group {} cleanup entity ownership ascertained", (Object)this.identifier);
        }
        this.cleanupEntityState = switch (state) {
            default -> throw new MatchException(null, null);
            case EntityOwnershipStateChange.LOCAL_OWNERSHIP_GRANTED, EntityOwnershipStateChange.LOCAL_OWNERSHIP_RETAINED_WITH_NO_CHANGE -> EntityState.OWNED;
            case EntityOwnershipStateChange.LOCAL_OWNERSHIP_LOST_NEW_OWNER, EntityOwnershipStateChange.LOCAL_OWNERSHIP_LOST_NO_OWNER, EntityOwnershipStateChange.REMOTE_OWNERSHIP_CHANGED, EntityOwnershipStateChange.REMOTE_OWNERSHIP_LOST_NO_OWNER -> EntityState.UNOWNED;
        };
    }

    @Holding(value={"this"})
    private void serviceOwnershipChanged(EntityOwnershipStateChange state, boolean jeopardy) {
        if (jeopardy) {
            LOG.info("Service group {} service entity ownership uncertain", (Object)this.identifier);
            this.serviceEntityState = switch (state) {
                default -> throw new MatchException(null, null);
                case EntityOwnershipStateChange.LOCAL_OWNERSHIP_GRANTED, EntityOwnershipStateChange.LOCAL_OWNERSHIP_RETAINED_WITH_NO_CHANGE -> EntityState.OWNED_JEOPARDY;
                case EntityOwnershipStateChange.LOCAL_OWNERSHIP_LOST_NEW_OWNER, EntityOwnershipStateChange.LOCAL_OWNERSHIP_LOST_NO_OWNER, EntityOwnershipStateChange.REMOTE_OWNERSHIP_CHANGED, EntityOwnershipStateChange.REMOTE_OWNERSHIP_LOST_NO_OWNER -> EntityState.UNOWNED;
            };
            return;
        }
        if (this.serviceEntityState == EntityState.OWNED_JEOPARDY) {
            LOG.info("Service group {} service entity ownership ascertained", (Object)this.identifier);
        }
        switch (state) {
            case LOCAL_OWNERSHIP_GRANTED: 
            case LOCAL_OWNERSHIP_RETAINED_WITH_NO_CHANGE: {
                LOG.debug("Service group {} acquired service entity ownership", (Object)this.identifier);
                this.serviceEntityState = EntityState.OWNED;
                break;
            }
            case LOCAL_OWNERSHIP_LOST_NEW_OWNER: 
            case LOCAL_OWNERSHIP_LOST_NO_OWNER: 
            case REMOTE_OWNERSHIP_CHANGED: 
            case REMOTE_OWNERSHIP_LOST_NO_OWNER: {
                LOG.debug("Service group {} lost service entity ownership", (Object)this.identifier);
                this.serviceEntityState = EntityState.UNOWNED;
                break;
            }
            default: {
                LOG.warn("Service group {} ignoring unhandled cleanup entity change {}", (Object)this.identifier, (Object)state);
            }
        }
    }

    private void reconcileState() {
        block7: {
            block6: {
                while (true) {
                    try {
                        if (this.conditionalClean()) {
                            this.tryReconcileState();
                        }
                    }
                    finally {
                        this.unlock();
                    }
                    if (!this.isDirty()) break block6;
                    if (!this.tryLock()) break;
                    LOG.debug("Service group {} re-running reconciliation", (Object)this.identifier);
                }
                LOG.debug("Service group {} will be reconciled by someone else", (Object)this.identifier);
                break block7;
            }
            LOG.debug("Service group {} is completely reconciled", (Object)this.identifier);
        }
    }

    private void serviceTransitionCompleted() {
        this.markDirty();
        if (this.tryLock()) {
            this.reconcileState();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryReconcileState() {
        ImmutableSet localMembers;
        boolean haveCleanup;
        boolean haveService;
        ActiveServiceGroup activeServiceGroup = this;
        synchronized (activeServiceGroup) {
            if (this.serviceEntityReg != null) {
                haveService = switch (this.serviceEntityState.ordinal()) {
                    default -> throw new MatchException(null, null);
                    case 2, 3 -> true;
                    case 0, 1, 4 -> false;
                };
            } else {
                haveService = false;
            }
            if (haveService && this.cleanupEntityReg == null) {
                block29: {
                    LOG.debug("Service group {} registering cleanup entity", (Object)this.identifier);
                    try {
                        this.cleanupEntityState = EntityState.REGISTERED;
                        this.cleanupEntityReg = this.entityOwnershipService.registerCandidate(this.cleanupEntity);
                    }
                    catch (CandidateAlreadyRegisteredException e) {
                        LOG.error("Service group {} failed to take ownership, aborting", (Object)this.identifier, (Object)e);
                        if (this.serviceEntityReg == null) break block29;
                        this.serviceEntityReg.close();
                        this.serviceEntityReg = null;
                    }
                }
                this.markDirty();
                return;
            }
            if (this.cleanupEntityReg != null) {
                haveCleanup = switch (this.cleanupEntityState.ordinal()) {
                    default -> throw new MatchException(null, null);
                    case 2 -> true;
                    case 0, 1, 3, 4 -> false;
                };
            } else {
                haveCleanup = false;
            }
            localMembers = ImmutableSet.copyOf(this.members);
        }
        if (haveService && haveCleanup) {
            this.ensureServicesStarting((Set<ServiceRegistration>)localMembers);
            return;
        }
        this.ensureServicesStopping();
        if (!haveService && this.services.isEmpty()) {
            SettableFuture<Void> localFuture;
            boolean canFinishClose;
            LOG.debug("Service group {} has no running services", (Object)this.identifier);
            ActiveServiceGroup e = this;
            synchronized (e) {
                if (this.cleanupEntityReg != null) {
                    LOG.debug("Service group {} releasing cleanup entity", (Object)this.identifier);
                    this.cleanupEntityReg.close();
                    this.cleanupEntityReg = null;
                }
                canFinishClose = switch (this.cleanupEntityState.ordinal()) {
                    default -> throw new MatchException(null, null);
                    case 1, 2, 3 -> false;
                    case 0, 4 -> true;
                };
            }
            if (canFinishClose && (localFuture = this.closeFuture.get()) != null && !localFuture.isDone()) {
                LOG.debug("Service group {} completing termination", (Object)this.identifier);
                localFuture.set(null);
            }
        }
    }

    private void ensureServicesStarting(Set<ServiceRegistration> localConfig) {
        LOG.debug("Service group {} starting services", (Object)this.identifier);
        Iterator<Map.Entry<ServiceRegistration, ServiceInfo>> it = this.services.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<ServiceRegistration, ServiceInfo> entry = it.next();
            ServiceRegistration reg = entry.getKey();
            if (localConfig.contains((Object)reg)) continue;
            ServiceInfo newInfo = this.ensureStopping(reg, entry.getValue());
            if (newInfo != null) {
                entry.setValue(newInfo);
                continue;
            }
            it.remove();
        }
        for (ServiceRegistration reg : localConfig) {
            if (this.services.containsKey((Object)reg)) continue;
            ClusterSingletonService service = (ClusterSingletonService)reg.getInstance();
            LOG.debug("Starting service {}", (Object)service);
            try {
                service.instantiateServiceInstance();
            }
            catch (Exception e) {
                LOG.warn("Service group {} service {} failed to start, attempting to continue", new Object[]{this.identifier, service, e});
                continue;
            }
            this.services.put(reg, ServiceInfo.STARTED);
        }
    }

    private void ensureServicesStopping() {
        Iterator<Map.Entry<ServiceRegistration, ServiceInfo>> it = this.services.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<ServiceRegistration, ServiceInfo> entry = it.next();
            ServiceInfo newInfo = this.ensureStopping(entry.getKey(), entry.getValue());
            if (newInfo != null) {
                entry.setValue(newInfo);
                continue;
            }
            it.remove();
        }
    }

    private ServiceInfo ensureStopping(ServiceRegistration reg, ServiceInfo info) {
        switch (info.getState().ordinal()) {
            case 0: {
                ListenableFuture future;
                final ClusterSingletonService service = (ClusterSingletonService)reg.getInstance();
                LOG.debug("Service group {} stopping service {}", (Object)this.identifier, (Object)service);
                try {
                    future = (ListenableFuture)Verify.verifyNotNull((Object)service.closeServiceInstance());
                }
                catch (Exception e) {
                    LOG.warn("Service group {} service {} failed to stop, attempting to continue", new Object[]{this.identifier, service, e});
                    return null;
                }
                Futures.addCallback((ListenableFuture)future, (FutureCallback)new FutureCallback<Object>(){

                    public void onSuccess(Object result) {
                        LOG.debug("Service group {} service {} stopped successfully", (Object)ActiveServiceGroup.this.identifier, (Object)service);
                        ActiveServiceGroup.this.serviceTransitionCompleted();
                    }

                    public void onFailure(Throwable cause) {
                        LOG.debug("Service group {} service {} stopped with error", new Object[]{ActiveServiceGroup.this.identifier, service, cause});
                        ActiveServiceGroup.this.serviceTransitionCompleted();
                    }
                }, (Executor)MoreExecutors.directExecutor());
                return info.toState(ServiceState.STOPPING, future);
            }
            case 1: {
                if (info.getFuture().isDone()) {
                    LOG.debug("Service group {} removed stopped service {}", (Object)this.identifier, reg.getInstance());
                    return null;
                }
                return info;
            }
        }
        throw new IllegalStateException("Unhandled state " + String.valueOf((Object)info.getState()));
    }

    private void markDirty() {
        this.dirty = 1;
    }

    private boolean isDirty() {
        return this.dirty != 0;
    }

    private boolean conditionalClean() {
        return DIRTY_UPDATER.compareAndSet(this, 1, 0);
    }

    private boolean tryLock() {
        return LOCK_UPDATER.compareAndSet(this, 0, 1);
    }

    private boolean unlock() {
        Verify.verify((boolean)LOCK_UPDATER.compareAndSet(this, 1, 0));
        return true;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("identifier", (Object)this.identifier).toString();
    }

    private static enum EntityState {
        UNREGISTERED,
        REGISTERED,
        OWNED,
        OWNED_JEOPARDY,
        UNOWNED;

    }

    static enum ServiceState {
        STARTED,
        STOPPING;

    }
}

