/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.singleton.impl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Verify;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.checkerframework.checker.lock.qual.Holding;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.mdsal.eos.common.api.CandidateAlreadyRegisteredException;
import org.opendaylight.mdsal.eos.common.api.EntityOwnershipStateChange;
import org.opendaylight.mdsal.eos.dom.api.DOMEntity;
import org.opendaylight.mdsal.eos.dom.api.DOMEntityOwnershipListener;
import org.opendaylight.mdsal.eos.dom.api.DOMEntityOwnershipService;
import org.opendaylight.mdsal.singleton.api.ClusterSingletonService;
import org.opendaylight.mdsal.singleton.api.ClusterSingletonServiceProvider;
import org.opendaylight.mdsal.singleton.api.ServiceGroupIdentifier;
import org.opendaylight.mdsal.singleton.impl.ActiveServiceGroup;
import org.opendaylight.mdsal.singleton.impl.PlaceholderServiceGroup;
import org.opendaylight.mdsal.singleton.impl.ServiceGroup;
import org.opendaylight.mdsal.singleton.impl.ServiceRegistration;
import org.opendaylight.yangtools.concepts.Registration;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Component(service={ClusterSingletonServiceProvider.class})
public final class EOSClusterSingletonServiceProvider
implements ClusterSingletonServiceProvider,
DOMEntityOwnershipListener,
AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(EOSClusterSingletonServiceProvider.class);
    @VisibleForTesting
    static final @NonNull String SERVICE_ENTITY_TYPE = "org.opendaylight.mdsal.ServiceEntityType";
    @VisibleForTesting
    static final @NonNull String CLOSE_SERVICE_ENTITY_TYPE = "org.opendaylight.mdsal.AsyncServiceCloseEntityType";
    private final ConcurrentMap<String, ServiceGroup> serviceGroupMap = new ConcurrentHashMap<String, ServiceGroup>();
    private final DOMEntityOwnershipService entityOwnershipService;
    private Registration serviceEntityListenerReg;
    private Registration asyncCloseEntityListenerReg;

    @Inject
    @Activate
    public EOSClusterSingletonServiceProvider(@Reference DOMEntityOwnershipService entityOwnershipService) {
        this.entityOwnershipService = Objects.requireNonNull(entityOwnershipService);
        this.serviceEntityListenerReg = entityOwnershipService.registerListener(SERVICE_ENTITY_TYPE, (DOMEntityOwnershipListener)this);
        this.asyncCloseEntityListenerReg = entityOwnershipService.registerListener(CLOSE_SERVICE_ENTITY_TYPE, (DOMEntityOwnershipListener)this);
        LOG.info("Cluster Singleton Service started");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @PreDestroy
    @Deactivate
    public void close() throws ExecutionException, InterruptedException {
        ListenableFuture future;
        Registration reg;
        EOSClusterSingletonServiceProvider eOSClusterSingletonServiceProvider = this;
        synchronized (eOSClusterSingletonServiceProvider) {
            if (this.serviceEntityListenerReg == null) {
                return;
            }
            LOG.info("Cluster Singleton Service stopping");
            reg = this.serviceEntityListenerReg;
            this.serviceEntityListenerReg = null;
            future = Futures.allAsList(this.serviceGroupMap.values().stream().map(ServiceGroup::closeClusterSingletonGroup).toList());
        }
        try {
            LOG.debug("Waiting for service groups to stop");
            future.get();
        }
        finally {
            reg.close();
            this.asyncCloseEntityListenerReg.close();
            this.asyncCloseEntityListenerReg = null;
            this.serviceGroupMap.clear();
            LOG.info("Cluster Singleton Service stopped");
        }
    }

    public synchronized Registration registerClusterSingletonService(ClusterSingletonService service) {
        ServiceGroup serviceGroup;
        final ServiceGroupIdentifier serviceIdentifier = Objects.requireNonNull((ServiceGroupIdentifier)service.getIdentifier());
        if (this.serviceEntityListenerReg == null) {
            throw new IllegalStateException(String.valueOf(this) + "is closed");
        }
        LOG.debug("Call registrationService {} method for ClusterSingletonService Provider {}", (Object)service, (Object)this);
        String identifierValue = serviceIdentifier.value();
        ServiceGroup existing = (ServiceGroup)this.serviceGroupMap.get(identifierValue);
        if (existing == null) {
            serviceGroup = this.createGroup(serviceIdentifier, new ArrayList<ServiceRegistration>(1));
            this.serviceGroupMap.put(identifierValue, serviceGroup);
            try {
                this.initializeOrRemoveGroup(serviceGroup);
            }
            catch (CandidateAlreadyRegisteredException e) {
                throw new IllegalArgumentException("Service group already registered", e);
            }
        } else {
            serviceGroup = existing;
        }
        ServiceRegistration reg = new ServiceRegistration(service){

            protected void removeRegistration() {
                EOSClusterSingletonServiceProvider.this.removeRegistration(serviceIdentifier, this);
            }
        };
        serviceGroup.registerService(reg);
        return reg;
    }

    private ServiceGroup createGroup(ServiceGroupIdentifier identifier, List<ServiceRegistration> services) {
        return new ActiveServiceGroup(identifier, this.entityOwnershipService, EOSClusterSingletonServiceProvider.createEntity(SERVICE_ENTITY_TYPE, identifier), EOSClusterSingletonServiceProvider.createEntity(CLOSE_SERVICE_ENTITY_TYPE, identifier), services);
    }

    @Holding(value={"this"})
    private void initializeOrRemoveGroup(ServiceGroup group) throws CandidateAlreadyRegisteredException {
        try {
            group.initialize();
        }
        catch (CandidateAlreadyRegisteredException e) {
            this.serviceGroupMap.remove(group.getIdentifier(), group);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeRegistration(ServiceGroupIdentifier serviceIdentifier, ServiceRegistration reg) {
        PlaceholderServiceGroup placeHolder;
        ListenableFuture<?> future;
        EOSClusterSingletonServiceProvider eOSClusterSingletonServiceProvider = this;
        synchronized (eOSClusterSingletonServiceProvider) {
            ServiceGroup lookup = (ServiceGroup)Verify.verifyNotNull((Object)((ServiceGroup)this.serviceGroupMap.get(serviceIdentifier.value())));
            future = lookup.unregisterService(reg);
            if (future == null) {
                return;
            }
            LOG.debug("Closing service group {}", (Object)serviceIdentifier);
            placeHolder = new PlaceholderServiceGroup(lookup, future);
            String identifier = ((ServiceGroupIdentifier)((ClusterSingletonService)reg.getInstance()).getIdentifier()).value();
            Verify.verify((boolean)this.serviceGroupMap.replace(identifier, lookup, placeHolder));
            LOG.debug("Replaced group {} with {}", (Object)serviceIdentifier, (Object)placeHolder);
            lookup.closeClusterSingletonGroup();
        }
        future.addListener(() -> this.finishShutdown(placeHolder), MoreExecutors.directExecutor());
    }

    private synchronized void finishShutdown(PlaceholderServiceGroup placeHolder) {
        ServiceGroupIdentifier identifier = placeHolder.getIdentifier();
        LOG.debug("Service group {} closed", (Object)identifier);
        List<ServiceRegistration> services = placeHolder.getServices();
        if (services.isEmpty()) {
            if (this.serviceGroupMap.remove(identifier.value(), placeHolder)) {
                LOG.debug("Service group {} removed", (Object)placeHolder);
            } else {
                LOG.debug("Service group {} superseded by {}", (Object)placeHolder, this.serviceGroupMap.get(identifier.value()));
            }
            return;
        }
        ServiceGroup group = this.createGroup(identifier, services);
        Verify.verify((boolean)this.serviceGroupMap.replace(identifier.value(), placeHolder, group));
        placeHolder.setSuccessor(group);
        LOG.debug("Service group upgraded from {} to {}", (Object)placeHolder, (Object)group);
        try {
            this.initializeOrRemoveGroup(group);
        }
        catch (CandidateAlreadyRegisteredException e) {
            LOG.error("Failed to register delayed group {}, it will remain inoperational", (Object)identifier, (Object)e);
        }
    }

    public void ownershipChanged(DOMEntity entity, EntityOwnershipStateChange change, boolean inJeopardy) {
        LOG.debug("Ownership change for ClusterSingletonService Provider on {} {} inJeopardy={}", new Object[]{entity, change, inJeopardy});
        String serviceIdentifier = EOSClusterSingletonServiceProvider.getServiceIdentifierFromEntity(entity);
        ServiceGroup serviceHolder = (ServiceGroup)this.serviceGroupMap.get(serviceIdentifier);
        if (serviceHolder != null) {
            serviceHolder.ownershipChanged(entity, change, inJeopardy);
        } else {
            LOG.debug("ClusterSingletonServiceGroup was not found for serviceIdentifier {}", (Object)serviceIdentifier);
        }
    }

    @VisibleForTesting
    static @NonNull String getServiceIdentifierFromEntity(DOMEntity entity) {
        YangInstanceIdentifier yii = (YangInstanceIdentifier)entity.getIdentifier();
        YangInstanceIdentifier.NodeIdentifierWithPredicates niiwp = (YangInstanceIdentifier.NodeIdentifierWithPredicates)yii.getLastPathArgument();
        return niiwp.values().iterator().next().toString();
    }

    @VisibleForTesting
    static DOMEntity createEntity(String entityType, ServiceGroupIdentifier sgi) {
        return new DOMEntity(entityType, sgi.value());
    }
}

