/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.singleton.impl;

import com.google.common.base.Verify;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.mdsal.singleton.impl.ActiveServiceGroup;

final class ServiceInfo {
    static final @NonNull ServiceInfo STARTED = new ServiceInfo(ActiveServiceGroup.ServiceState.STARTED, null);
    private final @Nullable ListenableFuture<?> future;
    private final  @NonNull ActiveServiceGroup.ServiceState state;

    private ServiceInfo(ActiveServiceGroup.ServiceState state, @Nullable ListenableFuture<?> future) {
        this.state = Objects.requireNonNull(state);
        this.future = future;
    }

     @NonNull ActiveServiceGroup.ServiceState getState() {
        return this.state;
    }

    @NonNull ListenableFuture<?> getFuture() {
        return (ListenableFuture)Verify.verifyNotNull(this.future);
    }

    @NonNull ServiceInfo toState( @NonNull ActiveServiceGroup.ServiceState newState) {
        Verify.verify((this.state != newState ? 1 : 0) != 0, (String)"Attempted to re-transition into %s", (Object)((Object)this.state));
        return new ServiceInfo(newState, null);
    }

    @NonNull ServiceInfo toState( @NonNull ActiveServiceGroup.ServiceState newState, @NonNull ListenableFuture<?> newFuture) {
        Verify.verify((this.state != newState ? 1 : 0) != 0, (String)"Attempted to re-transition into %s", (Object)((Object)this.state));
        return new ServiceInfo(newState, Objects.requireNonNull(newFuture));
    }
}

