/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.remote.rpc.messages;

import com.google.common.collect.ImmutableList;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.controller.cluster.datastore.node.utils.stream.SerializationUtils;
import org.opendaylight.controller.remote.rpc.messages.AbstractResponse;
import org.opendaylight.yangtools.yang.common.RpcError;
import org.opendaylight.yangtools.yang.data.api.schema.ContainerNode;

@SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED", "DMI_NONSERIALIZABLE_OBJECT_WRITTEN"})
public class ActionResponse
extends AbstractResponse<ContainerNode> {
    private static final long serialVersionUID = 1L;
    private final transient @NonNull ImmutableList<@NonNull RpcError> errors;

    public ActionResponse(@Nullable ContainerNode output, @NonNull Collection<? extends RpcError> errors) {
        super(output);
        this.errors = ImmutableList.copyOf(errors);
    }

    public @NonNull ImmutableList<@NonNull RpcError> getErrors() {
        return this.errors;
    }

    @Override
    Object writeReplace() {
        return new Proxy(this);
    }

    private static class Proxy
    implements Externalizable {
        private static final long serialVersionUID = 1L;
        private ActionResponse actionResponse;

        public Proxy() {
        }

        Proxy(ActionResponse actionResponse) {
            this.actionResponse = Objects.requireNonNull(actionResponse);
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.actionResponse.getErrors());
            SerializationUtils.writeNormalizedNode((DataOutput)out, this.actionResponse.getOutput());
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            ImmutableList errors = (ImmutableList)in.readObject();
            Optional output = SerializationUtils.readNormalizedNode((DataInput)in);
            this.actionResponse = new ActionResponse(output.map(ContainerNode.class::cast).orElse(null), (Collection<? extends RpcError>)errors);
        }

        private Object readResolve() {
            return this.actionResponse;
        }
    }
}

