/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.remote.rpc.registry.gossip;

import akka.actor.ActorRef;
import akka.actor.Address;
import akka.dispatch.OnComplete;
import akka.pattern.Patterns;
import akka.util.Timeout;
import com.google.common.annotations.VisibleForTesting;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import org.opendaylight.controller.remote.rpc.registry.gossip.Bucket;
import org.opendaylight.controller.remote.rpc.registry.gossip.BucketData;
import org.opendaylight.controller.remote.rpc.registry.gossip.BucketStoreActor;
import scala.Function1;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;

@VisibleForTesting
public final class BucketStoreAccess {
    private final ActorRef actorRef;
    private final ExecutionContext dispatcher;
    private final Timeout timeout;

    public BucketStoreAccess(ActorRef actorRef, ExecutionContext dispatcher, Timeout timeout) {
        this.actorRef = Objects.requireNonNull(actorRef);
        this.dispatcher = Objects.requireNonNull(dispatcher);
        this.timeout = Objects.requireNonNull(timeout);
    }

    <T extends BucketData<T>> void getBucketsByMembers(Collection<Address> members, final Consumer<Map<Address, Bucket<T>>> callback) {
        Patterns.ask((ActorRef)this.actorRef, (Object)BucketStoreActor.getBucketsByMembersMessage(members), (Timeout)this.timeout).onComplete((Function1)new OnComplete<Object>(this){

            public void onComplete(Throwable failure, Object success) {
                if (failure == null) {
                    callback.accept((Map)success);
                }
            }
        }, this.dispatcher);
    }

    void getBucketVersions(final Consumer<Map<Address, Long>> callback) {
        Patterns.ask((ActorRef)this.actorRef, (Object)((Object)Singletons.GET_BUCKET_VERSIONS), (Timeout)this.timeout).onComplete((Function1)new OnComplete<Object>(this){

            public void onComplete(Throwable failure, Object success) {
                if (failure == null) {
                    callback.accept((Map)success);
                }
            }
        }, this.dispatcher);
    }

    public Future<Map<Address, Long>> getBucketVersions() {
        return Patterns.ask((ActorRef)this.actorRef, (Object)((Object)Singletons.GET_BUCKET_VERSIONS), (Timeout)this.timeout);
    }

    void updateRemoteBuckets(Map<Address, ? extends Bucket<?>> buckets) {
        this.actorRef.tell((Object)BucketStoreActor.updateRemoteBucketsMessage(buckets), ActorRef.noSender());
    }

    void removeRemoteBucket(Address addr) {
        this.actorRef.tell((Object)BucketStoreActor.removeBucketMessage(addr), ActorRef.noSender());
    }

    public <T extends BucketData<T>> Future<T> getLocalData() {
        return Patterns.ask((ActorRef)this.actorRef, (Object)BucketStoreActor.getLocalDataMessage(), (Timeout)this.timeout);
    }

    public <T extends BucketData<T>> Future<Map<Address, Bucket<T>>> getRemoteBuckets() {
        return Patterns.ask((ActorRef)this.actorRef, (Object)BucketStoreActor.getRemoteBucketsMessage(), (Timeout)this.timeout);
    }

    public static enum Singletons {
        GET_ALL_BUCKETS,
        GET_BUCKET_VERSIONS;

    }
}

