/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.binding.generator;

import com.google.common.annotations.Beta;
import com.google.common.base.CharMatcher;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import org.opendaylight.yangtools.binding.model.api.Restrictions;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.BinaryTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.DecimalTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.LengthConstraint;
import org.opendaylight.yangtools.yang.model.api.type.PatternConstraint;
import org.opendaylight.yangtools.yang.model.api.type.RangeConstraint;
import org.opendaylight.yangtools.yang.model.api.type.RangeRestrictedTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.StringTypeDefinition;
import org.opendaylight.yangtools.yang.model.ri.type.BaseTypes;
import org.opendaylight.yangtools.yang.model.ri.type.DecimalTypeBuilder;

@Beta
public final class BindingGeneratorUtil {
    private static final CharMatcher GT_MATCHER = CharMatcher.is((char)'>');
    private static final CharMatcher LT_MATCHER = CharMatcher.is((char)'<');
    private static final Pattern UNICODE_CHAR_PATTERN = Pattern.compile("\\\\+u");

    private BindingGeneratorUtil() {
    }

    public static Restrictions getRestrictions(TypeDefinition<?> type) {
        if (type == null || type.getBaseType() == null) {
            if (type instanceof DecimalTypeDefinition) {
                DecimalTypeDefinition decimal = (DecimalTypeDefinition)type;
                DecimalTypeBuilder tmpBuilder = BaseTypes.decimalTypeBuilder((QName)decimal.getQName());
                tmpBuilder.setFractionDigits(decimal.getFractionDigits());
                DecimalTypeDefinition tmp = (DecimalTypeDefinition)tmpBuilder.build();
                if (!tmp.getRangeConstraint().equals(decimal.getRangeConstraint())) {
                    return Restrictions.of((RangeConstraint)decimal.getRangeConstraint().orElse(null));
                }
            }
            return Restrictions.empty();
        }
        if (type instanceof BinaryTypeDefinition) {
            BinaryTypeDefinition binary = (BinaryTypeDefinition)type;
            BinaryTypeDefinition base = (BinaryTypeDefinition)binary.getBaseType();
            Optional<Object> length = base != null && base.getBaseType() != null ? BindingGeneratorUtil.currentOrEmpty(binary.getLengthConstraint(), base.getLengthConstraint()) : binary.getLengthConstraint();
            return Restrictions.of((LengthConstraint)length.orElse(null));
        }
        if (type instanceof DecimalTypeDefinition) {
            DecimalTypeDefinition decimal = (DecimalTypeDefinition)type;
            DecimalTypeDefinition base = (DecimalTypeDefinition)decimal.getBaseType();
            Optional<Object> range = base != null && base.getBaseType() != null ? BindingGeneratorUtil.currentOrEmpty(decimal.getRangeConstraint(), base.getRangeConstraint()) : decimal.getRangeConstraint();
            return Restrictions.of((RangeConstraint)range.orElse(null));
        }
        if (type instanceof RangeRestrictedTypeDefinition) {
            return Restrictions.of((RangeConstraint)BindingGeneratorUtil.extractRangeConstraint((RangeRestrictedTypeDefinition)type).orElse(null));
        }
        if (type instanceof StringTypeDefinition) {
            StringTypeDefinition string = (StringTypeDefinition)type;
            StringTypeDefinition base = (StringTypeDefinition)string.getBaseType();
            Optional<Object> length = base != null && base.getBaseType() != null ? BindingGeneratorUtil.currentOrEmpty(string.getLengthConstraint(), base.getLengthConstraint()) : string.getLengthConstraint();
            return Restrictions.of(BindingGeneratorUtil.uniquePatterns(string), (LengthConstraint)length.orElse(null));
        }
        return Restrictions.empty();
    }

    private static <T extends RangeRestrictedTypeDefinition<?, ?>> Optional<? extends RangeConstraint<?>> extractRangeConstraint(T def) {
        RangeRestrictedTypeDefinition base = (RangeRestrictedTypeDefinition)def.getBaseType();
        if (base != null && base.getBaseType() != null) {
            return BindingGeneratorUtil.currentOrEmpty(def.getRangeConstraint(), base.getRangeConstraint());
        }
        return def.getRangeConstraint();
    }

    private static <T> Optional<T> currentOrEmpty(Optional<T> current, Optional<?> base) {
        return current.equals(base) ? Optional.empty() : current;
    }

    private static boolean containsConstraint(StringTypeDefinition type, PatternConstraint constraint) {
        for (StringTypeDefinition wlk = type; wlk != null; wlk = (StringTypeDefinition)wlk.getBaseType()) {
            if (!wlk.getPatternConstraints().contains(constraint)) continue;
            return true;
        }
        return false;
    }

    private static List<PatternConstraint> uniquePatterns(StringTypeDefinition type) {
        List constraints = type.getPatternConstraints();
        if (constraints.isEmpty()) {
            return constraints;
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        boolean filtered = false;
        for (PatternConstraint c : constraints) {
            if (BindingGeneratorUtil.containsConstraint((StringTypeDefinition)type.getBaseType(), c)) {
                filtered = true;
                continue;
            }
            builder.add((Object)c);
        }
        return filtered ? builder.build() : constraints;
    }

    public static String encodeAngleBrackets(String description) {
        if (description != null) {
            description = LT_MATCHER.replaceFrom((CharSequence)description, (CharSequence)"&lt;");
            description = GT_MATCHER.replaceFrom((CharSequence)description, (CharSequence)"&gt;");
        }
        return description;
    }

    public static String replaceAllIllegalChars(String str) {
        int backslash = str.indexOf(92);
        return backslash == -1 ? str : BindingGeneratorUtil.defangUnicodeEscapes(str);
    }

    private static String defangUnicodeEscapes(String str) {
        String ret = UNICODE_CHAR_PATTERN.matcher(str).replaceAll("\\\\\\\\u");
        return ret.isEmpty() ? "" : ret;
    }
}

