/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.binding.generator.impl.reactor;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.binding.generator.impl.reactor.AbstractAugmentGenerator;
import org.opendaylight.yangtools.binding.generator.impl.reactor.AbstractCompositeGenerator;
import org.opendaylight.yangtools.binding.generator.impl.reactor.GroupingGenerator;
import org.opendaylight.yangtools.concepts.Mutable;
import org.opendaylight.yangtools.yang.model.api.stmt.AugmentEffectiveStatement;

final class AugmentResolver
implements Mutable {
    private final Deque<AbstractCompositeGenerator<?, ?>> stack = new ArrayDeque();

    AugmentResolver() {
    }

    void enter(AbstractCompositeGenerator<?, ?> generator) {
        this.stack.push(Objects.requireNonNull(generator));
    }

    void exit() {
        this.stack.pop();
    }

    @NonNull AbstractAugmentGenerator getAugment(AugmentEffectiveStatement statement) {
        for (AbstractCompositeGenerator<?, ?> generator : this.stack) {
            AbstractAugmentGenerator found = this.findAugment(generator, statement);
            if (found == null) continue;
            return found;
        }
        throw new IllegalStateException("Failed to resolve " + String.valueOf(statement) + " in " + String.valueOf(this.stack));
    }

    private @Nullable AbstractAugmentGenerator findAugment(AbstractCompositeGenerator<?, ?> generator, AugmentEffectiveStatement statement) {
        for (AbstractAugmentGenerator augment : generator.augments()) {
            if (!augment.matchesInstantiated(statement)) continue;
            return augment;
        }
        for (GroupingGenerator grouping : generator.groupings()) {
            AbstractAugmentGenerator found = this.findAugment(grouping, statement);
            if (found == null) continue;
            return found;
        }
        return null;
    }
}

