/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.binding.generator.impl.reactor;

import com.google.common.base.Verify;
import org.opendaylight.yangtools.binding.YangFeature;
import org.opendaylight.yangtools.binding.contract.StatementNamespace;
import org.opendaylight.yangtools.binding.generator.impl.reactor.AbstractExplicitGenerator;
import org.opendaylight.yangtools.binding.generator.impl.reactor.AugmentResolver;
import org.opendaylight.yangtools.binding.generator.impl.reactor.ModuleGenerator;
import org.opendaylight.yangtools.binding.generator.impl.reactor.TypeBuilderFactory;
import org.opendaylight.yangtools.binding.generator.impl.rt.DefaultFeatureRuntimeType;
import org.opendaylight.yangtools.binding.model.api.GeneratedTransferObject;
import org.opendaylight.yangtools.binding.model.api.GeneratedType;
import org.opendaylight.yangtools.binding.model.api.JavaTypeName;
import org.opendaylight.yangtools.binding.model.api.Type;
import org.opendaylight.yangtools.binding.model.api.type.builder.AnnotableTypeBuilder;
import org.opendaylight.yangtools.binding.model.api.type.builder.GeneratedTOBuilder;
import org.opendaylight.yangtools.binding.model.api.type.builder.GeneratedTypeBuilderBase;
import org.opendaylight.yangtools.binding.model.ri.BindingTypes;
import org.opendaylight.yangtools.binding.runtime.api.FeatureRuntimeType;
import org.opendaylight.yangtools.concepts.Identifiable;
import org.opendaylight.yangtools.yang.common.UnresolvedQName;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.FeatureEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ModuleEffectiveStatement;
import org.opendaylight.yangtools.yang.model.util.SchemaInferenceStack;

final class FeatureGenerator
extends AbstractExplicitGenerator<FeatureEffectiveStatement, FeatureRuntimeType> {
    FeatureGenerator(FeatureEffectiveStatement statement, ModuleGenerator parent) {
        super(statement, parent);
    }

    @Override
    StatementNamespace namespace() {
        return StatementNamespace.FEATURE;
    }

    @Override
    void pushToInference(SchemaInferenceStack inferenceStack) {
        throw new UnsupportedOperationException("Cannot push " + String.valueOf(this.statement()) + " to data tree");
    }

    @Override
    FeatureRuntimeType createExternalRuntimeType(Type type) {
        Verify.verify((boolean)(type instanceof GeneratedTransferObject), (String)"Unexpected type %s", (Object)type);
        return new DefaultFeatureRuntimeType((GeneratedType)((GeneratedTransferObject)type), (FeatureEffectiveStatement)this.statement());
    }

    @Override
    FeatureRuntimeType createInternalRuntimeType(AugmentResolver resolver, FeatureEffectiveStatement statement, Type type) {
        throw new UnsupportedOperationException("Should never be called");
    }

    GeneratedTransferObject createTypeImpl(TypeBuilderFactory builderFactory) {
        GeneratedTOBuilder builder = builderFactory.newGeneratedTOBuilder(this.typeName());
        builder.addImplementsType((Type)BindingTypes.yangFeature((Type)builder, (Type)Type.of((JavaTypeName)this.getParent().typeName())));
        FeatureGenerator.annotateDeprecatedIfNecessary(this.statement(), (AnnotableTypeBuilder)builder);
        ModuleGenerator module = this.currentModule();
        module.addQNameConstant((GeneratedTypeBuilderBase<?>)builder, this.localName());
        builder.addConstant(Type.of((Identifiable)builder), "VALUE", YangFeature.class);
        builderFactory.addCodegenInformation(module, (EffectiveStatement<?, ?>)this.statement(), (GeneratedTypeBuilderBase<?>)builder);
        builder.setModuleName(((UnresolvedQName.Unqualified)((ModuleEffectiveStatement)module.statement()).argument()).getLocalName());
        return builder.build();
    }

    @Override
    void addAsGetterMethod(GeneratedTypeBuilderBase<?> builder, TypeBuilderFactory builderFactory) {
    }
}

