/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.binding.generator.impl.reactor;

import com.google.common.base.VerifyException;
import java.util.List;
import org.opendaylight.yangtools.binding.contract.StatementNamespace;
import org.opendaylight.yangtools.binding.generator.impl.reactor.CompositeRuntimeTypeBuilder;
import org.opendaylight.yangtools.binding.generator.impl.reactor.CompositeSchemaTreeGenerator;
import org.opendaylight.yangtools.binding.generator.impl.reactor.GroupingGenerator;
import org.opendaylight.yangtools.binding.generator.impl.reactor.TypeBuilderFactory;
import org.opendaylight.yangtools.binding.generator.impl.rt.DefaultNotificationBodyRuntimeType;
import org.opendaylight.yangtools.binding.model.api.GeneratedType;
import org.opendaylight.yangtools.binding.model.api.Type;
import org.opendaylight.yangtools.binding.model.api.type.builder.AnnotableTypeBuilder;
import org.opendaylight.yangtools.binding.model.api.type.builder.GeneratedTypeBuilder;
import org.opendaylight.yangtools.binding.model.api.type.builder.GeneratedTypeBuilderBase;
import org.opendaylight.yangtools.binding.model.ri.BindingTypes;
import org.opendaylight.yangtools.binding.runtime.api.AugmentRuntimeType;
import org.opendaylight.yangtools.binding.runtime.api.NotificationBodyRuntimeType;
import org.opendaylight.yangtools.binding.runtime.api.RuntimeType;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.NotificationEffectiveStatement;
import org.opendaylight.yangtools.yang.model.util.SchemaInferenceStack;

final class NotificationBodyGenerator
extends CompositeSchemaTreeGenerator<NotificationEffectiveStatement, NotificationBodyRuntimeType> {
    NotificationBodyGenerator(NotificationEffectiveStatement statement, GroupingGenerator parent) {
        super(statement, parent);
    }

    @Override
    StatementNamespace namespace() {
        return StatementNamespace.NOTIFICATION;
    }

    @Override
    void pushToInference(SchemaInferenceStack dataTree) {
        dataTree.enterSchemaTree((QName)((NotificationEffectiveStatement)this.statement()).argument());
    }

    @Override
    GeneratedType createTypeImpl(TypeBuilderFactory builderFactory) {
        GeneratedTypeBuilder builder = builderFactory.newGeneratedTypeBuilder(this.typeName());
        builder.addImplementsType((Type)BindingTypes.notificationBody((Type)builder));
        NotificationBodyGenerator.narrowImplementedInterface(builder);
        this.addUsesInterfaces(builder, builderFactory);
        this.addGetterMethods(builder, builderFactory);
        this.annotateDeprecatedIfNecessary((AnnotableTypeBuilder)builder);
        builderFactory.addCodegenInformation(this.currentModule(), (EffectiveStatement<?, ?>)this.statement(), (GeneratedTypeBuilderBase<?>)builder);
        return builder.build();
    }

    @Override
    void addAsGetterMethod(GeneratedTypeBuilderBase<?> builder, TypeBuilderFactory builderFactory) {
    }

    @Override
    CompositeRuntimeTypeBuilder<NotificationEffectiveStatement, NotificationBodyRuntimeType> createBuilder(NotificationEffectiveStatement statement) {
        return new CompositeRuntimeTypeBuilder<NotificationEffectiveStatement, NotificationBodyRuntimeType>(this, statement){

            @Override
            NotificationBodyRuntimeType build(GeneratedType type, NotificationEffectiveStatement statement, List<RuntimeType> children, List<AugmentRuntimeType> augments) {
                if (augments.isEmpty()) {
                    return new DefaultNotificationBodyRuntimeType(type, statement, children);
                }
                throw new VerifyException("Unexpected augments " + String.valueOf(augments));
            }
        };
    }
}

