/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.binding.generator.impl.rt;

import com.google.common.base.Functions;
import com.google.common.base.VerifyException;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.binding.generator.impl.rt.AbstractRuntimeType;
import org.opendaylight.yangtools.binding.model.api.GeneratedType;
import org.opendaylight.yangtools.binding.model.api.JavaTypeName;
import org.opendaylight.yangtools.binding.runtime.api.CompositeRuntimeType;
import org.opendaylight.yangtools.binding.runtime.api.GeneratedRuntimeType;
import org.opendaylight.yangtools.binding.runtime.api.RuntimeType;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.SchemaTreeEffectiveStatement;

abstract class AbstractCompositeRuntimeType<S extends EffectiveStatement<?, ?>>
extends AbstractRuntimeType<S, GeneratedType>
implements CompositeRuntimeType {
    private static final RuntimeType[] EMPTY = new RuntimeType[0];
    private final ImmutableMap<JavaTypeName, GeneratedRuntimeType> byClass;
    private final Object bySchemaTree;

    AbstractCompositeRuntimeType(GeneratedType bindingType, S statement, List<RuntimeType> children) {
        super(bindingType, statement);
        this.byClass = (ImmutableMap)children.stream().filter(GeneratedRuntimeType.class::isInstance).map(GeneratedRuntimeType.class::cast).collect(ImmutableMap.toImmutableMap(GeneratedRuntimeType::getIdentifier, (Function)Functions.identity()));
        RuntimeType[] tmp = (RuntimeType[])children.stream().filter(child -> child.statement() instanceof SchemaTreeEffectiveStatement).toArray(RuntimeType[]::new);
        this.bySchemaTree = switch (tmp.length) {
            case 0 -> EMPTY;
            case 1 -> tmp[0];
            default -> {
                Arrays.sort(tmp, (o1, o2) -> {
                    int cmp = AbstractCompositeRuntimeType.extractQName(o1).compareTo(AbstractCompositeRuntimeType.extractQName(o2));
                    if (cmp == 0) {
                        throw new VerifyException("Type " + String.valueOf(o1) + " conflicts with " + String.valueOf(o2) + " on schema tree");
                    }
                    return cmp;
                });
                yield tmp;
            }
        };
    }

    public final RuntimeType schemaTreeChild(QName qname) {
        Object object = this.bySchemaTree;
        if (object instanceof RuntimeType) {
            RuntimeType tmp = (RuntimeType)object;
            return qname.equals(tmp.statement().argument()) ? tmp : null;
        }
        RuntimeType[] tmp = (RuntimeType[])this.bySchemaTree;
        int offset = Arrays.binarySearch(tmp, null, (o1, o2) -> AbstractCompositeRuntimeType.extractQName(Objects.requireNonNullElse(o1, o2)).compareTo(qname));
        return offset < 0 ? null : tmp[offset];
    }

    public final GeneratedRuntimeType bindingChild(JavaTypeName typeName) {
        return (GeneratedRuntimeType)this.byClass.get((Object)Objects.requireNonNull(typeName));
    }

    final <T extends RuntimeType> @NonNull List<T> schemaTree(Class<T> expectedType) {
        RuntimeType[] tmp;
        if (expectedType.isInstance(this.bySchemaTree)) {
            return List.of((RuntimeType)expectedType.cast(this.bySchemaTree));
        }
        for (RuntimeType item : tmp = (RuntimeType[])this.bySchemaTree) {
            if (expectedType.isInstance(item)) continue;
            throw new VerifyException("Unexpected schema tree child " + String.valueOf(item));
        }
        return Collections.unmodifiableList(Arrays.asList(tmp));
    }

    private static @NonNull QName extractQName(RuntimeType type) {
        EffectiveStatement stmt = type.statement();
        if (stmt instanceof SchemaTreeEffectiveStatement) {
            SchemaTreeEffectiveStatement schemaTreeStmt = (SchemaTreeEffectiveStatement)stmt;
            return (QName)schemaTreeStmt.argument();
        }
        throw new VerifyException("Unexpected statement " + String.valueOf(stmt) + " in " + String.valueOf(type));
    }
}

