/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.repo;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.AsyncFunction;
import com.google.common.util.concurrent.FluentFuture;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.util.concurrent.FluentFutures;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;
import org.opendaylight.yangtools.yang.model.api.source.SourceIdentifier;
import org.opendaylight.yangtools.yang.model.api.source.SourceRepresentation;
import org.opendaylight.yangtools.yang.model.repo.api.SchemaContextFactoryConfiguration;
import org.opendaylight.yangtools.yang.model.repo.api.SchemaResolutionException;
import org.opendaylight.yangtools.yang.model.spi.source.YangIRSource;
import org.opendaylight.yangtools.yang.parser.api.YangParser;
import org.opendaylight.yangtools.yang.parser.api.YangParserException;
import org.opendaylight.yangtools.yang.parser.api.YangParserFactory;
import org.opendaylight.yangtools.yang.parser.api.YangSyntaxErrorException;
import org.opendaylight.yangtools.yang.parser.repo.RevisionDependencyResolver;
import org.opendaylight.yangtools.yang.parser.rfc7950.repo.YangIRSourceInfoExtractor;
import org.opendaylight.yangtools.yang.parser.spi.meta.ReactorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class AssembleSources
implements AsyncFunction<List<YangIRSource>, EffectiveModelContext> {
    private static final Logger LOG = LoggerFactory.getLogger(AssembleSources.class);
    private final @NonNull Function<YangIRSource, SourceIdentifier> getIdentifier;
    private final @NonNull SchemaContextFactoryConfiguration config;
    private final @NonNull YangParserFactory parserFactory;

    AssembleSources(@NonNull YangParserFactory parserFactory, @NonNull SchemaContextFactoryConfiguration config) {
        this.parserFactory = parserFactory;
        this.config = config;
        switch (config.getStatementParserMode()) {
            default: {
                throw new MatchException(null, null);
            }
            case DEFAULT_MODE: 
        }
        this.getIdentifier = YangIRSource::sourceId;
    }

    public FluentFuture<EffectiveModelContext> apply(List<YangIRSource> sources) {
        EffectiveModelContext schemaContext;
        ImmutableMap srcs = Maps.uniqueIndex(sources, this.getIdentifier);
        Map deps = Maps.transformValues((Map)srcs, YangIRSourceInfoExtractor::forIR);
        LOG.debug("Resolving dependency reactor {}", (Object)deps);
        switch (this.config.getStatementParserMode()) {
            default: {
                throw new MatchException(null, null);
            }
            case DEFAULT_MODE: 
        }
        RevisionDependencyResolver res = new RevisionDependencyResolver(deps);
        ImmutableList<SourceIdentifier> unresolved = res.unresolvedSources();
        if (!unresolved.isEmpty()) {
            LOG.debug("Omitting models {} due to unsatisfied imports {}", unresolved, res.unsatisfiedImports());
            return FluentFutures.immediateFailedFluentFuture((Throwable)new SchemaResolutionException("Failed to resolve required models", (SourceIdentifier)unresolved.getFirst(), res.resolvedSources(), res.unsatisfiedImports()));
        }
        YangParser parser = this.parserFactory.createParser(res.parserConfig());
        this.config.getSupportedFeatures().ifPresent(arg_0 -> ((YangParser)parser).setSupportedFeatures(arg_0));
        this.config.getModulesDeviatedByModules().ifPresent(arg_0 -> ((YangParser)parser).setModulesWithSupportedDeviations(arg_0));
        for (Map.Entry entry : srcs.entrySet()) {
            try {
                parser.addSource((SourceRepresentation)entry.getValue());
            }
            catch (IOException | YangSyntaxErrorException e) {
                SourceIdentifier sourceId = (SourceIdentifier)entry.getKey();
                return FluentFutures.immediateFailedFluentFuture((Throwable)new SchemaResolutionException("Failed to add source " + String.valueOf(sourceId), sourceId, e));
            }
        }
        try {
            schemaContext = parser.buildEffectiveModel();
        }
        catch (YangParserException e) {
            YangParserException yangParserException;
            Throwable throwable = e.getCause();
            if (throwable instanceof ReactorException) {
                ReactorException re = (ReactorException)throwable;
                yangParserException = new SchemaResolutionException("Failed to resolve required models", re.getSourceIdentifier(), (Throwable)re);
            } else {
                yangParserException = e;
            }
            return FluentFutures.immediateFailedFluentFuture((Throwable)yangParserException);
        }
        return FluentFutures.immediateFluentFuture((Object)schemaContext);
    }
}

