/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.repo;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.opendaylight.yangtools.yang.model.api.source.SourceDependency;
import org.opendaylight.yangtools.yang.model.api.source.SourceIdentifier;
import org.opendaylight.yangtools.yang.model.spi.source.SourceInfo;
import org.opendaylight.yangtools.yang.parser.api.YangParserConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class DependencyResolver {
    private static final Logger LOG = LoggerFactory.getLogger(DependencyResolver.class);
    private final ImmutableList<SourceIdentifier> resolvedSources;
    private final ImmutableList<SourceIdentifier> unresolvedSources;
    private final ImmutableMultimap<SourceIdentifier, SourceDependency> unsatisfiedImports;

    DependencyResolver(Map<SourceIdentifier, SourceInfo> depInfo) {
        SourceInfo.Submodule submodule;
        boolean progress;
        HashSet<SourceIdentifier> resolved = HashSet.newHashSet(depInfo.size());
        HashMap<SourceIdentifier, SourceInfo> pending = new HashMap<SourceIdentifier, SourceInfo>(depInfo);
        ArrayList<SourceInfo.Submodule> submodules = new ArrayList<SourceInfo.Submodule>();
        do {
            progress = false;
            Iterator<Object> it = pending.values().iterator();
            while (it.hasNext()) {
                SourceInfo dep = it.next();
                if (!this.tryResolve(resolved, dep)) continue;
                SourceIdentifier sourceId = dep.sourceId();
                LOG.debug("Resolved source {}", (Object)sourceId);
                resolved.add(sourceId);
                it.remove();
                progress = true;
                if (!(dep instanceof SourceInfo.Submodule)) continue;
                submodule = (SourceInfo.Submodule)dep;
                submodules.add(submodule);
            }
        } while (progress);
        for (SourceInfo.Submodule submodule2 : submodules) {
            SourceDependency.BelongsTo belongsTo = submodule2.belongsTo();
            if (this.isKnown(resolved, (SourceDependency)belongsTo)) continue;
            SourceIdentifier sourceId = submodule2.sourceId();
            LOG.debug("Source {} is missing belongs-to {}", (Object)sourceId, (Object)belongsTo);
            pending.put(sourceId, (SourceInfo)submodule2);
            resolved.remove(sourceId);
        }
        this.resolvedSources = ImmutableList.copyOf(resolved);
        this.unresolvedSources = ImmutableList.copyOf(pending.keySet());
        ImmutableMultimap.Builder unstatisfied = ImmutableMultimap.builder();
        for (SourceInfo info : pending.values()) {
            SourceDependency.Import dep2;
            for (SourceDependency.Import dep2 : info.imports()) {
                if (this.isKnown(depInfo.keySet(), (SourceDependency)dep2)) continue;
                unstatisfied.put((Object)info.sourceId(), (Object)dep2);
            }
            for (SourceDependency.Import dep2 : info.includes()) {
                if (this.isKnown(depInfo.keySet(), (SourceDependency)dep2)) continue;
                unstatisfied.put((Object)info.sourceId(), (Object)dep2);
            }
            if (!(info instanceof SourceInfo.Submodule)) continue;
            submodule = (SourceInfo.Submodule)info;
            dep2 = submodule.belongsTo();
            if (this.isKnown(depInfo.keySet(), (SourceDependency)dep2)) continue;
            unstatisfied.put((Object)info.sourceId(), (Object)dep2);
        }
        this.unsatisfiedImports = unstatisfied.build();
    }

    final ImmutableList<SourceIdentifier> resolvedSources() {
        return this.resolvedSources;
    }

    final ImmutableList<SourceIdentifier> unresolvedSources() {
        return this.unresolvedSources;
    }

    final ImmutableMultimap<SourceIdentifier, SourceDependency> unsatisfiedImports() {
        return this.unsatisfiedImports;
    }

    private boolean tryResolve(Collection<SourceIdentifier> resolved, SourceInfo info) {
        for (SourceDependency.Import dep : info.imports()) {
            if (this.isKnown(resolved, (SourceDependency)dep)) continue;
            LOG.debug("Source {} is missing import {}", (Object)info.sourceId(), (Object)dep);
            return false;
        }
        for (SourceDependency.Import dep : info.includes()) {
            if (this.isKnown(resolved, (SourceDependency)dep)) continue;
            LOG.debug("Source {} is missing include {}", (Object)info.sourceId(), (Object)dep);
            return false;
        }
        return true;
    }

    abstract boolean isKnown(Collection<SourceIdentifier> var1, SourceDependency var2);

    abstract YangParserConfiguration parserConfig();
}

